/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.CombineWayAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.Geometry;

public class ParallelWays {
    final List<Way> ways;
    private final List<Node> sortedNodes;
    private final int nodeCount;
    private final EastNorth[] pts;
    private final EastNorth[] normals;

    public ParallelWays(Collection<Way> collection, boolean bl, int n) {
        int n2;
        Object object;
        HashMap<Node, Node> hashMap = new HashMap<Node, Node>(collection.size());
        for (Way list2 : collection) {
            if (!hashMap.containsKey(list2.firstNode())) {
                hashMap.put(list2.firstNode(), ParallelWays.copyNode(list2.firstNode(), bl));
            }
            if (hashMap.containsKey(list2.lastNode())) continue;
            hashMap.put(list2.lastNode(), ParallelWays.copyNode(list2.lastNode(), bl));
        }
        this.ways = new ArrayList<Way>(collection.size());
        for (Way way : collection) {
            object = new Way();
            ((Way)object).addNode((Node)hashMap.get(way.firstNode()));
            for (n2 = 1; n2 < way.getNodesCount() - 1; ++n2) {
                ((Way)object).addNode(ParallelWays.copyNode(way.getNode(n2), bl));
            }
            ((Way)object).addNode((Node)hashMap.get(way.lastNode()));
            if (bl) {
                ((OsmPrimitive)object).setKeys(way.getKeys());
            }
            this.ways.add((Way)object);
        }
        collection = null;
        CombineWayAction.NodeGraph nodeGraph = CombineWayAction.NodeGraph.createUndirectedGraphFromNodeWays(this.ways);
        List<Node> list = nodeGraph.buildSpanningPath();
        if (list == null) {
            throw new IllegalArgumentException("Ways must have spanning path");
        }
        object = new HashSet();
        this.sortedNodes = new ArrayList<Node>();
        for (n2 = 0; n2 < list.size(); ++n2) {
            Node d = list.get(n2);
            if (n2 < list.size() - 1 && list.get(n2 + 1).getCoor().equals(d.getCoor())) {
                object.add(d);
                for (Way way : this.ways) {
                    way.removeNode(d);
                }
                continue;
            }
            if (object.contains(d)) continue;
            this.sortedNodes.add(d);
        }
        Way way = this.ways.get(n);
        boolean bl2 = true;
        for (int i = 0; i < this.sortedNodes.size() - 1; ++i) {
            if (this.sortedNodes.get(i) != way.firstNode() || this.sortedNodes.get(i + 1) != way.getNode(1)) continue;
            bl2 = false;
            break;
        }
        if (bl2) {
            Collections.reverse(this.sortedNodes);
        }
        this.nodeCount = this.sortedNodes.size();
        this.pts = new EastNorth[this.nodeCount];
        this.normals = new EastNorth[this.nodeCount - 1];
        int n3 = 0;
        for (Node node : this.sortedNodes) {
            EastNorth eastNorth;
            this.pts[n3] = eastNorth = node.getEastNorth();
            ++n3;
        }
        for (n3 = 0; n3 < this.nodeCount - 1; ++n3) {
            double d = this.pts[n3 + 1].getX() - this.pts[n3].getX();
            double d2 = this.pts[n3 + 1].getY() - this.pts[n3].getY();
            double d3 = Math.sqrt(d * d + d2 * d2);
            this.normals[n3] = new EastNorth(-d2 / d3, d / d3);
        }
    }

    public boolean isClosedPath() {
        return this.sortedNodes.get(0) == this.sortedNodes.get(this.sortedNodes.size() - 1);
    }

    public void changeOffset(double d) {
        EastNorth eastNorth;
        EastNorth[] eastNorthArray = new EastNorth[this.nodeCount];
        EastNorth eastNorth2 = this.pts[0].add(this.normals[0].scale(d));
        EastNorth eastNorth3 = this.pts[1].add(this.normals[0].scale(d));
        for (int i = 1; i < this.nodeCount - 1; ++i) {
            EastNorth eastNorth4;
            eastNorth = this.pts[i].add(this.normals[i].scale(d));
            eastNorthArray[i] = Geometry.segmentsParallel(eastNorth, eastNorth4 = this.pts[i + 1].add(this.normals[i].scale(d)), eastNorth2, eastNorth3) ? eastNorth : Geometry.getLineLineIntersection(eastNorth, eastNorth4, eastNorth2, eastNorth3);
            eastNorth2 = eastNorth;
            eastNorth3 = eastNorth4;
        }
        if (this.isClosedPath()) {
            EastNorth eastNorth5 = this.pts[0].add(this.normals[0].scale(d));
            eastNorthArray[0] = Geometry.segmentsParallel(eastNorth5, eastNorth = this.pts[1].add(this.normals[0].scale(d)), eastNorth2, eastNorth3) ? eastNorth5 : Geometry.getLineLineIntersection(eastNorth5, eastNorth, eastNorth2, eastNorth3);
            eastNorthArray[this.nodeCount - 1] = eastNorthArray[0];
        } else {
            eastNorthArray[0] = this.pts[0].add(this.normals[0].scale(d));
            eastNorthArray[this.nodeCount - 1] = this.pts[this.nodeCount - 1].add(this.normals[this.nodeCount - 2].scale(d));
        }
        for (int i = 0; i < this.nodeCount; ++i) {
            this.sortedNodes.get(i).setEastNorth(eastNorthArray[i]);
        }
    }

    public void commit() {
        SequenceCommand sequenceCommand = new SequenceCommand("Make parallel way(s)", this.makeAddWayAndNodesCommandList());
        Main.main.undoRedo.add(sequenceCommand);
    }

    private List<Command> makeAddWayAndNodesCommandList() {
        ArrayList<Command> arrayList = new ArrayList<Command>(this.sortedNodes.size() + this.ways.size());
        for (int i = 0; i < this.sortedNodes.size() - (this.isClosedPath() ? 1 : 0); ++i) {
            arrayList.add(new AddCommand(this.sortedNodes.get(i)));
        }
        for (Way way : this.ways) {
            arrayList.add(new AddCommand(way));
        }
        return arrayList;
    }

    private static Node copyNode(Node node, boolean bl) {
        if (bl) {
            return new Node(node, true);
        }
        Node node2 = new Node();
        node2.setCoor(node.getCoor());
        return node2;
    }
}

