/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.downloadtasks.AbstractDownloadTask;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.BoundingBoxDownloader;
import org.openstreetmap.josm.io.OsmServerLocationReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferCanceledException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class DownloadOsmTask
extends AbstractDownloadTask {
    private static final String PATTERN_OSM_API_URL = "http://.*/api/0.6/(map|nodes?|ways?|relations?|\\*).*";
    private static final String PATTERN_OVERPASS_API_URL = "http://.*/interpreter\\?data=.*";
    private static final String PATTERN_OVERPASS_API_XAPI_URL = "http://.*/xapi(\\?.*\\[@meta\\]|_meta\\?).*";
    private static final String PATTERN_EXTERNAL_OSM_FILE = "https?://.*/.*\\.osm";
    protected Bounds currentBounds;
    protected DataSet downloadedData;
    protected DownloadTask downloadTask;
    protected OsmDataLayer targetLayer;
    protected String newLayerName = null;

    @Override
    public String[] getPatterns() {
        if (this.getClass() == DownloadOsmTask.class) {
            return new String[]{PATTERN_OSM_API_URL, PATTERN_OVERPASS_API_URL, PATTERN_OVERPASS_API_XAPI_URL, PATTERN_EXTERNAL_OSM_FILE};
        }
        return super.getPatterns();
    }

    @Override
    public String getTitle() {
        if (this.getClass() == DownloadOsmTask.class) {
            return I18n.tr("Download OSM", new Object[0]);
        }
        return super.getTitle();
    }

    protected void rememberDownloadedData(DataSet dataSet) {
        this.downloadedData = dataSet;
    }

    public DataSet getDownloadedData() {
        return this.downloadedData;
    }

    @Override
    public Future<?> download(boolean bl, Bounds bounds, ProgressMonitor progressMonitor) {
        return this.download(new BoundingBoxDownloader(bounds), bl, bounds, progressMonitor);
    }

    public Future<?> download(OsmServerReader osmServerReader, boolean bl, Bounds bounds, ProgressMonitor progressMonitor) {
        return this.download(new DownloadTask(bl, osmServerReader, progressMonitor), bounds);
    }

    protected Future<?> download(DownloadTask downloadTask, Bounds bounds) {
        this.downloadTask = downloadTask;
        this.currentBounds = new Bounds(bounds);
        return Main.worker.submit(downloadTask);
    }

    protected final String encodePartialUrl(String string, String string2) {
        int n;
        if (string != null && string2 != null && (n = string.indexOf(string2)) > -1) {
            n += string2.length();
            try {
                return string.substring(0, n) + URLEncoder.encode(string.substring(n), "UTF-8").replaceAll("\\+", "%20");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }
        return string;
    }

    @Override
    public Future<?> loadUrl(boolean bl, String string, ProgressMonitor progressMonitor) {
        if (string.matches(PATTERN_OVERPASS_API_URL)) {
            string = this.encodePartialUrl(string, "/interpreter?data=");
        } else if (string.matches(PATTERN_OVERPASS_API_XAPI_URL)) {
            string = this.encodePartialUrl(string, "/xapi?");
        }
        this.downloadTask = new DownloadTask(bl, new OsmServerLocationReader(string), progressMonitor);
        this.currentBounds = null;
        this.extractOsmFilename("https?://.*/(.*\\.osm)", string);
        return Main.worker.submit(this.downloadTask);
    }

    protected final void extractOsmFilename(String string, String string2) {
        Matcher matcher = Pattern.compile(string).matcher(string2);
        this.newLayerName = matcher.matches() ? matcher.group(1) : null;
    }

    @Override
    public void cancel() {
        if (this.downloadTask != null) {
            this.downloadTask.cancel();
        }
    }

    @Override
    public String getConfirmationMessage(URL uRL) {
        String string;
        if (uRL != null && (string = uRL.toExternalForm()).matches(PATTERN_OSM_API_URL)) {
            String string2 = "<ul><li>" + I18n.tr("OSM Server URL:", new Object[0]) + " " + uRL.getHost() + "</li><li>" + I18n.tr("Command", new Object[0]) + ": " + uRL.getPath() + "</li>";
            if (uRL.getQuery() != null) {
                string2 = string2 + "<li>" + I18n.tr("Request details: {0}", uRL.getQuery().replaceAll(",\\s*", ", ")) + "</li>";
            }
            string2 = string2 + "</ul>";
            return string2;
        }
        return null;
    }

    protected class DownloadTask
    extends PleaseWaitRunnable {
        protected OsmServerReader reader;
        protected DataSet dataSet;
        protected boolean newLayer;

        public DownloadTask(boolean bl, OsmServerReader osmServerReader, ProgressMonitor progressMonitor) {
            super(I18n.tr("Downloading data", new Object[0]), progressMonitor, false);
            this.reader = osmServerReader;
            this.newLayer = bl;
        }

        protected DataSet parseDataSet() throws OsmTransferException {
            return this.reader.parseOsm(this.progressMonitor.createSubTaskMonitor(-1, false));
        }

        @Override
        public void realRun() throws IOException, SAXException, OsmTransferException {
            try {
                if (DownloadOsmTask.this.isCanceled()) {
                    return;
                }
                this.dataSet = this.parseDataSet();
            }
            catch (Exception exception) {
                if (DownloadOsmTask.this.isCanceled()) {
                    Main.info(I18n.tr("Ignoring exception because download has been canceled. Exception was: {0}", exception.toString()));
                    return;
                }
                if (exception instanceof OsmTransferCanceledException) {
                    DownloadOsmTask.this.setCanceled(true);
                    return;
                }
                if (exception instanceof OsmTransferException) {
                    DownloadOsmTask.this.rememberException(exception);
                } else {
                    DownloadOsmTask.this.rememberException(new OsmTransferException(exception));
                }
                DownloadOsmTask.this.setFailed(true);
            }
        }

        protected OsmDataLayer getEditLayer() {
            if (!Main.isDisplayingMapView()) {
                return null;
            }
            return Main.main.getEditLayer();
        }

        protected int getNumDataLayers() {
            int n = 0;
            if (!Main.isDisplayingMapView()) {
                return 0;
            }
            Collection<Layer> collection = Main.map.mapView.getAllLayers();
            for (Layer layer : collection) {
                if (!(layer instanceof OsmDataLayer)) continue;
                ++n;
            }
            return n;
        }

        protected OsmDataLayer getFirstDataLayer() {
            if (!Main.isDisplayingMapView()) {
                return null;
            }
            List<Layer> list = Main.map.mapView.getAllLayersAsList();
            for (Layer layer : list) {
                if (!(layer instanceof OsmDataLayer)) continue;
                return (OsmDataLayer)layer;
            }
            return null;
        }

        protected OsmDataLayer createNewLayer(String string) {
            if (string == null || string.isEmpty()) {
                string = OsmDataLayer.createNewName();
            }
            return new OsmDataLayer(this.dataSet, string, null);
        }

        protected OsmDataLayer createNewLayer() {
            return this.createNewLayer(null);
        }

        @Override
        protected void finish() {
            if (DownloadOsmTask.this.isFailed() || DownloadOsmTask.this.isCanceled()) {
                return;
            }
            if (this.dataSet == null) {
                return;
            }
            if (this.dataSet.allPrimitives().isEmpty()) {
                DownloadOsmTask.this.rememberErrorMessage(I18n.tr("No data found in this area.", new Object[0]));
                this.dataSet.dataSources.add(new DataSource(DownloadOsmTask.this.currentBounds != null ? DownloadOsmTask.this.currentBounds : new Bounds(new LatLon(0.0, 0.0)), "OpenStreetMap server"));
            }
            DownloadOsmTask.this.rememberDownloadedData(this.dataSet);
            int n = this.getNumDataLayers();
            if (this.newLayer || n == 0 || n > 1 && this.getEditLayer() == null) {
                DownloadOsmTask.this.targetLayer = this.createNewLayer(DownloadOsmTask.this.newLayerName);
                boolean bl = Main.isDisplayingMapView();
                Main.main.addLayer(DownloadOsmTask.this.targetLayer);
                if (bl) {
                    this.computeBboxAndCenterScale();
                }
            } else {
                DownloadOsmTask.this.targetLayer = this.getEditLayer();
                if (DownloadOsmTask.this.targetLayer == null) {
                    DownloadOsmTask.this.targetLayer = this.getFirstDataLayer();
                }
                DownloadOsmTask.this.targetLayer.mergeFrom(this.dataSet);
                this.computeBboxAndCenterScale();
                DownloadOsmTask.this.targetLayer.onPostDownloadFromServer();
            }
        }

        protected void computeBboxAndCenterScale() {
            BoundingXYVisitor boundingXYVisitor = new BoundingXYVisitor();
            if (DownloadOsmTask.this.currentBounds != null) {
                boundingXYVisitor.visit(DownloadOsmTask.this.currentBounds);
            } else {
                boundingXYVisitor.computeBoundingBox(this.dataSet.getNodes());
            }
            Main.map.mapView.recalculateCenterScale(boundingXYVisitor);
        }

        @Override
        protected void cancel() {
            DownloadOsmTask.this.setCanceled(true);
            if (this.reader != null) {
                this.reader.cancel();
            }
        }
    }
}

