/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.upload.ApiPreconditionCheckerHook;
import org.openstreetmap.josm.actions.upload.DiscardTagsHook;
import org.openstreetmap.josm.actions.upload.FixDataHook;
import org.openstreetmap.josm.actions.upload.RelationUploadOrderHook;
import org.openstreetmap.josm.actions.upload.UploadHook;
import org.openstreetmap.josm.actions.upload.ValidateUploadHook;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.UploadDialog;
import org.openstreetmap.josm.gui.io.UploadPrimitivesTask;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class UploadAction
extends JosmAction {
    private static final List<UploadHook> uploadHooks = new LinkedList<UploadHook>();
    private static final List<UploadHook> lateUploadHooks = new LinkedList<UploadHook>();

    public static void registerUploadHook(UploadHook uploadHook) {
        UploadAction.registerUploadHook(uploadHook, false);
    }

    public static void registerUploadHook(UploadHook uploadHook, boolean bl) {
        if (uploadHook == null) {
            return;
        }
        if (bl) {
            if (!lateUploadHooks.contains(uploadHook)) {
                lateUploadHooks.add(0, uploadHook);
            }
        } else if (!uploadHooks.contains(uploadHook)) {
            uploadHooks.add(0, uploadHook);
        }
    }

    public static void unregisterUploadHook(UploadHook uploadHook) {
        if (uploadHook == null) {
            return;
        }
        if (uploadHooks.contains(uploadHook)) {
            uploadHooks.remove(uploadHook);
        }
        if (lateUploadHooks.contains(uploadHook)) {
            lateUploadHooks.remove(uploadHook);
        }
    }

    public UploadAction() {
        super(I18n.tr("Upload data", new Object[0]), "upload", I18n.tr("Upload all changes in the active data layer to the OSM server", new Object[0]), Shortcut.registerShortcut("file:upload", I18n.tr("File: {0}", I18n.tr("Upload data", new Object[0])), 38, 5009), true);
        this.putValue("help", HelpUtil.ht("/Action/Upload"));
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(UploadAction.getEditLayer() != null);
    }

    public boolean checkPreUploadConditions(OsmDataLayer osmDataLayer) {
        return this.checkPreUploadConditions(osmDataLayer, new APIDataSet(osmDataLayer.data));
    }

    protected static void alertUnresolvedConflicts(OsmDataLayer osmDataLayer) {
        HelpAwareOptionPane.showOptionDialog(Main.parent, I18n.tr("<html>The data to be uploaded participates in unresolved conflicts of layer ''{0}''.<br>You have to resolve them first.</html>", osmDataLayer.getName()), I18n.tr("Warning", new Object[0]), 2, HelpUtil.ht("/Action/Upload#PrimitivesParticipateInConflicts"));
    }

    public static boolean warnUploadDiscouraged(OsmDataLayer osmDataLayer) {
        return GuiHelper.warnUser(I18n.tr("Upload discouraged", new Object[0]), "<html>" + I18n.tr("You are about to upload data from the layer ''{0}''.<br /><br />Sending data from this layer is <b>strongly discouraged</b>. If you continue,<br />it may require you subsequently have to revert your changes, or force other contributors to.<br /><br />Are you sure you want to continue?", osmDataLayer.getName()) + "</html>", ImageProvider.get("upload"), I18n.tr("Ignore this hint and upload anyway", new Object[0]));
    }

    public boolean checkPreUploadConditions(OsmDataLayer osmDataLayer, APIDataSet aPIDataSet) {
        if (osmDataLayer.isUploadDiscouraged() && UploadAction.warnUploadDiscouraged(osmDataLayer)) {
            return false;
        }
        ConflictCollection conflictCollection = osmDataLayer.getConflicts();
        if (aPIDataSet.participatesInConflict(conflictCollection)) {
            UploadAction.alertUnresolvedConflicts(osmDataLayer);
            return false;
        }
        for (UploadHook uploadHook : uploadHooks) {
            if (uploadHook.checkUpload(aPIDataSet)) continue;
            return false;
        }
        return true;
    }

    public void uploadData(final OsmDataLayer osmDataLayer, APIDataSet aPIDataSet) {
        if (aPIDataSet.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("No changes to upload.", new Object[0]), I18n.tr("Warning", new Object[0]), 1);
            return;
        }
        if (!this.checkPreUploadConditions(osmDataLayer, aPIDataSet)) {
            return;
        }
        final UploadDialog uploadDialog = UploadDialog.getUploadDialog();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                uploadDialog.setDefaultChangesetTags(osmDataLayer.data.getChangeSetTags());
            }
        });
        uploadDialog.setUploadedPrimitives(aPIDataSet);
        uploadDialog.setVisible(true);
        if (uploadDialog.isCanceled()) {
            return;
        }
        uploadDialog.rememberUserInput();
        for (UploadHook uploadHook : lateUploadHooks) {
            if (uploadHook.checkUpload(aPIDataSet)) continue;
            return;
        }
        Main.worker.execute(new UploadPrimitivesTask(UploadDialog.getUploadDialog().getUploadStrategySpecification(), osmDataLayer, aPIDataSet, UploadDialog.getUploadDialog().getChangeset()));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (Main.map == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Nothing to upload. Get some data first.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
            return;
        }
        APIDataSet aPIDataSet = new APIDataSet(Main.main.getCurrentDataSet());
        this.uploadData(Main.main.getEditLayer(), aPIDataSet);
    }

    static {
        uploadHooks.add(new ValidateUploadHook());
        uploadHooks.add(new FixDataHook());
        uploadHooks.add(new ApiPreconditionCheckerHook());
        uploadHooks.add(new RelationUploadOrderHook());
        lateUploadHooks.add(new DiscardTagsHook());
    }
}

