/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class DistributeAction
extends JosmAction {
    public DistributeAction() {
        super(I18n.tr("Distribute Nodes", new Object[0]), "distribute", I18n.tr("Distribute the selected nodes to equal distances along a line.", new Object[0]), Shortcut.registerShortcut("tools:distribute", I18n.tr("Tool: {0}", I18n.tr("Distribute Nodes", new Object[0])), 66, 5005), true);
        this.putValue("help", HelpUtil.ht("/Action/DistributeNodes"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        double d;
        if (!this.isEnabled()) {
            return;
        }
        Collection<OsmPrimitive> collection = DistributeAction.getCurrentDataSet().getSelected();
        LinkedList<Node> linkedList = new LinkedList<Node>();
        LinkedList<Node> linkedList2 = new LinkedList<Node>();
        for (OsmPrimitive osmPrimitive : collection) {
            if (!(osmPrimitive instanceof Node)) continue;
            linkedList.add((Node)osmPrimitive);
            linkedList2.add((Node)osmPrimitive);
        }
        if (linkedList.isEmpty() && collection.size() == 1) {
            for (OsmPrimitive osmPrimitive : collection) {
                if (!(osmPrimitive instanceof Way)) continue;
                linkedList.addAll(((Way)osmPrimitive).getNodes());
                linkedList2.addAll(((Way)osmPrimitive).getNodes());
            }
        }
        Iterator<OsmPrimitive> iterator = this.removeNodesWithoutCoordinates(linkedList);
        iterator.addAll(this.removeNodesWithoutCoordinates(linkedList2));
        if (!iterator.isEmpty()) {
            Main.warn(I18n.tr("Ignoring {0} nodes with null coordinates", iterator.size()));
            iterator.clear();
        }
        if (linkedList.size() < 3) {
            new Notification(I18n.tr("Please select at least three nodes.", new Object[0])).setIcon(1).setDuration(Notification.TIME_SHORT).show();
            return;
        }
        double d2 = 0.0;
        Node node = null;
        Node node2 = null;
        for (Node node3 : linkedList) {
            linkedList2.remove(node3);
            for (Node node4 : linkedList2) {
                d = Math.sqrt(node3.getEastNorth().distance(node4.getEastNorth()));
                if (!(d > d2)) continue;
                node = node3;
                node2 = node4;
                d2 = d;
            }
        }
        linkedList.remove(node);
        linkedList.remove(node2);
        double d3 = node.getEastNorth().east();
        double d4 = node.getEastNorth().north();
        d = node2.getEastNorth().east();
        double d5 = node2.getEastNorth().north();
        LinkedList<Command> linkedList3 = new LinkedList<Command>();
        int n = linkedList.size() + 1;
        int n2 = 0;
        while (!linkedList.isEmpty()) {
            double d6;
            ++n2;
            Node node5 = null;
            d2 = 0.0;
            for (Node node6 : linkedList) {
                d6 = Math.sqrt(node2.getEastNorth().distance(node6.getEastNorth()));
                if (!(d6 > d2)) continue;
                node5 = node6;
                d2 = d6;
            }
            double d7 = d3 - node5.getEastNorth().east() + (d - d3) * (double)n2 / (double)n;
            d6 = d4 - node5.getEastNorth().north() + (d5 - d4) * (double)n2 / (double)n;
            linkedList3.add(new MoveCommand((OsmPrimitive)node5, d7, d6));
            linkedList.remove(node5);
        }
        Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Distribute Nodes", new Object[0]), linkedList3));
        Main.map.repaint();
    }

    private Set<Node> removeNodesWithoutCoordinates(Collection<Node> collection) {
        HashSet<Node> hashSet = new HashSet<Node>();
        Iterator<Node> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Node node = iterator.next();
            if (node.getCoor() != null) continue;
            iterator.remove();
            hashSet.add(node);
        }
        return hashSet;
    }

    @Override
    protected void updateEnabledState() {
        if (DistributeAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(DistributeAction.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection != null && !collection.isEmpty());
    }
}

