/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.MultipolygonCreate;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class CreateMultipolygonAction
extends JosmAction {
    public static final List<String> DEFAULT_LINEAR_TAGS = Arrays.asList("barrier", "source");

    public CreateMultipolygonAction() {
        super(I18n.tr("Create multipolygon", new Object[0]), "multipoly_create", I18n.tr("Create multipolygon.", new Object[0]), Shortcut.registerShortcut("tools:multipoly", I18n.tr("Tool: {0}", I18n.tr("Create multipolygon", new Object[0])), 65, 5008), true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!Main.main.hasEditLayer()) {
            new Notification(I18n.tr("No data loaded.", new Object[0])).setIcon(2).setDuration(Notification.TIME_SHORT).show();
            return;
        }
        Collection<Way> collection = Main.main.getCurrentDataSet().getSelectedWays();
        if (collection.size() < 1) {
            new Notification(I18n.tr("You must select at least one way.", new Object[0])).setIcon(1).setDuration(Notification.TIME_SHORT).show();
            return;
        }
        MultipolygonCreate multipolygonCreate = this.analyzeWays(collection);
        if (multipolygonCreate == null) {
            return;
        }
        final Relation relation = this.createRelation(multipolygonCreate);
        if (Main.pref.getBoolean("multipoly.show-relation-editor", false)) {
            RelationEditor relationEditor = RelationEditor.getEditor(Main.main.getEditLayer(), relation, null);
            relationEditor.setModal(true);
            relationEditor.setVisible(true);
        } else {
            List<Command> list = this.removeTagsFromWaysIfNeeded(relation);
            list.add(new AddCommand(relation));
            Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Create multipolygon", new Object[0]), list));
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Main.map.relationListDialog.selectRelation(relation);
                }
            });
        }
    }

    @Override
    protected void updateEnabledState() {
        if (CreateMultipolygonAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(CreateMultipolygonAction.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection != null && !collection.isEmpty());
    }

    private MultipolygonCreate analyzeWays(Collection<Way> collection) {
        MultipolygonCreate multipolygonCreate = new MultipolygonCreate();
        String string = multipolygonCreate.makeFromWays(collection);
        if (string != null) {
            new Notification(string).setIcon(1).show();
            return null;
        }
        return multipolygonCreate;
    }

    private Relation createRelation(MultipolygonCreate multipolygonCreate) {
        Relation relation = new Relation();
        relation.put("type", "multipolygon");
        for (MultipolygonCreate.JoinedPolygon joinedPolygon : multipolygonCreate.outerWays) {
            for (Way way : joinedPolygon.ways) {
                relation.addMember(new RelationMember("outer", way));
            }
        }
        for (MultipolygonCreate.JoinedPolygon joinedPolygon : multipolygonCreate.innerWays) {
            for (Way way : joinedPolygon.ways) {
                relation.addMember(new RelationMember("inner", way));
            }
        }
        return relation;
    }

    private List<Command> removeTagsFromWaysIfNeeded(Relation relation) {
        String string;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (relation.hasKeys()) {
            for (String object2 : relation.keySet()) {
                hashMap.put(object2, relation.get(object2));
            }
        }
        ArrayList arrayList = new ArrayList();
        ArrayList<Way> arrayList2 = new ArrayList<Way>();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (RelationMember bl : relation.getMembers()) {
            if (bl.hasRole() && "inner".equals(bl.getRole()) && bl.isWay() && bl.getWay().hasKeys()) {
                arrayList.add(bl.getWay());
            }
            if (!bl.hasRole() || !"outer".equals(bl.getRole()) || !bl.isWay() || !bl.getWay().hasKeys()) continue;
            Iterator iterator = bl.getWay();
            arrayList2.add((Way)((Object)iterator));
            for (String string2 : ((AbstractPrimitive)((Object)iterator)).keySet()) {
                if (!hashMap.containsKey(string2)) {
                    hashMap.put(string2, ((AbstractPrimitive)((Object)iterator)).get(string2));
                    continue;
                }
                if (relation.hasKey(string2) || ((String)hashMap.get(string2)).equals(((AbstractPrimitive)((Object)iterator)).get(string2))) continue;
                treeSet.add(string2);
            }
        }
        if (!Main.pref.getBoolean("multipoly.alltags", false)) {
            for (RelationMember relationMember : relation.getMembers()) {
                if (!relationMember.hasRole() || !relationMember.getRole().equals("outer") || !relationMember.isWay()) continue;
                for (String string3 : hashMap.keySet()) {
                    if (relationMember.getWay().hasKey(string3) || relation.hasKey(string3)) continue;
                    treeSet.add(string3);
                }
            }
        }
        for (String string4 : treeSet) {
            hashMap.remove(string4);
        }
        for (String string5 : Main.pref.getCollection("multipoly.lineartagstokeep", DEFAULT_LINEAR_TAGS)) {
            hashMap.remove(string5);
        }
        if (hashMap.containsKey("natural") && ((String)hashMap.get("natural")).equals("coastline")) {
            hashMap.remove("natural");
        }
        hashMap.put("area", "yes");
        ArrayList arrayList3 = new ArrayList();
        boolean bl = Main.pref.getBoolean("multipoly.movetags", true);
        for (Map.Entry entry : hashMap.entrySet()) {
            ArrayList<Way> arrayList4 = new ArrayList<Way>();
            Map.Entry entry2 = (String)entry.getKey();
            string = (String)entry.getValue();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Way way = (Way)iterator.next();
                if (!way.hasKey((String)((Object)entry2)) || !string.equals(way.get((String)((Object)entry2)))) continue;
                arrayList4.add(way);
            }
            if (bl) {
                for (Way way : arrayList2) {
                    if (!way.hasKey((String)((Object)entry2))) continue;
                    arrayList4.add(way);
                }
            }
            if (arrayList4.isEmpty()) continue;
            arrayList3.add(new ChangePropertyCommand(arrayList4, (String)((Object)entry2), null));
        }
        if (bl) {
            boolean bl2 = false;
            Relation relation2 = new Relation(relation);
            for (Map.Entry entry2 : hashMap.entrySet()) {
                string = (String)entry2.getKey();
                if (relation2.hasKey(string) || string.equals("area")) continue;
                if (relation.isNew()) {
                    relation.put(string, (String)entry2.getValue());
                } else {
                    relation2.put(string, (String)entry2.getValue());
                }
                bl2 = true;
            }
            if (bl2 && !relation.isNew()) {
                arrayList3.add(new ChangeCommand(relation, relation2));
            }
        }
        return arrayList3;
    }
}

