/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapFrameListener;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.ValidatorDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class AutoScaleAction
extends JosmAction {
    public static final Collection<String> MODES = Collections.unmodifiableList(Arrays.asList(I18n.marktr("data"), I18n.marktr("layer"), I18n.marktr("selection"), I18n.marktr("conflict"), I18n.marktr("download"), I18n.marktr("problem"), I18n.marktr("previous"), I18n.marktr("next")));
    private final String mode;
    protected ZoomChangeAdapter zoomChangeAdapter;
    protected MapFrameAdapter mapFrameAdapter;

    public static void zoomToSelection() {
        if (Main.main == null || !Main.main.hasEditLayer()) {
            return;
        }
        Collection<OsmPrimitive> collection = Main.main.getEditLayer().data.getSelected();
        if (collection.isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Nothing selected to zoom to.", new Object[0]), I18n.tr("Information", new Object[0]), 1);
            return;
        }
        AutoScaleAction.zoomTo(collection);
    }

    public static void zoomTo(Collection<OsmPrimitive> collection) {
        BoundingXYVisitor boundingXYVisitor = new BoundingXYVisitor();
        boundingXYVisitor.computeBoundingBox(collection);
        boundingXYVisitor.enlargeBoundingBox();
        if (boundingXYVisitor.getBounds() != null) {
            Main.map.mapView.recalculateCenterScale(boundingXYVisitor);
        }
    }

    public static void autoScale(String string) {
        new AutoScaleAction(string, false).autoScale();
    }

    private static int getModeShortcut(String string) {
        int n = -1;
        if (string.equals("data")) {
            n = 49;
        } else if (string.equals("layer")) {
            n = 50;
        } else if (string.equals("selection")) {
            n = 51;
        } else if (string.equals("conflict")) {
            n = 52;
        } else if (string.equals("download")) {
            n = 53;
        } else if (string.equals("problem")) {
            n = 54;
        } else if (string.equals("previous")) {
            n = 56;
        } else if (string.equals("next")) {
            n = 57;
        }
        return n;
    }

    private AutoScaleAction(String string, boolean bl) {
        super(false);
        this.mode = string;
    }

    public AutoScaleAction(String string) {
        super(I18n.tr("Zoom to {0}", I18n.tr(string, new Object[0])), "dialogs/autoscale/" + string, I18n.tr("Zoom the view to {0}.", I18n.tr(string, new Object[0])), Shortcut.registerShortcut("view:zoom" + string, I18n.tr("View: {0}", I18n.tr("Zoom to {0}", I18n.tr(string, new Object[0]))), AutoScaleAction.getModeShortcut(string), 5003), true, null, false);
        String string2 = Character.toUpperCase(string.charAt(0)) + string.substring(1);
        this.putValue("help", "Action/AutoScale/" + string2);
        this.mode = string;
        if (string.equals("data")) {
            this.putValue("help", HelpUtil.ht("/Action/ZoomToData"));
        } else if (string.equals("layer")) {
            this.putValue("help", HelpUtil.ht("/Action/ZoomToLayer"));
        } else if (string.equals("selection")) {
            this.putValue("help", HelpUtil.ht("/Action/ZoomToSelection"));
        } else if (string.equals("conflict")) {
            this.putValue("help", HelpUtil.ht("/Action/ZoomToConflict"));
        } else if (string.equals("problem")) {
            this.putValue("help", HelpUtil.ht("/Action/ZoomToProblem"));
        } else if (string.equals("download")) {
            this.putValue("help", HelpUtil.ht("/Action/ZoomToDownload"));
        } else if (string.equals("previous")) {
            this.putValue("help", HelpUtil.ht("/Action/ZoomToPrevious"));
        } else if (string.equals("next")) {
            this.putValue("help", HelpUtil.ht("/Action/ZoomToNext"));
        } else {
            throw new IllegalArgumentException("Unknown mode: " + string);
        }
        this.installAdapters();
    }

    public void autoScale() {
        if (Main.isDisplayingMapView()) {
            if (this.mode.equals("previous")) {
                Main.map.mapView.zoomPrevious();
            } else if (this.mode.equals("next")) {
                Main.map.mapView.zoomNext();
            } else {
                BoundingXYVisitor boundingXYVisitor = this.getBoundingBox();
                if (boundingXYVisitor != null && boundingXYVisitor.getBounds() != null) {
                    Main.map.mapView.recalculateCenterScale(boundingXYVisitor);
                }
            }
        }
        this.putValue("active", true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.autoScale();
    }

    protected Layer getActiveLayer() {
        try {
            return Main.map.mapView.getActiveLayer();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    protected Layer getFirstSelectedLayer() {
        List<Layer> list = LayerListDialog.getInstance().getModel().getSelectedLayers();
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    private BoundingXYVisitor getBoundingBox() {
        BoundingXYVisitor boundingXYVisitor;
        block16: {
            block19: {
                block18: {
                    block17: {
                        block15: {
                            BoundingXYVisitor boundingXYVisitor2 = boundingXYVisitor = this.mode.equals("problem") ? new ValidatorDialog.ValidatorBoundingXYVisitor() : new BoundingXYVisitor();
                            if (!this.mode.equals("problem")) break block15;
                            TestError testError = Main.map.validatorDialog.getSelectedError();
                            if (testError == null) {
                                return null;
                            }
                            ((ValidatorDialog.ValidatorBoundingXYVisitor)boundingXYVisitor).visit(testError);
                            if (boundingXYVisitor.getBounds() == null) {
                                return null;
                            }
                            boundingXYVisitor.enlargeBoundingBox(Main.pref.getDouble("validator.zoom-enlarge-bbox", 2.0E-4));
                            break block16;
                        }
                        if (!this.mode.equals("data")) break block17;
                        for (Layer layer : Main.map.mapView.getAllLayers()) {
                            layer.visitBoundingBox(boundingXYVisitor);
                        }
                        break block16;
                    }
                    if (!this.mode.equals("layer")) break block18;
                    if (this.getActiveLayer() == null) {
                        return null;
                    }
                    Layer layer = this.getFirstSelectedLayer();
                    if (layer == null) {
                        return null;
                    }
                    layer.visitBoundingBox(boundingXYVisitor);
                    break block16;
                }
                if (!this.mode.equals("selection") && !this.mode.equals("conflict")) break block19;
                Collection<Object> collection = new HashSet();
                if (this.mode.equals("selection")) {
                    collection = AutoScaleAction.getCurrentDataSet().getSelected();
                } else if (this.mode.equals("conflict")) {
                    Conflict<? extends OsmPrimitive> conflict = Main.map.conflictDialog.getSelectedConflict();
                    if (conflict != null) {
                        collection.add(conflict.getMy());
                    } else if (Main.map.conflictDialog.getConflicts() != null) {
                        collection = Main.map.conflictDialog.getConflicts().getMyConflictParties();
                    }
                }
                if (collection.isEmpty()) {
                    JOptionPane.showMessageDialog(Main.parent, this.mode.equals("selection") ? I18n.tr("Nothing selected to zoom to.", new Object[0]) : I18n.tr("No conflicts to zoom to", new Object[0]), I18n.tr("Information", new Object[0]), 1);
                    return null;
                }
                for (OsmPrimitive osmPrimitive : collection) {
                    osmPrimitive.accept(boundingXYVisitor);
                }
                boundingXYVisitor.enlargeBoundingBox();
                break block16;
            }
            if (!this.mode.equals("download") || Main.pref.get("osm-download.bounds").isEmpty()) break block16;
            try {
                boundingXYVisitor.visit(new Bounds(Main.pref.get("osm-download.bounds"), ";"));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return boundingXYVisitor;
    }

    @Override
    protected void updateEnabledState() {
        if ("selection".equals(this.mode)) {
            this.setEnabled(AutoScaleAction.getCurrentDataSet() != null && !AutoScaleAction.getCurrentDataSet().getSelected().isEmpty());
        } else if ("layer".equals(this.mode)) {
            if (!Main.isDisplayingMapView() || Main.map.mapView.getAllLayersAsList().isEmpty()) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
            }
        } else if ("conflict".equals(this.mode)) {
            this.setEnabled(Main.map != null && Main.map.conflictDialog.getSelectedConflict() != null);
        } else if ("problem".equals(this.mode)) {
            this.setEnabled(Main.map != null && Main.map.validatorDialog.getSelectedError() != null);
        } else if ("previous".equals(this.mode)) {
            this.setEnabled(Main.isDisplayingMapView() && Main.map.mapView.hasZoomUndoEntries());
        } else if ("next".equals(this.mode)) {
            this.setEnabled(Main.isDisplayingMapView() && Main.map.mapView.hasZoomRedoEntries());
        } else {
            this.setEnabled(Main.isDisplayingMapView() && Main.map.mapView.hasLayers());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        if ("selection".equals(this.mode)) {
            this.setEnabled(collection != null && !collection.isEmpty());
        }
    }

    @Override
    protected void installAdapters() {
        super.installAdapters();
        this.zoomChangeAdapter = new ZoomChangeAdapter();
        MapView.addZoomChangeListener(this.zoomChangeAdapter);
        this.mapFrameAdapter = new MapFrameAdapter();
        Main.addMapFrameListener(this.mapFrameAdapter);
        this.initEnabledState();
    }

    private class MapFrameAdapter
    implements MapFrameListener {
        private ListSelectionListener conflictSelectionListener;
        private TreeSelectionListener validatorSelectionListener;

        public MapFrameAdapter() {
            if (AutoScaleAction.this.mode.equals("conflict")) {
                this.conflictSelectionListener = new ListSelectionListener(){

                    @Override
                    public void valueChanged(ListSelectionEvent listSelectionEvent) {
                        AutoScaleAction.this.updateEnabledState();
                    }
                };
            } else if (AutoScaleAction.this.mode.equals("problem")) {
                this.validatorSelectionListener = new TreeSelectionListener(){

                    @Override
                    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                        AutoScaleAction.this.updateEnabledState();
                    }
                };
            }
        }

        @Override
        public void mapFrameInitialized(MapFrame mapFrame, MapFrame mapFrame2) {
            if (this.conflictSelectionListener != null) {
                if (mapFrame2 != null) {
                    mapFrame2.conflictDialog.addListSelectionListener(this.conflictSelectionListener);
                } else if (mapFrame != null) {
                    mapFrame.conflictDialog.removeListSelectionListener(this.conflictSelectionListener);
                }
            } else if (this.validatorSelectionListener != null) {
                if (mapFrame2 != null) {
                    mapFrame2.validatorDialog.addTreeSelectionListener(this.validatorSelectionListener);
                } else if (mapFrame != null) {
                    mapFrame.validatorDialog.removeTreeSelectionListener(this.validatorSelectionListener);
                }
            }
        }
    }

    private class ZoomChangeAdapter
    implements NavigatableComponent.ZoomChangeListener {
        private ZoomChangeAdapter() {
        }

        @Override
        public void zoomChanged() {
            AutoScaleAction.this.updateEnabledState();
        }
    }
}

