/*
 * Decompiled with CFR 0.152.
 */
package oauth.signpost.http;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import oauth.signpost.OAuth;

public class HttpParameters
implements Map<String, SortedSet<String>>,
Serializable {
    private TreeMap<String, SortedSet<String>> wrappedMap = new TreeMap();

    @Override
    public SortedSet<String> put(String string, SortedSet<String> sortedSet) {
        return this.wrappedMap.put(string, sortedSet);
    }

    public SortedSet<String> put(String string, SortedSet<String> sortedSet, boolean bl) {
        if (bl) {
            this.remove(string);
            for (String string2 : sortedSet) {
                this.put(string, string2, true);
            }
            return this.get(string);
        }
        return this.wrappedMap.put(string, sortedSet);
    }

    @Override
    public String put(String string, String string2) {
        return this.put(string, string2, false);
    }

    public String put(String string, String string2, boolean bl) {
        SortedSet<String> sortedSet = this.wrappedMap.get(string);
        if (sortedSet == null) {
            sortedSet = new TreeSet<String>();
            this.wrappedMap.put(bl ? OAuth.percentEncode(string) : string, sortedSet);
        }
        if (string2 != null) {
            string2 = bl ? OAuth.percentEncode(string2) : string2;
            sortedSet.add(string2);
        }
        return string2;
    }

    public String putNull(String string, String string2) {
        return this.put(string, string2);
    }

    @Override
    public void putAll(Map<? extends String, ? extends SortedSet<String>> map) {
        this.wrappedMap.putAll(map);
    }

    public void putAll(Map<? extends String, ? extends SortedSet<String>> map, boolean bl) {
        if (bl) {
            for (String string : map.keySet()) {
                this.put(string, map.get(string), true);
            }
        } else {
            this.wrappedMap.putAll(map);
        }
    }

    public void putAll(String[] stringArray, boolean bl) {
        for (int i = 0; i < stringArray.length - 1; i += 2) {
            this.put(stringArray[i], stringArray[i + 1], bl);
        }
    }

    public void putMap(Map<String, List<String>> map) {
        for (String string : map.keySet()) {
            TreeSet<String> treeSet = this.get(string);
            if (treeSet == null) {
                treeSet = new TreeSet<String>();
                this.put(string, (SortedSet<String>)treeSet);
            }
            treeSet.addAll((Collection)map.get(string));
        }
    }

    @Override
    public SortedSet<String> get(Object object) {
        return this.wrappedMap.get(object);
    }

    public String getFirst(Object object) {
        return this.getFirst(object, false);
    }

    public String getFirst(Object object, boolean bl) {
        SortedSet<String> sortedSet = this.wrappedMap.get(object);
        if (sortedSet == null || sortedSet.isEmpty()) {
            return null;
        }
        String string = sortedSet.first();
        return bl ? OAuth.percentDecode(string) : string;
    }

    public String getAsQueryString(Object object) {
        StringBuilder stringBuilder = new StringBuilder();
        Set set = this.wrappedMap.get(object = OAuth.percentEncode((String)object));
        if (set == null) {
            return object + "=";
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(object + "=" + (String)iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuilder.append("&");
        }
        return stringBuilder.toString();
    }

    public String getAsHeaderElement(String string) {
        String string2 = this.getFirst(string);
        if (string2 == null) {
            return null;
        }
        return string + "=\"" + string2 + "\"";
    }

    @Override
    public boolean containsKey(Object object) {
        return this.wrappedMap.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        for (SortedSet<String> sortedSet : this.wrappedMap.values()) {
            if (!sortedSet.contains(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        int n = 0;
        for (String string : this.wrappedMap.keySet()) {
            n += this.wrappedMap.get(string).size();
        }
        return n;
    }

    @Override
    public boolean isEmpty() {
        return this.wrappedMap.isEmpty();
    }

    @Override
    public void clear() {
        this.wrappedMap.clear();
    }

    @Override
    public SortedSet<String> remove(Object object) {
        return this.wrappedMap.remove(object);
    }

    @Override
    public Set<String> keySet() {
        return this.wrappedMap.keySet();
    }

    @Override
    public Collection<SortedSet<String>> values() {
        return this.wrappedMap.values();
    }

    @Override
    public Set<Map.Entry<String, SortedSet<String>>> entrySet() {
        return this.wrappedMap.entrySet();
    }
}

