/*
 * Decompiled with CFR 0.152.
 */
package oauth.signpost;

import com.google.gdata.util.common.base.PercentEscaper;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oauth.signpost.http.HttpParameters;

public class OAuth {
    public static final String VERSION_1_0 = "1.0";
    public static final String ENCODING = "UTF-8";
    public static final String FORM_ENCODED = "application/x-www-form-urlencoded";
    public static final String HTTP_AUTHORIZATION_HEADER = "Authorization";
    public static final String OAUTH_CONSUMER_KEY = "oauth_consumer_key";
    public static final String OAUTH_TOKEN = "oauth_token";
    public static final String OAUTH_TOKEN_SECRET = "oauth_token_secret";
    public static final String OAUTH_SIGNATURE_METHOD = "oauth_signature_method";
    public static final String OAUTH_SIGNATURE = "oauth_signature";
    public static final String OAUTH_TIMESTAMP = "oauth_timestamp";
    public static final String OAUTH_NONCE = "oauth_nonce";
    public static final String OAUTH_VERSION = "oauth_version";
    public static final String OAUTH_CALLBACK = "oauth_callback";
    public static final String OAUTH_CALLBACK_CONFIRMED = "oauth_callback_confirmed";
    public static final String OAUTH_VERIFIER = "oauth_verifier";
    public static final String OUT_OF_BAND = "oob";
    private static final PercentEscaper percentEncoder = new PercentEscaper("-._~", false);

    public static String percentEncode(String string) {
        if (string == null) {
            return "";
        }
        return percentEncoder.escape(string);
    }

    public static String percentDecode(String string) {
        try {
            if (string == null) {
                return "";
            }
            return URLDecoder.decode(string, ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
    }

    public static <T extends Map.Entry<String, String>> void formEncode(Collection<T> collection, OutputStream outputStream) throws IOException {
        if (collection != null) {
            boolean bl = true;
            for (Map.Entry entry : collection) {
                if (bl) {
                    bl = false;
                } else {
                    outputStream.write(38);
                }
                outputStream.write(OAuth.percentEncode(OAuth.safeToString(entry.getKey())).getBytes());
                outputStream.write(61);
                outputStream.write(OAuth.percentEncode(OAuth.safeToString(entry.getValue())).getBytes());
            }
        }
    }

    public static <T extends Map.Entry<String, String>> String formEncode(Collection<T> collection) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OAuth.formEncode(collection, byteArrayOutputStream);
        return new String(byteArrayOutputStream.toByteArray());
    }

    public static HttpParameters decodeForm(String string) {
        HttpParameters httpParameters = new HttpParameters();
        if (OAuth.isEmpty(string)) {
            return httpParameters;
        }
        for (String string2 : string.split("\\&")) {
            String string3;
            String string4;
            int n = string2.indexOf(61);
            if (n < 0) {
                string4 = OAuth.percentDecode(string2);
                string3 = null;
            } else {
                string4 = OAuth.percentDecode(string2.substring(0, n));
                string3 = OAuth.percentDecode(string2.substring(n + 1));
            }
            httpParameters.put(string4, string3);
        }
        return httpParameters;
    }

    public static HttpParameters decodeForm(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder stringBuilder = new StringBuilder();
        String string = bufferedReader.readLine();
        while (string != null) {
            stringBuilder.append(string);
            string = bufferedReader.readLine();
        }
        return OAuth.decodeForm(stringBuilder.toString());
    }

    public static <T extends Map.Entry<String, String>> Map<String, String> toMap(Collection<T> collection) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (collection != null) {
            for (Map.Entry entry : collection) {
                String string = (String)entry.getKey();
                if (hashMap.containsKey(string)) continue;
                hashMap.put(string, (String)entry.getValue());
            }
        }
        return hashMap;
    }

    public static final String safeToString(Object object) {
        return object == null ? null : object.toString();
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static String addQueryParameters(String string, String ... stringArray) {
        String string2 = string.contains("?") ? "&" : "?";
        StringBuilder stringBuilder = new StringBuilder(string + string2);
        for (int i = 0; i < stringArray.length; i += 2) {
            if (i > 0) {
                stringBuilder.append("&");
            }
            stringBuilder.append(OAuth.percentEncode(stringArray[i]) + "=" + OAuth.percentEncode(stringArray[i + 1]));
        }
        return stringBuilder.toString();
    }

    public static String addQueryParameters(String string, Map<String, String> map) {
        String[] stringArray = new String[map.size() * 2];
        int n = 0;
        Iterator<String> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string2;
            stringArray[n] = string2 = iterator.next();
            stringArray[n + 1] = map.get(string2);
            n += 2;
        }
        return OAuth.addQueryParameters(string, stringArray);
    }

    public static String prepareOAuthHeader(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder("OAuth ");
        for (int i = 0; i < stringArray.length; i += 2) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            String string = stringArray[i].startsWith("oauth_") ? OAuth.percentEncode(stringArray[i + 1]) : stringArray[i + 1];
            stringBuilder.append(OAuth.percentEncode(stringArray[i]) + "=\"" + string + "\"");
        }
        return stringBuilder.toString();
    }

    public static HttpParameters oauthHeaderToParamsMap(String string) {
        String[] stringArray;
        HttpParameters httpParameters = new HttpParameters();
        if (string == null || !string.startsWith("OAuth ")) {
            return httpParameters;
        }
        string = string.substring("OAuth ".length());
        for (String string2 : stringArray = string.split(",")) {
            String[] stringArray2 = string2.split("=");
            httpParameters.put(stringArray2[0].trim(), stringArray2[1].replace("\"", "").trim());
        }
        return httpParameters;
    }

    public static String toHeaderElement(String string, String string2) {
        return OAuth.percentEncode(string) + "=\"" + OAuth.percentEncode(string2) + "\"";
    }

    public static void debugOut(String string, String string2) {
        if (System.getProperty("debug") != null) {
            System.out.println("[SIGNPOST] " + string + ": " + string2);
        }
    }
}

