/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.jpeg;

import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.imaging.jpeg.JpegSegmentData;
import com.drew.imaging.jpeg.JpegSegmentReader;
import com.drew.lang.ByteArrayReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifReader;
import com.drew.metadata.iptc.IptcReader;
import com.drew.metadata.jpeg.JpegCommentReader;
import com.drew.metadata.jpeg.JpegDirectory;
import com.drew.metadata.jpeg.JpegReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

public class JpegMetadataReader {
    @NotNull
    public static Metadata readMetadata(@NotNull InputStream inputStream) throws JpegProcessingException {
        return JpegMetadataReader.readMetadata(inputStream, true);
    }

    @NotNull
    public static Metadata readMetadata(@NotNull InputStream inputStream, boolean bl) throws JpegProcessingException {
        JpegSegmentReader jpegSegmentReader = new JpegSegmentReader(inputStream, bl);
        return JpegMetadataReader.extractMetadataFromJpegSegmentReader(jpegSegmentReader.getSegmentData());
    }

    @NotNull
    public static Metadata readMetadata(@NotNull File file) throws JpegProcessingException, IOException {
        JpegSegmentReader jpegSegmentReader = new JpegSegmentReader(file);
        return JpegMetadataReader.extractMetadataFromJpegSegmentReader(jpegSegmentReader.getSegmentData());
    }

    @NotNull
    public static Metadata extractMetadataFromJpegSegmentReader(@NotNull JpegSegmentData jpegSegmentData) {
        byte[] byArray;
        Metadata metadata = new Metadata();
        for (int n = 0; n < 16; n = (int)((byte)(n + 1))) {
            Iterator<byte[]> iterator;
            if (n == 4 || n == 12 || (iterator = (Iterator<byte[]>)jpegSegmentData.getSegment((byte)(-64 + n))) == null) continue;
            Object object = metadata.getOrCreateDirectory(JpegDirectory.class);
            object.setInt(-3, n);
            new JpegReader().extract(new ByteArrayReader((byte[])iterator), metadata);
            break;
        }
        if ((byArray = jpegSegmentData.getSegment((byte)-2)) != null) {
            new JpegCommentReader().extract(new ByteArrayReader(byArray), metadata);
        }
        for (Object object : jpegSegmentData.getSegments((byte)-31)) {
            if (((byte[])object).length <= 3 || !"EXIF".equalsIgnoreCase(new String((byte[])object, 0, 4))) continue;
            new ExifReader().extract(new ByteArrayReader((byte[])object), metadata);
        }
        for (Object object : jpegSegmentData.getSegments((byte)-19)) {
            if (((byte[])object).length > 12 && "Photoshop 3.0".compareTo(new String((byte[])object, 0, 13)) == 0) continue;
            new IptcReader().extract(new ByteArrayReader((byte[])object), metadata);
        }
        return metadata;
    }

    private JpegMetadataReader() throws Exception {
        throw new Exception("Not intended for instantiation");
    }
}

