/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.gui;

import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.tools.example.debug.bdi.ExecutionManager;
import com.sun.tools.example.debug.bdi.NoSessionException;
import com.sun.tools.example.debug.bdi.SessionListener;
import com.sun.tools.example.debug.event.JDIAdapter;
import com.sun.tools.example.debug.event.JDIListener;
import com.sun.tools.example.debug.event.ThreadDeathEventSet;
import com.sun.tools.example.debug.event.ThreadStartEventSet;
import com.sun.tools.example.debug.event.VMDisconnectEventSet;
import com.sun.tools.example.debug.gui.ClassManager;
import com.sun.tools.example.debug.gui.CommandInterpreter;
import com.sun.tools.example.debug.gui.Environment;
import com.sun.tools.example.debug.gui.SearchPath;
import com.sun.tools.example.debug.gui.SingleLeafTreeSelectionModel;
import com.sun.tools.example.debug.gui.SourceManager;
import java.awt.BorderLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadTreeTool
extends JPanel {
    private Environment env;
    private ExecutionManager runtime;
    private SourceManager sourceManager;
    private ClassManager classManager;
    private JTree tree;
    private DefaultTreeModel treeModel;
    private ThreadTreeNode root;
    private SearchPath sourcePath;
    private CommandInterpreter interpreter;
    private static String HEADING = "THREADS";
    HashMap<ThreadReference, List<String>> threadTable = new HashMap();

    public ThreadTreeTool(Environment environment) {
        super(new BorderLayout());
        this.env = environment;
        this.runtime = environment.getExecutionManager();
        this.sourceManager = environment.getSourceManager();
        this.interpreter = new CommandInterpreter(environment);
        this.root = this.createThreadTree(HEADING);
        this.treeModel = new DefaultTreeModel(this.root);
        this.tree = new JTree(this.treeModel);
        this.tree.setSelectionModel(new SingleLeafTreeSelectionModel());
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ThreadTreeNode threadTreeNode;
                int n = ThreadTreeTool.this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                TreePath treePath = ThreadTreeTool.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n != -1 && mouseEvent.getClickCount() == 1 && (threadTreeNode = (ThreadTreeNode)treePath.getLastPathComponent()).isLeaf()) {
                    ThreadTreeTool.this.tree.setSelectionPath(treePath);
                    ThreadTreeTool.this.interpreter.executeCommand("thread " + threadTreeNode.getThreadId() + "  (\"" + threadTreeNode.getName() + "\")");
                }
            }
        };
        this.tree.addMouseListener(mouseAdapter);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        this.add(jScrollPane);
        ThreadTreeToolListener threadTreeToolListener = new ThreadTreeToolListener();
        this.runtime.addJDIListener(threadTreeToolListener);
        this.runtime.addSessionListener(threadTreeToolListener);
    }

    private List<String> threadPath(ThreadReference threadReference) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(0, threadReference.name());
        for (ThreadGroupReference threadGroupReference = threadReference.threadGroup(); threadGroupReference != null; threadGroupReference = threadGroupReference.parent()) {
            arrayList.add(0, threadGroupReference.name());
        }
        return arrayList;
    }

    ThreadTreeNode createThreadTree(String string) {
        return new ThreadTreeNode(string, null);
    }

    class ThreadTreeNode
    extends DefaultMutableTreeNode {
        String name;
        ThreadReference thread;
        long uid;
        String description;

        ThreadTreeNode(String string, ThreadReference threadReference) {
            if (string == null) {
                string = "<unnamed>";
            }
            this.name = string;
            this.thread = threadReference;
            if (threadReference == null) {
                this.uid = -1L;
                this.description = string;
            } else {
                this.uid = threadReference.uniqueID();
                this.description = string + " (t@" + Long.toHexString(this.uid) + ")";
            }
        }

        public String toString() {
            return this.description;
        }

        public String getName() {
            return this.name;
        }

        public ThreadReference getThread() {
            return this.thread;
        }

        public String getThreadId() {
            return "t@" + Long.toHexString(this.uid);
        }

        private boolean isThreadGroup() {
            return this.thread == null;
        }

        public boolean isLeaf() {
            return !this.isThreadGroup();
        }

        public void addThread(ThreadReference threadReference) {
            if (ThreadTreeTool.this.threadTable.get(threadReference) == null) {
                try {
                    List list = ThreadTreeTool.this.threadPath(threadReference);
                    try {
                        ThreadTreeTool.this.threadTable.put(threadReference, list);
                        this.addThread(list, threadReference);
                    }
                    catch (Throwable throwable) {
                        throw new RuntimeException("ThreadTree corrupted");
                    }
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    // empty catch block
                }
            }
        }

        private void addThread(List list, ThreadReference threadReference) {
            int n = list.size();
            if (n == 0) {
                return;
            }
            if (n == 1) {
                String string = (String)list.get(0);
                this.insertNode(string, threadReference);
            } else {
                String string = (String)list.get(0);
                List list2 = list.subList(1, n);
                ThreadTreeNode threadTreeNode = this.insertNode(string, null);
                threadTreeNode.addThread(list2, threadReference);
            }
        }

        private ThreadTreeNode insertNode(String string, ThreadReference threadReference) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                ThreadTreeNode threadTreeNode = (ThreadTreeNode)this.getChildAt(i);
                int n = string.compareTo(threadTreeNode.getName());
                if (n == 0 && threadReference == null) {
                    return threadTreeNode;
                }
                if (n >= 0) continue;
                ThreadTreeNode threadTreeNode2 = new ThreadTreeNode(string, threadReference);
                ThreadTreeTool.this.treeModel.insertNodeInto(threadTreeNode2, this, i);
                return threadTreeNode2;
            }
            ThreadTreeNode threadTreeNode = new ThreadTreeNode(string, threadReference);
            ThreadTreeTool.this.treeModel.insertNodeInto(threadTreeNode, this, this.getChildCount());
            return threadTreeNode;
        }

        public void removeThread(ThreadReference threadReference) {
            List<String> list = ThreadTreeTool.this.threadTable.get(threadReference);
            if (list != null) {
                this.removeThread(list, threadReference);
            }
        }

        private void removeThread(List list, ThreadReference threadReference) {
            int n = list.size();
            if (n == 0) {
                return;
            }
            if (n == 1) {
                String string = (String)list.get(0);
                ThreadTreeNode threadTreeNode = this.findLeafNode(threadReference, string);
                ThreadTreeTool.this.treeModel.removeNodeFromParent(threadTreeNode);
            } else {
                String string = (String)list.get(0);
                List list2 = list.subList(1, n);
                ThreadTreeNode threadTreeNode = this.findInternalNode(string);
                threadTreeNode.removeThread(list2, threadReference);
                if (threadTreeNode.isThreadGroup() && threadTreeNode.getChildCount() < 1) {
                    ThreadTreeTool.this.treeModel.removeNodeFromParent(threadTreeNode);
                }
            }
        }

        private ThreadTreeNode findLeafNode(ThreadReference threadReference, String string) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                ThreadTreeNode threadTreeNode = (ThreadTreeNode)this.getChildAt(i);
                if (threadTreeNode.getThread() != threadReference) continue;
                if (!string.equals(threadTreeNode.getName())) {
                    throw new RuntimeException("name mismatch");
                }
                return threadTreeNode;
            }
            throw new RuntimeException("not found");
        }

        private ThreadTreeNode findInternalNode(String string) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                ThreadTreeNode threadTreeNode = (ThreadTreeNode)this.getChildAt(i);
                if (!string.equals(threadTreeNode.getName())) continue;
                return threadTreeNode;
            }
            throw new RuntimeException("not found");
        }
    }

    private class ThreadTreeToolListener
    extends JDIAdapter
    implements JDIListener,
    SessionListener {
        private ThreadTreeToolListener() {
        }

        public void sessionStart(EventObject eventObject) {
            try {
                for (ThreadReference threadReference : ThreadTreeTool.this.runtime.allThreads()) {
                    ThreadTreeTool.this.root.addThread(threadReference);
                }
            }
            catch (VMDisconnectedException vMDisconnectedException) {
            }
            catch (NoSessionException noSessionException) {
                // empty catch block
            }
        }

        public void sessionInterrupt(EventObject eventObject) {
        }

        public void sessionContinue(EventObject eventObject) {
        }

        public void threadStart(ThreadStartEventSet threadStartEventSet) {
            ThreadTreeTool.this.root.addThread(threadStartEventSet.getThread());
        }

        public void threadDeath(ThreadDeathEventSet threadDeathEventSet) {
            ThreadTreeTool.this.root.removeThread(threadDeathEventSet.getThread());
        }

        public void vmDisconnect(VMDisconnectEventSet vMDisconnectEventSet) {
            ThreadTreeTool.this.root = ThreadTreeTool.this.createThreadTree(HEADING);
            ThreadTreeTool.this.treeModel = new DefaultTreeModel(ThreadTreeTool.this.root);
            ThreadTreeTool.this.tree.setModel(ThreadTreeTool.this.treeModel);
            ThreadTreeTool.this.threadTable = new HashMap();
        }
    }
}

