/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.bdi;

import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.example.debug.bdi.ExecutionManager;
import com.sun.tools.example.debug.bdi.JDIEventSource;
import com.sun.tools.example.debug.bdi.OutputListener;

class Session {
    final VirtualMachine vm;
    final ExecutionManager runtime;
    final OutputListener diagnostics;
    boolean running = true;
    boolean interrupted = false;
    private JDIEventSource eventSourceThread = null;
    private int traceFlags;
    private boolean dead = false;

    public Session(VirtualMachine virtualMachine, ExecutionManager executionManager, OutputListener outputListener) {
        this.vm = virtualMachine;
        this.runtime = executionManager;
        this.diagnostics = outputListener;
        this.traceFlags = 0;
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public void setTraceMode(int n) {
        this.traceFlags = n;
        if (!this.dead) {
            this.vm.setDebugTraceMode(n);
        }
    }

    public boolean attach() {
        this.vm.setDebugTraceMode(this.traceFlags);
        this.diagnostics.putString("Connected to VM");
        this.eventSourceThread = new JDIEventSource(this);
        this.eventSourceThread.start();
        return true;
    }

    public void detach() {
        if (!this.dead) {
            this.eventSourceThread.interrupt();
            this.eventSourceThread = null;
            try {
                this.vm.dispose();
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
            this.dead = true;
            this.diagnostics.putString("Disconnected from VM");
        }
    }
}

