/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities.soql;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.script.Invocable;
import sun.jvm.hotspot.utilities.soql.InvocableCallable;
import sun.jvm.hotspot.utilities.soql.MethodCallable;
import sun.jvm.hotspot.utilities.soql.ScriptObject;

public class MapScriptObject
implements ScriptObject {
    private Map map;

    public MapScriptObject() {
        this(new HashMap());
    }

    public MapScriptObject(Map map) {
        this.map = Collections.synchronizedMap(map);
    }

    public Object[] getIds() {
        return this.map.keySet().toArray();
    }

    public Object get(String name) {
        if (this.has(name)) {
            return this.map.get(name);
        }
        return UNDEFINED;
    }

    public Object get(int index) {
        if (this.has(index)) {
            Integer key = index;
            return this.map.get(key);
        }
        return UNDEFINED;
    }

    public void put(String name, Object value) {
        this.map.put(name, value);
    }

    public void put(int index, Object value) {
        this.map.put(index, value);
    }

    public boolean has(String name) {
        return this.map.containsKey(name);
    }

    public boolean has(int index) {
        return this.map.containsKey(index);
    }

    public boolean delete(String name) {
        if (this.map.containsKey(name)) {
            this.map.remove(name);
            return true;
        }
        return false;
    }

    public boolean delete(int index) {
        Integer key = index;
        if (this.map.containsKey(key)) {
            this.map.remove(key);
            return true;
        }
        return false;
    }

    protected void putFunction(Object target, Method method) {
        this.putFunction(target, method, true);
    }

    protected void putFunction(Object target, Method method, boolean wrapArgs) {
        this.map.put(method.getName(), new MethodCallable(target, method, wrapArgs));
    }

    protected void putFunction(Object target, String name, Invocable invocable) {
        this.map.put(name, new InvocableCallable(target, name, invocable));
    }
}

