/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.asm.sparc;

import sun.jvm.hotspot.asm.Address;
import sun.jvm.hotspot.asm.sparc.SPARCRegisterIndirectAddress;
import sun.jvm.hotspot.asm.sparc.SPARCSpecialRegisterInstruction;
import sun.jvm.hotspot.asm.sparc.SPARCSpecialRegisters;
import sun.jvm.hotspot.utilities.Assert;

public class SPARCSpecialLoadInstruction
extends SPARCSpecialRegisterInstruction
implements SPARCSpecialRegisters {
    private final int specialReg;
    private final int cregNum;
    private final SPARCRegisterIndirectAddress addr;

    public SPARCSpecialLoadInstruction(String name, int specialReg, int cregNum, SPARCRegisterIndirectAddress addr) {
        super(name);
        this.specialReg = specialReg;
        this.cregNum = cregNum;
        this.addr = addr;
    }

    public SPARCSpecialLoadInstruction(String name, int specialReg, SPARCRegisterIndirectAddress addr) {
        this(name, specialReg, -1, addr);
    }

    public int getSpecialRegister() {
        return this.specialReg;
    }

    public int getCoprocessorRegister() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.specialReg == 9, "not a coprocesssor register");
        }
        return this.cregNum;
    }

    public Address getSource() {
        return this.addr;
    }

    protected String getDescription() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getName());
        buf.append(spaces);
        buf.append(this.addr);
        buf.append(comma);
        if (this.specialReg == 9) {
            buf.append("creg" + this.cregNum);
        } else {
            buf.append(SPARCSpecialLoadInstruction.getSpecialRegisterName(this.specialReg));
        }
        return buf.toString();
    }
}

