/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl.singleRow;

import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.ShapeTransform;
import com.intellij.ui.tabs.impl.singleRow.SingleRowLayout;
import com.intellij.ui.tabs.impl.singleRow.SingleRowPassInfo;
import java.awt.Dimension;
import java.awt.Rectangle;

public abstract class SingleRowLayoutStrategy {
    SingleRowLayout myLayout;
    JBTabsImpl myTabs;

    protected SingleRowLayoutStrategy(SingleRowLayout layout) {
        this.myLayout = layout;
        this.myTabs = this.myLayout.myTabs;
    }

    abstract int getMoreRectAxisSize();

    public abstract int getStartPosition(SingleRowPassInfo var1);

    public abstract int getToFitLength(SingleRowPassInfo var1);

    public abstract int getLengthIncrement(Dimension var1);

    public abstract int getMaxPosition(Rectangle var1);

    public abstract int getFixedFitLength(SingleRowPassInfo var1);

    public abstract Rectangle getLayoutRec(int var1, int var2, int var3, int var4);

    public abstract int getFixedPosition(SingleRowPassInfo var1);

    public abstract Rectangle getMoreRect(SingleRowPassInfo var1);

    public abstract boolean isToCenterTextWhenStretched();

    public abstract Dimension getCompSizeDelta(SingleRowPassInfo var1);

    public abstract ShapeTransform createShapeTransform(Rectangle var1);

    public abstract boolean canBeStretched();

    public abstract void layoutComp(SingleRowPassInfo var1);

    public boolean isSideComponentOnTabs() {
        return false;
    }

    static class Right
    extends Vertical {
        Right(SingleRowLayout layout) {
            super(layout);
        }

        @Override
        public void layoutComp(SingleRowPassInfo data) {
            if (this.myTabs.isHideTabs()) {
                this.myTabs.layoutComp(data, 0, 0, 0, 0);
            } else {
                this.myTabs.layoutComp(data, 0, 0, -this.myTabs.myHeaderFitSize.width, 0);
            }
        }

        @Override
        public ShapeTransform createShapeTransform(Rectangle labelRec) {
            return new ShapeTransform.Right(labelRec);
        }

        @Override
        public Rectangle getLayoutRec(int position, int fixedPos, int length, int fixedFitLength) {
            return new Rectangle(fixedPos, position, fixedFitLength - 1, length);
        }

        @Override
        public int getFixedPosition(SingleRowPassInfo data) {
            return data.laayoutSize.width - this.myTabs.myHeaderFitSize.width - data.insets.right;
        }

        @Override
        public Rectangle getMoreRect(SingleRowPassInfo data) {
            return new Rectangle(data.laayoutSize.width - this.myTabs.myHeaderFitSize.width, this.myTabs.getHeight() - data.insets.bottom - data.moreRectAxisSize - 1, this.myTabs.myHeaderFitSize.width - 1, data.moreRectAxisSize - 1);
        }

        @Override
        public Dimension getCompSizeDelta(SingleRowPassInfo data) {
            return new Dimension(-this.myTabs.myHeaderFitSize.width, 0);
        }
    }

    static class Left
    extends Vertical {
        Left(SingleRowLayout layout) {
            super(layout);
        }

        @Override
        public void layoutComp(SingleRowPassInfo data) {
            if (this.myTabs.isHideTabs()) {
                this.myTabs.layoutComp(data, 0, 0, 0, 0);
            } else {
                this.myTabs.layoutComp(data, this.myTabs.myHeaderFitSize.width + 1, 0, 0, 0);
            }
        }

        @Override
        public ShapeTransform createShapeTransform(Rectangle labelRec) {
            return new ShapeTransform.Left(labelRec);
        }

        @Override
        public Rectangle getLayoutRec(int position, int fixedPos, int length, int fixedFitLength) {
            return new Rectangle(fixedPos, position, fixedFitLength, length);
        }

        @Override
        public int getFixedPosition(SingleRowPassInfo data) {
            return data.insets.left;
        }

        @Override
        public Rectangle getMoreRect(SingleRowPassInfo data) {
            return new Rectangle(data.insets.left + this.myTabs.getSelectionTabVShift(), this.myTabs.getHeight() - data.insets.bottom - data.moreRectAxisSize - 1, this.myTabs.myHeaderFitSize.width - 1, data.moreRectAxisSize - 1);
        }
    }

    static abstract class Vertical
    extends SingleRowLayoutStrategy {
        protected Vertical(SingleRowLayout layout) {
            super(layout);
        }

        @Override
        public boolean isToCenterTextWhenStretched() {
            return false;
        }

        @Override
        int getMoreRectAxisSize() {
            return this.myLayout.myMoreIcon.getIconHeight() + 4;
        }

        @Override
        public Dimension getCompSizeDelta(SingleRowPassInfo data) {
            return new Dimension();
        }

        @Override
        public boolean canBeStretched() {
            return false;
        }

        @Override
        public int getStartPosition(SingleRowPassInfo data) {
            return data.insets.top;
        }

        @Override
        public int getToFitLength(SingleRowPassInfo data) {
            return this.myTabs.getHeight() - data.insets.top - data.insets.bottom;
        }

        @Override
        public int getLengthIncrement(Dimension labelPrefSize) {
            return labelPrefSize.height;
        }

        @Override
        public int getMaxPosition(Rectangle bounds) {
            return (int)bounds.getMaxY();
        }

        @Override
        public int getFixedFitLength(SingleRowPassInfo data) {
            return this.myTabs.myHeaderFitSize.width;
        }
    }

    static class Bottom
    extends Horizontal {
        Bottom(SingleRowLayout layout) {
            super(layout);
        }

        @Override
        public void layoutComp(SingleRowPassInfo data) {
            if (this.myTabs.isHideTabs()) {
                this.myTabs.layoutComp(data, 0, 0, 0, 0);
            } else {
                this.myTabs.layoutComp(data, 0, 0, 0, -(this.myTabs.myHeaderFitSize.height + 1));
            }
        }

        @Override
        public int getFixedPosition(SingleRowPassInfo data) {
            return this.myTabs.getSize().height - data.insets.bottom - this.myTabs.myHeaderFitSize.height - 1;
        }

        @Override
        public Rectangle getMoreRect(SingleRowPassInfo data) {
            return new Rectangle(this.myTabs.getWidth() - data.insets.right - data.moreRectAxisSize + 2, this.getFixedPosition(data), data.moreRectAxisSize - 1, this.myTabs.myHeaderFitSize.height - 1);
        }

        @Override
        public Dimension getCompSizeDelta(SingleRowPassInfo data) {
            return new Dimension(0, -(this.myTabs.myHeaderFitSize.height + 1));
        }

        @Override
        public ShapeTransform createShapeTransform(Rectangle labelRec) {
            return new ShapeTransform.Bottom(labelRec);
        }
    }

    static class Top
    extends Horizontal {
        Top(SingleRowLayout layout) {
            super(layout);
        }

        @Override
        public boolean isSideComponentOnTabs() {
            return !this.myTabs.isSideComponentVertical();
        }

        @Override
        public ShapeTransform createShapeTransform(Rectangle labelRec) {
            return new ShapeTransform.Top(labelRec);
        }

        @Override
        public int getFixedPosition(SingleRowPassInfo data) {
            return data.insets.top;
        }

        @Override
        public Rectangle getMoreRect(SingleRowPassInfo data) {
            int x = data.position + (data.lastGhostVisible ? data.lastGhost.width : 0);
            return new Rectangle(x, data.insets.top + this.myTabs.getSelectionTabVShift(), data.moreRectAxisSize - 1, this.myTabs.myHeaderFitSize.height - 1);
        }

        @Override
        public void layoutComp(SingleRowPassInfo data) {
            if (this.myTabs.isHideTabs()) {
                this.myTabs.layoutComp(data, 0, 0, 0, 0);
            } else {
                int x = data.vToolbar != null ? data.vToolbar.getPreferredSize().width + 1 : 0;
                int y = data.compPosition + this.myTabs.myHeaderFitSize.height + 1;
                if (data.hToolbar != null) {
                    this.myTabs.layoutComp(x, y, data.comp, 0, 0);
                    int toolbarX = data.moreRect != null ? (int)data.moreRect.getMaxX() + this.myTabs.getToolbarInset() : data.position + this.myTabs.getToolbarInset();
                    Rectangle rec = new Rectangle(toolbarX, data.insets.top + 1, this.myTabs.getSize().width - data.insets.left - toolbarX, this.myTabs.myHeaderFitSize.height);
                    JBTabsImpl.layout(data.hToolbar, rec);
                } else if (data.vToolbar != null) {
                    Rectangle compBounds = this.myTabs.layoutComp(x, y, data.comp, 0, 0);
                    int toolbarWidth = data.vToolbar.getPreferredSize().width;
                    JBTabsImpl.layout(data.vToolbar, compBounds.x - toolbarWidth - 1, compBounds.y, toolbarWidth, compBounds.height);
                } else {
                    this.myTabs.layoutComp(x, y, data.comp, 0, 0);
                }
            }
        }

        @Override
        public Dimension getCompSizeDelta(SingleRowPassInfo data) {
            return new Dimension();
        }
    }

    static abstract class Horizontal
    extends SingleRowLayoutStrategy {
        protected Horizontal(SingleRowLayout layout) {
            super(layout);
        }

        @Override
        public boolean isToCenterTextWhenStretched() {
            return true;
        }

        @Override
        public boolean canBeStretched() {
            return true;
        }

        @Override
        public int getMoreRectAxisSize() {
            return this.myLayout.myMoreIcon.getIconWidth() + 6;
        }

        @Override
        public int getToFitLength(SingleRowPassInfo data) {
            if (data.hToolbar != null) {
                return this.myTabs.getWidth() - data.insets.left - data.insets.right - data.hToolbar.getMinimumSize().width;
            }
            return this.myTabs.getWidth() - data.insets.left - data.insets.right;
        }

        @Override
        public int getLengthIncrement(Dimension labelPrefSize) {
            return labelPrefSize.width;
        }

        @Override
        public int getMaxPosition(Rectangle bounds) {
            return (int)bounds.getMaxX();
        }

        @Override
        public int getFixedFitLength(SingleRowPassInfo data) {
            return this.myTabs.myHeaderFitSize.height;
        }

        @Override
        public Rectangle getLayoutRec(int position, int fixedPos, int length, int fixedFitLength) {
            return new Rectangle(position, fixedPos, length, fixedFitLength);
        }

        @Override
        public int getStartPosition(SingleRowPassInfo data) {
            return data.insets.left;
        }
    }
}

