/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.LightColors;
import com.intellij.ui.SideBorder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NonNls;

public class EditorNotificationPanel
extends JPanel {
    protected final JLabel myLabel = new JLabel();
    protected final JPanel myLinksPanel;

    public EditorNotificationPanel() {
        super(new BorderLayout());
        this.setBackground(LightColors.YELLOW);
        this.setBorder((Border)new SideBorder(Color.gray, 8, true));
        this.setPreferredSize(new Dimension(-1, 24));
        this.add((Component)this.myLabel, "Center");
        this.myLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.myLinksPanel = new JPanel(new FlowLayout());
        this.myLinksPanel.setBackground(LightColors.YELLOW);
        this.add((Component)this.myLinksPanel, "East");
    }

    public void setText(String text) {
        this.myLabel.setText(text);
    }

    public HyperlinkLabel createActionLabel(String text, final @NonNls String actionId) {
        return this.createActionLabel(text, new Runnable(){

            @Override
            public void run() {
                EditorNotificationPanel.this.executeAction(actionId);
            }
        });
    }

    public HyperlinkLabel createActionLabel(String text, final Runnable action) {
        HyperlinkLabel label = new HyperlinkLabel(text, Color.BLUE, LightColors.YELLOW, Color.BLUE);
        label.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    action.run();
                }
            }
        });
        this.myLinksPanel.add(label);
        return label;
    }

    protected void executeAction(String actionId) {
        AnAction action = ActionManager.getInstance().getAction(actionId);
        AnActionEvent event = new AnActionEvent(null, DataManager.getInstance().getDataContext(this), "unknown", action.getTemplatePresentation(), ActionManager.getInstance(), 0);
        action.beforeActionPerformedUpdate(event);
        action.update(event);
        if (event.getPresentation().isEnabled() && event.getPresentation().isVisible()) {
            action.actionPerformed(event);
        }
    }
}

