/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VirtualFile
extends UserDataHolderBase
implements ModificationTracker {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.VirtualFile");
    public static final Key<Object> REQUESTOR_MARKER = new Key("REQUESTOR_MARKER");
    private static final Key<byte[]> BOM_KEY = new Key("BOM");
    private static final Key<Charset> CHARSET_KEY = new Key("CHARSET");
    public static final VirtualFile[] EMPTY_ARRAY = new VirtualFile[0];
    @NonNls
    public static final String PROP_NAME = "name";
    @NonNls
    public static final String PROP_ENCODING = "encoding";
    @NonNls
    public static final String PROP_WRITABLE = "writable";

    protected VirtualFile() {
    }

    @NotNull
    @NonNls
    public abstract String getName();

    @NotNull
    public abstract VirtualFileSystem getFileSystem();

    public abstract String getPath();

    @NotNull
    public abstract String getUrl();

    public final String getPresentableUrl() {
        return this.getFileSystem().extractPresentableUrl(this.getPath());
    }

    @Nullable
    @NonNls
    public String getExtension() {
        String name = this.getName();
        int index = name.lastIndexOf(46);
        if (index < 0) {
            return null;
        }
        return name.substring(index + 1);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NonNls
    @NotNull
    public String getNameWithoutExtension() {
        String string;
        String name = this.getName();
        int index = name.lastIndexOf(46);
        if (index < 0) {
            string = name;
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/VirtualFile.getNameWithoutExtension must not return null");
            return string;
        }
        string = name.substring(0, index);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/VirtualFile.getNameWithoutExtension must not return null");
    }

    public void rename(Object requestor, @NotNull @NonNls String newName) throws IOException {
        if (newName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VirtualFile.rename must not be null");
        }
        if (this.getName().equals(newName)) {
            return;
        }
        if (!VfsUtil.isValidName(newName)) {
            throw new IOException(VfsBundle.message("file.invalid.name.error", newName));
        }
        this.getFileSystem().renameFile(requestor, this, newName);
    }

    public abstract boolean isWritable();

    public abstract boolean isDirectory();

    public abstract boolean isValid();

    public abstract VirtualFile getParent();

    public abstract VirtualFile[] getChildren();

    @Nullable
    public VirtualFile findChild(@NotNull @NonNls String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VirtualFile.findChild must not be null");
        }
        VirtualFile[] children = this.getChildren();
        if (children == null) {
            return null;
        }
        for (VirtualFile child : children) {
            if (!child.nameEquals(name)) continue;
            return child;
        }
        return null;
    }

    @Nullable
    public VirtualFile findOrCreateChildData(Object requestor, @NotNull @NonNls String name) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VirtualFile.findOrCreateChildData must not be null");
        }
        VirtualFile child = this.findChild(name);
        if (child != null) {
            return child;
        }
        return this.createChildData(requestor, name);
    }

    public Icon getIcon() {
        return this.getFileType().getIcon();
    }

    @NotNull
    public FileType getFileType() {
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFile(this);
        if (fileType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/VirtualFile.getFileType must not return null");
        }
        return fileType;
    }

    @Nullable
    public VirtualFile findFileByRelativePath(@NotNull @NonNls String relPath) {
        String name;
        VirtualFile child;
        if (relPath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VirtualFile.findFileByRelativePath must not be null");
        }
        if (relPath.length() == 0) {
            return this;
        }
        int index = (relPath = StringUtil.trimStart((String)relPath, (String)"/")).indexOf(47);
        if (index < 0) {
            index = relPath.length();
        }
        if ((child = (name = relPath.substring(0, index)).equals(".") ? this : (name.equals("..") ? this.getParent() : this.findChild(name))) == null) {
            return null;
        }
        if (index < relPath.length()) {
            return child.findFileByRelativePath(relPath.substring(index + 1));
        }
        return child;
    }

    public VirtualFile createChildDirectory(Object requestor, @NonNls String name) throws IOException {
        if (!this.isDirectory()) {
            throw new IOException(VfsBundle.message("directory.create.wrong.parent.error", new Object[0]));
        }
        if (!this.isValid()) {
            throw new IOException(VfsBundle.message("invalid.directory.create.files", new Object[0]));
        }
        if (!VfsUtil.isValidName(name)) {
            throw new IOException(VfsBundle.message("directory.invalid.name.error", name));
        }
        if (this.findChild(name) != null) {
            throw new IOException(VfsBundle.message("file.create.already.exists.error", this.getUrl(), name));
        }
        return this.getFileSystem().createChildDirectory(requestor, this, name);
    }

    public VirtualFile createChildData(Object requestor, @NotNull @NonNls String name) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/VirtualFile.createChildData must not be null");
        }
        if (!this.isDirectory()) {
            throw new IOException(VfsBundle.message("file.create.wrong.parent.error", new Object[0]));
        }
        if (!this.isValid()) {
            throw new IOException(VfsBundle.message("invalid.directory.create.files", new Object[0]));
        }
        if (!VfsUtil.isValidName(name)) {
            throw new IOException(VfsBundle.message("file.invalid.name.error", name));
        }
        if (this.findChild(name) != null) {
            throw new IOException(VfsBundle.message("file.create.already.exists.error", this.getUrl(), name));
        }
        return this.getFileSystem().createChildFile(requestor, this, name);
    }

    public void delete(Object requestor) throws IOException {
        LOG.assertTrue(this.isValid(), (Object)"Deleting invalid file");
        this.getFileSystem().deleteFile(requestor, this);
    }

    public void move(final Object requestor, final VirtualFile newParent) throws IOException {
        if (this.getFileSystem() != newParent.getFileSystem()) {
            throw new IOException(VfsBundle.message("file.move.error", newParent.getPresentableUrl()));
        }
        VfsUtil.doActionAndRestoreEncoding(this, new ThrowableComputable<VirtualFile, IOException>(){

            public VirtualFile compute() throws IOException {
                VirtualFile.this.getFileSystem().moveFile(requestor, VirtualFile.this, newParent);
                return VirtualFile.this;
            }
        });
    }

    public VirtualFile copy(final Object requestor, final VirtualFile newParent, final String copyName) throws IOException {
        if (this.getFileSystem() != newParent.getFileSystem()) {
            throw new IOException(VfsBundle.message("file.copy.error", newParent.getPresentableUrl()));
        }
        if (!newParent.isDirectory()) {
            throw new IOException(VfsBundle.message("file.copy.target.must.be.directory", new Object[0]));
        }
        return VfsUtil.doActionAndRestoreEncoding(this, new ThrowableComputable<VirtualFile, IOException>(){

            public VirtualFile compute() throws IOException {
                return VirtualFile.this.getFileSystem().copyFile(requestor, VirtualFile.this, newParent, copyName);
            }
        });
    }

    public final void setBinaryContent(byte[] content) throws IOException {
        this.setBinaryContent(content, -1L, -1L);
    }

    public Charset getCharset() {
        Charset charset = (Charset)this.getUserData(CHARSET_KEY);
        if (charset == null) {
            charset = EncodingManager.getInstance().getDefaultCharset();
            this.setCharset(charset);
        }
        return charset;
    }

    public void setCharset(final Charset charset) {
        final Charset old = (Charset)this.getUserData(CHARSET_KEY);
        this.putUserData(CHARSET_KEY, charset);
        byte[] bom = charset == null ? null : CharsetToolkit.getBom(charset);
        this.setBOM(bom);
        if (old != null && !old.equals(charset)) {
            final Application application = ApplicationManager.getApplication();
            application.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (VirtualFile.this.isValid() && !application.isDisposed()) {
                        application.runWriteAction(new Runnable(){

                            @Override
                            public void run() {
                                ((BulkFileListener)application.getMessageBus().syncPublisher(VirtualFileManager.VFS_CHANGES)).after(Collections.singletonList(new VFilePropertyChangeEvent(this, VirtualFile.this, VirtualFile.PROP_ENCODING, old, charset, false)));
                            }
                        });
                    }
                }
            }, ModalityState.NON_MODAL);
        }
    }

    protected boolean isCharsetSet() {
        return this.getUserData(CHARSET_KEY) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBinaryContent(byte[] content, long newModificationStamp, long newTimeStamp) throws IOException {
        OutputStream outputStream = null;
        try {
            outputStream = this.getOutputStream(this, newModificationStamp, newTimeStamp);
            outputStream.write(content);
            outputStream.flush();
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    public final OutputStream getOutputStream(Object requestor) throws IOException {
        return this.getOutputStream(requestor, -1L, -1L);
    }

    @NotNull
    public abstract OutputStream getOutputStream(Object var1, long var2, long var4) throws IOException;

    @NotNull
    public abstract byte[] contentsToByteArray() throws IOException;

    public long getModificationStamp() {
        throw new UnsupportedOperationException();
    }

    public abstract long getTimeStamp();

    public abstract long getLength();

    public void refresh(boolean asynchronous, boolean recursive) {
        this.refresh(asynchronous, recursive, null);
    }

    public abstract void refresh(boolean var1, boolean var2, Runnable var3);

    public String getPresentableName() {
        return this.getName();
    }

    @Override
    public long getModificationCount() {
        return this.isValid() ? this.getTimeStamp() : -1L;
    }

    protected boolean nameEquals(@NotNull @NonNls String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/VirtualFile.nameEquals must not be null");
        }
        return this.getName().equals(name);
    }

    public abstract InputStream getInputStream() throws IOException;

    @Nullable
    public byte[] getBOM() {
        return (byte[])this.getUserData(BOM_KEY);
    }

    public void setBOM(@Nullable byte[] BOM) {
        this.putUserData(BOM_KEY, BOM);
    }

    @NonNls
    public String toString() {
        return "VirtualFile: " + this.getPresentableUrl();
    }

    public boolean exists() {
        return this.isValid();
    }

    public boolean isInLocalFileSystem() {
        return false;
    }
}

