/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.vfs.CharsetToolkit;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;

public class SmartEncodingInputStream
extends InputStream {
    private InputStream is;
    private final int bufferLength;
    private byte[] buffer;
    private int counter;
    private Charset charset;
    public static final int BUFFER_LENGTH_2KB = 2048;
    public static final int BUFFER_LENGTH_4KB = 4096;
    public static final int BUFFER_LENGTH_8KB = 8192;

    public SmartEncodingInputStream(InputStream is, byte[] buffer, Charset defaultCharset, boolean enforce8Bit) throws IOException {
        this.is = is;
        this.buffer = buffer;
        this.counter = 0;
        this.bufferLength = is != null ? is.read(buffer) : buffer.length;
        CharsetToolkit charsetToolkit = new CharsetToolkit(buffer, defaultCharset);
        charsetToolkit.setEnforce8Bit(enforce8Bit);
        this.charset = charsetToolkit.guessEncoding(this.bufferLength);
    }

    public SmartEncodingInputStream(InputStream is, int bufferLength, Charset defaultCharset, boolean enforce8Bit) throws IOException {
        this(is, new byte[bufferLength], defaultCharset, enforce8Bit);
    }

    public SmartEncodingInputStream(InputStream is, int bufferLength, Charset defaultCharset) throws IOException {
        this(is, bufferLength, defaultCharset, true);
    }

    public SmartEncodingInputStream(InputStream is, int bufferLength) throws IOException {
        this(is, bufferLength, null, true);
    }

    public SmartEncodingInputStream(InputStream is) throws IOException {
        this(is, 4096, null, true);
    }

    @Override
    public int read() throws IOException {
        if (this.counter < this.bufferLength) {
            byte b = this.buffer[this.counter++];
            return 0xFF & b;
        }
        return this.is != null ? this.is.read() : -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = 0;
        if (this.counter < this.bufferLength) {
            read = Math.min(this.bufferLength - this.counter, len);
            System.arraycopy(this.buffer, this.counter, b, off, read);
            off += read;
            len -= read;
            this.counter += read;
        }
        if (len > 0) {
            int r;
            int n = r = this.is != null ? this.is.read(b, off, len) : -1;
            if (read == 0 && r < 0) {
                return -1;
            }
            if (r >= 0) {
                read += r;
            }
        }
        return read;
    }

    public Reader getReader() {
        if (this.charset == null) {
            return new InputStreamReader(this);
        }
        return new InputStreamReader((InputStream)this, this.charset);
    }

    public Charset getEncoding() {
        return this.charset;
    }

    @Override
    public void close() throws IOException {
        if (this.is != null) {
            this.is.close();
        }
        this.buffer = null;
    }
}

