/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class VcsAbstractHistorySession
implements VcsHistorySession {
    private final List<VcsFileRevision> myRevisions;
    private final Object myLock = new Object();
    private VcsRevisionNumber myCachedRevisionNumber;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected VcsRevisionNumber getCachedRevision() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myCachedRevisionNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCachedRevision(VcsRevisionNumber number) {
        Object object = this.myLock;
        synchronized (object) {
            this.myCachedRevisionNumber = number;
        }
    }

    public VcsAbstractHistorySession(List<VcsFileRevision> revisions) {
        this.myRevisions = new ArrayList<VcsFileRevision>(revisions);
        this.myCachedRevisionNumber = this.calcCurrentRevisionNumber();
    }

    protected VcsAbstractHistorySession(List<VcsFileRevision> revisions, VcsRevisionNumber currentRevisionNumber) {
        this.myRevisions = new ArrayList<VcsFileRevision>(revisions);
        this.myCachedRevisionNumber = currentRevisionNumber;
    }

    @Override
    public List<VcsFileRevision> getRevisionList() {
        return this.myRevisions;
    }

    @Nullable
    protected abstract VcsRevisionNumber calcCurrentRevisionNumber();

    @Override
    public final VcsRevisionNumber getCurrentRevisionNumber() {
        return this.getCachedRevision();
    }

    @Override
    public boolean isCurrentRevision(VcsRevisionNumber rev) {
        VcsRevisionNumber revNumber = this.getCurrentRevisionNumber();
        return revNumber != null && revNumber.compareTo(rev) == 0;
    }

    @Override
    public synchronized boolean shouldBeRefreshed() {
        VcsRevisionNumber oldValue = this.getCachedRevision();
        VcsRevisionNumber newNumber = this.calcCurrentRevisionNumber();
        this.setCachedRevision(newNumber);
        return !Comparing.equal((Object)oldValue, (Object)newNumber);
    }

    @Override
    public boolean allowAsyncRefresh() {
        return false;
    }

    @Override
    public boolean isContentAvailable(VcsFileRevision revision) {
        return true;
    }
}

