/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class PanelWithActionsAndCloseButton
extends JPanel
implements DataProvider {
    protected final ContentManager myContentManager;
    private final String myHelpId;
    private final DefaultActionGroup myToolbalGroup;

    public PanelWithActionsAndCloseButton(@NotNull ContentManager contentManager, @NonNls String helpId) {
        if (contentManager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/ui/PanelWithActionsAndCloseButton.<init> must not be null");
        }
        super(new BorderLayout());
        this.myToolbalGroup = new DefaultActionGroup(null, false);
        this.myContentManager = contentManager;
        this.myHelpId = helpId;
        this.myContentManager.addContentManagerListener(new ContentManagerAdapter(){

            @Override
            public void contentRemoved(ContentManagerEvent event) {
                if (event.getContent().getComponent() == PanelWithActionsAndCloseButton.this) {
                    PanelWithActionsAndCloseButton.this.dispose();
                    PanelWithActionsAndCloseButton.this.myContentManager.removeContentManagerListener(this);
                }
            }
        });
    }

    public String getHelpId() {
        return this.myHelpId;
    }

    protected void init() {
        this.addActionsTo(this.myToolbalGroup);
        this.myToolbalGroup.add(new MyCloseAction());
        this.myToolbalGroup.add(ActionManager.getInstance().getAction("ContextHelp"));
        this.add((Component)ActionManager.getInstance().createActionToolbar("FileHistoryViewToolbar", this.myToolbalGroup, false).getComponent(), "West");
        this.add((Component)this.createCenterPanel(), "Center");
    }

    @Override
    public Object getData(String dataId) {
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return this.myHelpId;
        }
        return null;
    }

    protected abstract JComponent createCenterPanel();

    protected void addActionsTo(DefaultActionGroup group) {
    }

    protected void dispose() {
    }

    private class MyCloseAction
    extends AnAction
    implements DumbAware {
        public MyCloseAction() {
            super(CommonBundle.message((String)"close.action.name", (Object[])new Object[0]), null, IconLoader.getIcon((String)"/actions/cancel.png"));
        }

        @Override
        public void actionPerformed(AnActionEvent e) {
            Content content = PanelWithActionsAndCloseButton.this.myContentManager.getContent(PanelWithActionsAndCloseButton.this);
            if (content != null) {
                PanelWithActionsAndCloseButton.this.myContentManager.removeContent(content, true);
            }
        }
    }
}

