/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.AbstractTaskQueue;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class ProgressManagerQueue
extends AbstractTaskQueue<Runnable> {
    private final ProgressManager myProgressManager = ProgressManager.getInstance();
    private final Task.Backgroundable myTask;

    public ProgressManagerQueue(Project project, String title) {
        this.myTask = new Task.Backgroundable(project, title){

            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/progress/ProgressManagerQueue$1.run must not be null");
                }
                ProgressManagerQueue.this.myQueueWorker.run();
            }
        };
    }

    @Override
    protected void runMe() {
        Application app = ApplicationManager.getApplication();
        if (app.isDispatchThread()) {
            this.myProgressManager.run(this.myTask);
        } else {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressManagerQueue.this.myProgressManager.run(ProgressManagerQueue.this.myTask);
                }
            });
        }
    }

    @Override
    protected void runStuff(Runnable stuff) {
        try {
            stuff.run();
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
    }
}

