/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.Shortcut;

public final class MouseShortcut
extends Shortcut {
    private final int myButton;
    private final int myModifiers;
    private final int myClickCount;

    public MouseShortcut(int button, int modifiers, int clickCount) {
        if (1 != button && 2 != button && 3 != button) {
            throw new IllegalArgumentException("unknown button: " + button);
        }
        this.myButton = button;
        this.myModifiers = MouseShortcut.mapOldModifiers(modifiers);
        if (clickCount < 1) {
            throw new IllegalArgumentException("wrong clickCount: " + clickCount);
        }
        this.myClickCount = clickCount;
    }

    public int getButton() {
        return this.myButton;
    }

    public int getModifiers() {
        return this.myModifiers;
    }

    public int getClickCount() {
        return this.myClickCount;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MouseShortcut)) {
            return false;
        }
        MouseShortcut shortcut = (MouseShortcut)obj;
        return this.myButton == shortcut.myButton && this.myModifiers == shortcut.myModifiers && this.myClickCount == shortcut.myClickCount;
    }

    public int hashCode() {
        return this.myButton + this.myModifiers + this.myClickCount;
    }

    private static int mapOldModifiers(int modifiers) {
        if ((modifiers & 1) != 0) {
            modifiers |= 0x40;
        }
        if ((modifiers & 8) != 0) {
            modifiers |= 0x200;
        }
        if ((modifiers & 0x20) != 0) {
            modifiers |= 0x2000;
        }
        if ((modifiers & 2) != 0) {
            modifiers |= 0x80;
        }
        if ((modifiers & 4) != 0) {
            modifiers |= 0x100;
        }
        return modifiers &= 0x23C0;
    }

    @Override
    public boolean isKeyboard() {
        return false;
    }

    @Override
    public boolean startsWith(Shortcut sc) {
        return this.equals(sc);
    }
}

