/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FileStatus;
import java.awt.Color;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTreeNode<T>
extends PresentableNodeDescriptor
implements NavigationItem,
Queryable.Contributor {
    private AbstractTreeNode myParent;
    private T myValue;
    private NodeDescriptor myParentDescriptor;

    protected AbstractTreeNode(Project project, T value) {
        super(project, null);
        this.setValue(value);
    }

    @NotNull
    public abstract Collection<? extends AbstractTreeNode> getChildren();

    protected boolean hasProblemFileBeneath() {
        return false;
    }

    protected boolean valueIsCut() {
        return CopyPasteManager.getInstance().isCutElement(this.getValue());
    }

    @Override
    public PresentableNodeDescriptor getChildToHighlightAt(int index) {
        Collection<AbstractTreeNode> kids = this.getChildren();
        int i = 0;
        for (AbstractTreeNode kid : kids) {
            if (i == index) {
                return kid;
            }
            ++i;
        }
        return null;
    }

    @Override
    protected void postprocess(PresentationData presentation) {
        if (this.hasProblemFileBeneath()) {
            presentation.setAttributesKey(CodeInsightColors.ERRORS_ATTRIBUTES);
        }
        Color fgColor = this.getFileStatus().getColor();
        if (this.valueIsCut()) {
            fgColor = CopyPasteManager.CUT_COLOR;
        }
        if (presentation.getForcedTextForeground() == null) {
            presentation.setForcedTextForeground(fgColor);
        }
        if (this.hasProblemFileBeneath()) {
            presentation.setAttributesKey(CodeInsightColors.ERRORS_ATTRIBUTES);
        }
    }

    @Override
    protected boolean shouldUpdateData() {
        return !this.myProject.isDisposed() && this.getValue() != null;
    }

    public boolean isAlwaysShowPlus() {
        return false;
    }

    public boolean isAlwaysLeaf() {
        return false;
    }

    public boolean isAlwaysExpand() {
        return false;
    }

    @Override
    @Nullable
    public final Object getElement() {
        return this.getValue() != null ? this : null;
    }

    public boolean equals(Object object) {
        return object instanceof AbstractTreeNode && Comparing.equal(this.getValue(), ((AbstractTreeNode)object).getValue());
    }

    public int hashCode() {
        return this.getValue() == null ? 0 : this.getValue().hashCode();
    }

    public final AbstractTreeNode getParent() {
        return this.myParent;
    }

    public final void setParent(AbstractTreeNode parent) {
        this.myParent = parent;
        this.myParentDescriptor = parent;
    }

    public final AbstractTreeNode setParentDescriptor(NodeDescriptor parentDescriptor) {
        this.myParentDescriptor = parentDescriptor;
        return this;
    }

    @Override
    public final NodeDescriptor getParentDescriptor() {
        return this.myParentDescriptor;
    }

    public final T getValue() {
        return this.myValue;
    }

    public final void setValue(T value) {
        this.myValue = value;
    }

    @Nullable
    public String toTestString(Queryable.PrintInfo printInfo) {
        String text;
        if (this.getValue() instanceof Queryable && (text = Queryable.Util.print((Queryable)this.getValue(), printInfo, this)) != null) {
            return text;
        }
        return this.getTestPresentation();
    }

    @Override
    public void apply(Map<String, String> info) {
    }

    @Nullable
    @NonNls
    public String getTestPresentation() {
        if (this.myName != null) {
            return this.myName;
        }
        if (this.getValue() != null) {
            return this.getValue().toString();
        }
        return null;
    }

    @Override
    public FileStatus getFileStatus() {
        return FileStatus.NOT_CHANGED;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public void navigate(boolean requestFocus) {
    }

    @Override
    public boolean canNavigate() {
        return false;
    }

    @Override
    public boolean canNavigateToSource() {
        return false;
    }

    @Nullable
    protected final Object getParentValue() {
        AbstractTreeNode parent = this.getParent();
        return parent == null ? null : parent.getValue();
    }

    public boolean canRepresent(Object element) {
        return Comparing.equal(this.getValue(), (Object)element);
    }

    protected String getToolTip() {
        return ((PresentationData)this.getPresentation()).getTooltip();
    }

    @Nullable
    public TextAttributesKey getAttributesKey() {
        return ((PresentationData)this.getPresentation()).getTextAttributesKey();
    }

    @Nullable
    public String getLocationString() {
        return ((PresentationData)this.getPresentation()).getLocationString();
    }
}

