/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.ValueHolder;
import com.intellij.util.containers.Convertor;
import com.intellij.util.continuation.TaskDescriptor;
import org.jetbrains.idea.svn.dialogs.RunOrContinuation;

public class FactsCalculator<In, Out> {
    private final Project myProject;
    private final String myTaskTitle;
    private final ValueHolder<Out, In> myCache;
    private final Convertor<In, Out> myLive;

    public FactsCalculator(Project project, String taskTitle, ValueHolder<Out, In> cache, Convertor<In, Out> live) {
        this.myProject = project;
        this.myTaskTitle = taskTitle;
        this.myCache = cache;
        this.myLive = live;
    }

    public void get(In in, Consumer<Out> resultConsumer) {
        this.createRunOrContinuation(in, resultConsumer).execute();
    }

    private RunOrContinuation<Out> createRunOrContinuation(final In in, final Consumer<Out> resultConsumer) {
        return new RunOrContinuation<Out>(this.myProject, this.myTaskTitle){

            @Override
            protected Out calculate() {
                return FactsCalculator.this.myCache.getValue(in);
            }

            @Override
            protected Out calculateLong() {
                Object result = FactsCalculator.this.myLive.convert(in);
                if (result != null) {
                    FactsCalculator.this.myCache.setValue(result, in);
                }
                return result;
            }

            @Override
            protected void processResult(Out out) {
                resultConsumer.consume(out);
            }
        };
    }

    public TaskDescriptor getTask(In in, Consumer<Out> resultConsumer) {
        return this.createRunOrContinuation(in, resultConsumer).getTask();
    }
}

