/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.psi.impl.reference;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.AntSupport;
import com.intellij.lang.ant.config.AntConfigurationBase;
import com.intellij.lang.ant.psi.AntAnt;
import com.intellij.lang.ant.psi.AntCall;
import com.intellij.lang.ant.psi.AntElement;
import com.intellij.lang.ant.psi.AntFile;
import com.intellij.lang.ant.psi.AntProject;
import com.intellij.lang.ant.psi.AntTarget;
import com.intellij.lang.ant.psi.impl.AntAntImpl;
import com.intellij.lang.ant.psi.impl.reference.AntGenericReference;
import com.intellij.lang.ant.quickfix.AntChangeContextFix;
import com.intellij.lang.ant.quickfix.AntCreateTargetFix;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLock;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.StringBuilderSpinAllocator;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntTargetReference
extends AntGenericReference {
    private boolean myShouldBeSkippedByAnnotator;

    public AntTargetReference(AntElement antElement, String str, TextRange textRange, XmlAttribute attribute) {
        super(antElement, str, textRange, attribute);
        this.setShouldBeSkippedByAnnotator(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        AntElement element = this.getElement();
        if (element instanceof AntProject || element instanceof AntCall || element instanceof AntAnt) {
            this.getAttribute().setValue(newElementName);
        } else if (element instanceof AntTarget) {
            int start = this.getElementStartOffset() + this.getReferenceStartOffset() - this.getAttributeValueStartOffset();
            String value = this.getAttribute().getValue();
            StringBuilder builder = StringBuilderSpinAllocator.alloc();
            try {
                if (start > 0) {
                    builder.append(value.substring(0, start));
                }
                builder.append(newElementName);
                if (value.length() > start + this.getRangeInElement().getLength()) {
                    builder.append(value.substring(start + this.getRangeInElement().getLength()));
                }
                this.getAttribute().setValue(builder.toString());
            }
            finally {
                StringBuilderSpinAllocator.dispose((StringBuilder)builder);
            }
        }
        return element;
    }

    @Nullable
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/psi/impl/reference/AntTargetReference.bindToElement must not be null");
        }
        if (element instanceof AntTarget) {
            PsiNamedElement psiNamedElement = (PsiNamedElement)element;
            return this.handleElementRename(psiNamedElement.getName());
        }
        throw new IncorrectOperationException("Can bind only to ant targets.");
    }

    @Override
    public PsiElement resolveInner() {
        AntFile antFile;
        PsiFile psiFile;
        String name = this.getCanonicalRepresentationText();
        if (name == null) {
            return null;
        }
        AntElement element = this.getElement();
        AntConfigurationBase antConfig = AntConfigurationBase.getInstance(element.getProject());
        AntTarget result = null;
        if (element instanceof AntAntImpl && (psiFile = ((AntAntImpl)element).getCalledAntFile()) != null && (antFile = AntSupport.getAntFile(psiFile)) != null) {
            AntFile context = antConfig.getEffectiveContextFile(antFile);
            assert (context != null);
            AntProject project = context.getAntProject();
            if (project != null) {
                result = AntTargetReference.resolveTargetImpl(name, project);
            }
        }
        if (result == null) {
            AntFile context = antConfig.getEffectiveContextFile(element.getAntFile());
            assert (context != null);
            result = AntTargetReference.resolveTargetImpl(name, context.getAntProject());
        }
        return result;
    }

    private static AntTarget resolveTargetImpl(String name, AntProject project) {
        AntTarget result = project.getTarget(name);
        if (result != null) {
            return result;
        }
        for (AntTarget target : project.getImportedTargets()) {
            if (!name.equals(target.getName())) continue;
            return target;
        }
        for (AntTarget target : project.getImportedTargets()) {
            if (!name.equals(target.getQualifiedName())) continue;
            return target;
        }
        return null;
    }

    @Override
    public String getUnresolvedMessagePattern() {
        return AntBundle.message("cannot.resolve.target", this.getCanonicalRepresentationText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shouldBeSkippedByAnnotator() {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            return this.myShouldBeSkippedByAnnotator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setShouldBeSkippedByAnnotator(boolean value) {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            this.myShouldBeSkippedByAnnotator = value;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Object[] getVariants() {
        AntTarget[] targets;
        Object[] objectArray;
        PsiFile psiFile;
        AntElement element = this.getElement();
        if (element instanceof AntAntImpl && (psiFile = ((AntAntImpl)element).getCalledAntFile()) != null) {
            AntProject project;
            AntFile antFile = psiFile instanceof AntFile ? (AntFile)psiFile : AntSupport.getAntFile(psiFile);
            AntProject antProject = project = antFile == null ? null : antFile.getAntProject();
            if (project != null) {
                objectArray = project.getTargets();
                if (objectArray == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/reference/AntTargetReference.getVariants must not return null");
                return objectArray;
            }
        }
        ArrayList<AntTarget> result = new ArrayList<AntTarget>();
        AntProject project = element.getAntProject();
        for (AntTarget target : targets = project.getTargets()) {
            if (target == element) continue;
            result.add(target);
        }
        result.addAll(Arrays.asList(project.getImportedTargets()));
        objectArray = result.toArray();
        if (objectArray != null) return objectArray;
        throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/reference/AntTargetReference.getVariants must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public IntentionAction[] getFixes() {
        IntentionAction[] intentionActionArray;
        String name = this.getCanonicalRepresentationText();
        if (name == null || name.length() == 0) {
            intentionActionArray = IntentionAction.EMPTY_ARRAY;
            if (IntentionAction.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/reference/AntTargetReference.getFixes must not return null");
            return intentionActionArray;
        }
        AntProject project = this.getElement().getAntProject();
        AntFile[] importedFiles = project.getImportedFiles();
        ArrayList<BaseIntentionAction> result = new ArrayList<BaseIntentionAction>(importedFiles.length + 1);
        result.add(new AntCreateTargetFix(this));
        for (AntFile file : importedFiles) {
            if (!file.isPhysical()) continue;
            result.add(new AntCreateTargetFix(this, file));
        }
        result.add(new AntChangeContextFix());
        intentionActionArray = result.toArray(new IntentionAction[result.size()]);
        if (intentionActionArray != null) return intentionActionArray;
        throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/reference/AntTargetReference.getFixes must not return null");
    }

    private int getElementStartOffset() {
        return this.getElement().getTextRange().getStartOffset();
    }

    private int getReferenceStartOffset() {
        return this.getRangeInElement().getStartOffset();
    }

    private int getAttributeValueStartOffset() {
        XmlAttribute attr = this.getAttribute();
        XmlAttributeValue valueElement = attr.getValueElement();
        return valueElement == null ? attr.getTextRange().getEndOffset() + 1 : valueElement.getTextRange().getStartOffset() + 1;
    }
}

