/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.psi.impl;

import com.intellij.lang.ant.psi.AntElement;
import com.intellij.lang.ant.psi.AntFilesProvider;
import com.intellij.lang.ant.psi.impl.AntFilesProviderImpl;
import com.intellij.lang.ant.psi.impl.AntPattern;
import com.intellij.lang.ant.psi.introspection.AntTypeDefinition;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.StringBuilderSpinAllocator;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AntFileSetImpl
extends AntFilesProviderImpl {
    public AntFileSetImpl(AntElement parent, XmlTag sourceElement) {
        super(parent, sourceElement);
    }

    public AntFileSetImpl(AntElement parent, XmlTag sourceElement, AntTypeDefinition definition, @NonNls String nameElementAttribute) {
        super(parent, sourceElement, definition, nameElementAttribute);
    }

    public AntFileSetImpl(AntElement parent, XmlTag sourceElement, AntTypeDefinition definition) {
        super(parent, sourceElement, definition);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    protected List<File> getFiles(AntPattern pattern, Set<AntFilesProvider> processed) {
        List<Object> list;
        File root;
        File singleFile = this.getCanonicalFile(this.computeAttributeValue(this.getSourceElement().getAttributeValue("file")));
        if ((singleFile == null || pattern.hasIncludePatterns()) && (root = this.getCanonicalFile(this.computeAttributeValue(this.getSourceElement().getAttributeValue("dir")))) != null) {
            ArrayList<File> files = new ArrayList<File>();
            if (singleFile != null) {
                files.add(singleFile);
            }
            new FilesCollector().collectFiles(files, root, "", pattern);
            list = files;
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntFileSetImpl.getFiles must not return null");
            return list;
        }
        if (singleFile != null) {
            list = Collections.singletonList(singleFile);
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntFileSetImpl.getFiles must not return null");
            return list;
        }
        list = Collections.emptyList();
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/AntFileSetImpl.getFiles must not return null");
    }

    private static class FilesCollector {
        private static final int MAX_DIRS_TO_PROCESS = 100;
        private int myDirsProcessed = 0;
        private boolean myDirCheckEnabled = false;

        private FilesCollector() {
        }

        public void collectFiles(List<File> container, File from, String relativePath, AntPattern pattern) {
            if (this.myDirsProcessed > 100) {
                return;
            }
            File[] children = from.listFiles();
            if (children != null && children.length > 0) {
                if (this.myDirCheckEnabled) {
                    if (!pattern.couldBeIncluded(relativePath)) {
                        return;
                    }
                } else {
                    this.myDirCheckEnabled = true;
                }
                ++this.myDirsProcessed;
                for (File child : children) {
                    String childPath = FilesCollector.makePath(relativePath, child.getName());
                    if (pattern.acceptPath(childPath)) {
                        container.add(child);
                    }
                    this.collectFiles(container, child, childPath, pattern);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static String makePath(String parentPath, String name) {
            if (parentPath.length() == 0) {
                return name;
            }
            StringBuilder builder = StringBuilderSpinAllocator.alloc();
            try {
                String string = builder.append(parentPath).append("/").append(name).toString();
                return string;
            }
            finally {
                StringBuilderSpinAllocator.dispose((StringBuilder)builder);
            }
        }
    }
}

