/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.lang.ant.config.AntBuildFile;
import com.intellij.lang.ant.config.AntBuildFileBase;
import com.intellij.lang.ant.config.AntConfiguration;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

@State(name="antWorkspaceConfiguration", storages={@Storage(id="other", file="$WORKSPACE_FILE$")})
public class AntWorkspaceConfiguration
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.ant.config.impl.AntWorkspaceConfiguration");
    private final Project myProject;
    @NonNls
    private static final String BUILD_FILE = "buildFile";
    @NonNls
    private static final String URL = "url";
    private final AtomicReference<Element> myProperties = new AtomicReference<Object>(null);
    public boolean IS_AUTOSCROLL_TO_SOURCE;
    public boolean FILTER_TARGETS;

    public AntWorkspaceConfiguration(Project project) {
        this.myProject = project;
    }

    public Element getState() {
        try {
            Element e = new Element("state");
            this.writeExternal(e);
            return e;
        }
        catch (WriteExternalException e1) {
            LOG.error((Throwable)e1);
            return null;
        }
    }

    public void loadState(Element state) {
        try {
            this.readExternal(state);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
    }

    public void initComponent() {
    }

    public void readExternal(Element parentNode) throws InvalidDataException {
        this.loadGlobalSettings(parentNode);
        this.myProperties.set(parentNode);
    }

    public void writeExternal(Element parentNode) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)parentNode);
        for (AntBuildFile buildFile : AntConfiguration.getInstance(this.myProject).getBuildFiles()) {
            Element element = new Element(BUILD_FILE);
            element.setAttribute(URL, buildFile.getVirtualFile().getUrl());
            ((AntBuildFileBase)buildFile).writeWorkspaceProperties(element);
            parentNode.addContent(element);
        }
    }

    public static AntWorkspaceConfiguration getInstance(Project project) {
        return (AntWorkspaceConfiguration)ServiceManager.getService((Project)project, AntWorkspaceConfiguration.class);
    }

    public void loadFileProperties() throws InvalidDataException {
        Element properties = this.myProperties.getAndSet(null);
        if (properties == null) {
            return;
        }
        for (AntBuildFile buildFile : AntConfiguration.getInstance(this.myProject).getBuildFiles()) {
            Element fileElement = AntWorkspaceConfiguration.findChildByUrl(properties, buildFile.getVirtualFile().getUrl());
            if (fileElement == null) continue;
            ((AntBuildFileBase)buildFile).readWorkspaceProperties(fileElement);
        }
    }

    public void loadFromProjectSettings(Element parentNode) throws InvalidDataException {
        this.loadGlobalSettings(parentNode);
    }

    private void loadGlobalSettings(Element parentNode) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)parentNode);
    }

    @Nullable
    private static Element findChildByUrl(Element parentNode, String url) {
        List children = parentNode.getChildren(BUILD_FILE);
        for (Object aChildren : children) {
            Element element = (Element)aChildren;
            if (!Comparing.equal((String)element.getAttributeValue(URL), (String)url)) continue;
            return element;
        }
        return null;
    }
}

