/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.execution;

import com.intellij.lang.ant.config.execution.AntBuildMessageView;
import com.intellij.lang.ant.config.execution.MessageNode;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.MultilineTreeCellRenderer;
import com.intellij.util.Icons;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTree;

final class MessageTreeRenderer
extends MultilineTreeCellRenderer {
    private static final Icon myBuildIcon = IconLoader.getIcon((String)"/ant/build.png");
    private static final Icon myMessageIcon = IconLoader.getIcon((String)"/ant/message.png");
    private static final Icon myWarningIcon = IconLoader.getIcon((String)"/compiler/warning.png");
    private static final Icon myErrorIcon = IconLoader.getIcon((String)"/compiler/error.png");

    private MessageTreeRenderer() {
    }

    public static JScrollPane install(JTree tree) {
        return MultilineTreeCellRenderer.installRenderer((JTree)tree, (MultilineTreeCellRenderer)new MessageTreeRenderer());
    }

    protected void initComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (value instanceof MessageNode) {
            MessageNode messageNode = (MessageNode)value;
            this.setText(messageNode.getText(), messageNode.getTypeString() + messageNode.getPositionString());
        } else {
            String[] text = new String[]{value.toString()};
            if (text[0] == null) {
                text[0] = "";
            }
            this.setText(text, null);
        }
        Icon icon = null;
        if (value instanceof MessageNode) {
            MessageNode node = (MessageNode)value;
            AntBuildMessageView.MessageType type = node.getType();
            if (type == AntBuildMessageView.MessageType.BUILD) {
                icon = myBuildIcon;
            } else if (type == AntBuildMessageView.MessageType.TARGET) {
                icon = Icons.ANT_TARGET_ICON;
            } else if (type == AntBuildMessageView.MessageType.TASK) {
                icon = Icons.TASK_ICON;
            } else if (type == AntBuildMessageView.MessageType.MESSAGE) {
                icon = node.getPriority() == 1 ? myWarningIcon : myMessageIcon;
            } else if (type == AntBuildMessageView.MessageType.ERROR) {
                icon = myErrorIcon;
            }
        }
        this.setIcon(icon);
    }
}

