/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.execution;

import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.actions.CloseTabToolbarAction;
import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.ide.actions.NextOccurenceToolbarAction;
import com.intellij.ide.actions.PreviousOccurenceToolbarAction;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.config.AntBuildFileBase;
import com.intellij.lang.ant.config.AntBuildListener;
import com.intellij.lang.ant.config.actions.ChangeViewAction;
import com.intellij.lang.ant.config.actions.PauseOutputAction;
import com.intellij.lang.ant.config.actions.RunAction;
import com.intellij.lang.ant.config.actions.StopAction;
import com.intellij.lang.ant.config.actions.VerboseAction;
import com.intellij.lang.ant.config.execution.AntMessage;
import com.intellij.lang.ant.config.execution.AntOutputView;
import com.intellij.lang.ant.config.execution.OutputParser;
import com.intellij.lang.ant.config.execution.PlainTextView;
import com.intellij.lang.ant.config.execution.TreeView;
import com.intellij.lang.ant.config.impl.AntBuildFileImpl;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.peer.PeerFactory;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.MessageView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AntBuildMessageView
extends JPanel
implements DataProvider,
OccurenceNavigator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ant.execution.AntBuildMessageView");
    private static final Key<AntBuildMessageView> KEY = Key.create((String)"BuildMessageView.KEY");
    private static final String BUILD_CONTENT_NAME = AntBundle.message("ant.build.tab.content.title", new Object[0]);
    private OutputParser myParsingThread;
    private final Project myProject;
    private final JPanel myMessagePanel;
    private AntBuildFileBase myBuildFile;
    private final String[] myTargets;
    private static final int VERBOSE_MODE = 3;
    private static final int BRIEF_MODE = 2;
    private int myPriorityThreshold = 2;
    private int myErrorCount;
    private int myWarningCount;
    private boolean myIsOutputPaused = false;
    private AntOutputView myCurrentView;
    private final PlainTextView myPlainTextView;
    private final TreeView myTreeView;
    private final ArrayList<LogCommand> myLog = new ArrayList(1024);
    private int myCommandsProcessedCount = 0;
    private JPanel myProgressPanel;
    private final Timer myScrollerTimer = new Timer(1000, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AntBuildMessageView.this.myTreeView != null && AntBuildMessageView.this.myCommandsProcessedCount < AntBuildMessageView.this.myLog.size() && !AntBuildMessageView.this.myIsOutputPaused) {
                new OutputFlusher().doFlush();
                AntBuildMessageView.this.myTreeView.scrollToLastMessage();
            }
        }
    });
    private boolean myIsAborted;
    private ActionToolbar myLeftToolbar;
    private ActionToolbar myRightToolbar;
    private final TreeExpander myTreeExpander = new TreeExpander(){

        public boolean canCollapse() {
            return AntBuildMessageView.this.isTreeView();
        }

        public boolean canExpand() {
            return AntBuildMessageView.this.isTreeView();
        }

        public void collapseAll() {
            AntBuildMessageView.this.collapseAll();
        }

        public void expandAll() {
            AntBuildMessageView.this.expandAll();
        }
    };
    @NonNls
    public static final String FILE_PREFIX = "file:";

    private AntBuildMessageView(Project project, AntBuildFileBase buildFile, String[] targets) {
        super(new BorderLayout(2, 0));
        this.myProject = project;
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.myPlainTextView = new PlainTextView(project);
        this.myTreeView = new TreeView(project, buildFile);
        this.myMessagePanel = new JPanel(new BorderLayout());
        this.myBuildFile = buildFile;
        this.myTargets = targets;
        this.showAntView(AntBuildFileImpl.TREE_VIEW.value(buildFile.getAllOptions()));
        this.setVerboseMode(AntBuildFileImpl.VERBOSE.value(buildFile.getAllOptions()));
        this.add((Component)this.createToolbarPanel(), "West");
        this.add((Component)this.myMessagePanel, "Center");
    }

    public void changeView() {
        this.showAntView(!this.isTreeView());
        if (this.myBuildFile != null) {
            this.myBuildFile.setTreeView(this.isTreeView());
        }
    }

    private boolean isTreeView() {
        return this.myCurrentView == this.myTreeView;
    }

    public void setVerboseMode(boolean verbose) {
        this.changeDetalizationLevel(verbose ? 3 : 2);
        if (this.myBuildFile != null) {
            this.myBuildFile.setVerboseMode(verbose);
        }
    }

    public boolean isVerboseMode() {
        return this.myPriorityThreshold == 3;
    }

    private synchronized void changeDetalizationLevel(int priorityThreshold) {
        this.myPriorityThreshold = priorityThreshold;
        TreeView.TreeSelection selection = this.myTreeView.getSelection();
        this.myTreeView.clearAllMessages();
        this.myPlainTextView.clearAllMessages();
        this.myTreeView.setActionsEnabled(false);
        new OutputFlusher(){

            @Override
            public void doFlush() {
                for (int i = 0; i < AntBuildMessageView.this.myCommandsProcessedCount; ++i) {
                    LogCommand command = (LogCommand)AntBuildMessageView.this.myLog.get(i);
                    this.proceedOneCommand(command);
                }
                this.flushDelayedMessages();
            }
        }.doFlush();
        this.myTreeView.setActionsEnabled(true);
        if (!this.myTreeView.restoreSelection(selection)) {
            this.myTreeView.scrollToLastMessage();
        }
    }

    private void showAntView(boolean treeView) {
        AntOutputView newView;
        AntOutputView oldView = this.getOutputView(treeView);
        this.myCurrentView = newView = this.getOutputView(!treeView);
        this.myMessagePanel.remove(oldView.getComponent());
        this.myMessagePanel.add((Component)newView.getComponent(), "Center");
        this.myMessagePanel.validate();
        JComponent component = IdeFocusTraversalPolicy.getPreferredFocusedComponent((JComponent)this.myMessagePanel);
        component.requestFocus();
        this.repaint();
    }

    private AntOutputView getOutputView(boolean isText) {
        return isText ? this.myPlainTextView : this.myTreeView;
    }

    public AntBuildFileBase getBuildFile() {
        return this.myBuildFile;
    }

    @Nullable
    public static AntBuildMessageView openBuildMessageView(Project project, AntBuildFileBase buildFile, String[] targets) {
        Content[] contents;
        VirtualFile antFile = buildFile.getVirtualFile();
        if (!LOG.assertTrue(antFile != null)) {
            return null;
        }
        MessageView ijMessageView = MessageView.SERVICE.getInstance((Project)project);
        block4: for (Content content : contents = ijMessageView.getContentManager().getContents()) {
            AntBuildMessageView buildMessageView;
            if (content.isPinned() || (buildMessageView = (AntBuildMessageView)content.getUserData(KEY)) == null || !antFile.equals(buildMessageView.getBuildFile().getVirtualFile())) continue;
            if (buildMessageView.isStopped()) {
                ijMessageView.getContentManager().removeContent(content, true);
                continue;
            }
            int result = Messages.showYesNoCancelDialog((String)AntBundle.message("ant.is.active.terminate.confirmation.text", new Object[0]), (String)AntBundle.message("starting.ant.build.dialog.title", new Object[0]), (Icon)Messages.getQuestionIcon());
            switch (result) {
                case 0: {
                    buildMessageView.stopProcess();
                    ijMessageView.getContentManager().removeContent(content, true);
                    continue block4;
                }
                case 1: {
                    continue block4;
                }
                default: {
                    return null;
                }
            }
        }
        AntBuildMessageView messageView = new AntBuildMessageView(project, buildFile, targets);
        String contentName = buildFile.getPresentableName();
        contentName = BUILD_CONTENT_NAME + " (" + contentName + ")";
        Content content = PeerFactory.getInstance().getContentFactory().createContent(messageView.getComponent(), contentName, true);
        content.putUserData(KEY, (Object)messageView);
        ijMessageView.getContentManager().addContent(content);
        ijMessageView.getContentManager().setSelectedContent(content);
        new CloseListener(content, ijMessageView.getContentManager(), project);
        ToolWindow messageToolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(ToolWindowId.MESSAGES_WINDOW);
        messageToolWindow.activate(null);
        return messageView;
    }

    public void removeProgressPanel() {
        if (this.myProgressPanel != null) {
            this.myMessagePanel.remove(this.myProgressPanel);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AntBuildMessageView.this.myMessagePanel.validate();
                }
            });
            this.myProgressPanel = null;
        }
    }

    public void setParsingThread(OutputParser parsingThread) {
        this.myParsingThread = parsingThread;
        this.myIsAborted = false;
    }

    public void stopProcess() {
        if (this.myParsingThread != null) {
            this.myParsingThread.stopProcess();
        }
        this.myIsAborted = true;
        this.myLeftToolbar.updateActionsImmediately();
        this.myRightToolbar.updateActionsImmediately();
    }

    public boolean isStopped() {
        return this.myParsingThread == null || this.myParsingThread.isStopped();
    }

    public boolean isStoppedOrTerminateRequested() {
        return this.myParsingThread == null || this.myParsingThread.isTerminateInvoked() || this.isStopped();
    }

    private void close() {
        Content[] contents;
        MessageView messageView = MessageView.SERVICE.getInstance((Project)this.myProject);
        for (Content content : contents = messageView.getContentManager().getContents()) {
            if (content.getComponent() != this) continue;
            messageView.getContentManager().removeContent(content, true);
            return;
        }
    }

    private JPanel createToolbarPanel() {
        RunAction runAction = new RunAction(this);
        runAction.registerCustomShortcutSet(CommonShortcuts.getRerun(), this);
        DefaultActionGroup leftActionGroup = new DefaultActionGroup();
        leftActionGroup.add((AnAction)runAction);
        leftActionGroup.add((AnAction)new PauseOutputAction(this));
        leftActionGroup.add((AnAction)new StopAction(this));
        leftActionGroup.add((AnAction)new CloseAction());
        leftActionGroup.add((AnAction)new PreviousOccurenceToolbarAction((OccurenceNavigator)this));
        leftActionGroup.add((AnAction)new NextOccurenceToolbarAction((OccurenceNavigator)this));
        leftActionGroup.add((AnAction)new ContextHelpAction("ant.antToolWindow"));
        DefaultActionGroup rightActionGroup = new DefaultActionGroup();
        rightActionGroup.add((AnAction)new ChangeViewAction(this));
        rightActionGroup.add((AnAction)new VerboseAction(this));
        rightActionGroup.add(CommonActionsManager.getInstance().createExpandAllAction(this.myTreeExpander, (JComponent)this));
        rightActionGroup.add(CommonActionsManager.getInstance().createCollapseAllAction(this.myTreeExpander, (JComponent)this));
        rightActionGroup.add((AnAction)this.myTreeView.createToggleAutoscrollAction());
        this.myLeftToolbar = ActionManager.getInstance().createActionToolbar("AntMessagesToolbar", (ActionGroup)leftActionGroup, false);
        JPanel toolbarPanel = new JPanel(new GridLayout(1, 2, 2, 0));
        toolbarPanel.add(this.myLeftToolbar.getComponent());
        this.myRightToolbar = ActionManager.getInstance().createActionToolbar("AntMessagesToolbar", (ActionGroup)rightActionGroup, false);
        toolbarPanel.add(this.myRightToolbar.getComponent());
        return toolbarPanel;
    }

    private synchronized void addCommand(LogCommand command) {
        this.myLog.add(command);
    }

    public void startBuild(String buildName) {
        this.addCommand(new StartBuildCommand(buildName));
    }

    public void buildFailed(String buildName) {
        this.addCommand(new BuildFailedCommand(buildName));
    }

    public void startTarget(String targetName) {
        this.addCommand(new StartTargetCommand(targetName));
    }

    public void startTask(String taskName) {
        this.addCommand(new StartTaskCommand(taskName));
    }

    public void outputMessage(String message, int priority) {
        this.updateErrorAndWarningCounters(priority);
        this.addMessage(MessageType.MESSAGE, priority, message, null, 0, 0);
    }

    public void outputError(String error, int priority) {
        AntMessage message = AntBuildMessageView.createErrorMessage(MessageType.ERROR, priority, error);
        this.addMessage(MessageType.ERROR, priority, error, message.getFile(), message.getLine(), message.getColumn());
        WolfTheProblemSolver wolf = WolfTheProblemSolver.getInstance((Project)this.myProject);
        wolf.queue(message.getFile());
    }

    public void outputException(String exception) {
        this.updateErrorAndWarningCounters(0);
        AntMessage message = AntBuildMessageView.createErrorMessage(MessageType.ERROR, 0, exception);
        this.addCommand(new AddExceptionCommand(message));
        WolfTheProblemSolver wolf = WolfTheProblemSolver.getInstance((Project)this.myProject);
        wolf.queue(message.getFile());
    }

    private void updateErrorAndWarningCounters(int priority) {
        if (priority == 0) {
            ++this.myErrorCount;
        } else if (priority == 1) {
            ++this.myWarningCount;
        }
    }

    public void finishTarget() {
        this.addCommand(new FinishTargetCommand());
    }

    public void finishTask() {
        this.addCommand(new FinishTaskCommand());
    }

    public Object getData(String dataId) {
        Object data = this.myCurrentView.getData(dataId);
        if (data != null) {
            return data;
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return "ant.antToolWindow";
        }
        if (PlatformDataKeys.TREE_EXPANDER.is(dataId)) {
            return this.myTreeExpander;
        }
        return null;
    }

    private static AntMessage createErrorMessage(MessageType type, int priority, String text) {
        String fileAndLineNumber;
        int index;
        int afterLineNumberIndex;
        if (text.startsWith(FILE_PREFIX)) {
            text = text.substring(FILE_PREFIX.length());
        }
        if ((afterLineNumberIndex = text.indexOf(": ")) != -1 && (index = (fileAndLineNumber = text.substring(0, afterLineNumberIndex)).lastIndexOf(58)) != -1) {
            String fileName = fileAndLineNumber.substring(0, index);
            String lineNumberStr = fileAndLineNumber.substring(index + 1, fileAndLineNumber.length()).trim();
            try {
                int line = Integer.parseInt(lineNumberStr);
                final File file = new File(fileName);
                VirtualFile result = (VirtualFile)ApplicationManager.getApplication().runReadAction((Computable)new Computable<VirtualFile>(){

                    public VirtualFile compute() {
                        String url = VirtualFileManager.constructUrl((String)"file", (String)file.getAbsolutePath().replace(File.separatorChar, '/'));
                        return VirtualFileManager.getInstance().findFileByUrl(url);
                    }
                });
                text = fileName.replace('/', File.separatorChar) + ':' + line + text.substring(afterLineNumberIndex);
                return new AntMessage(type, priority, text, result, line, 1);
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
        return new AntMessage(type, priority, text, null, 0, 0);
    }

    private void addMessage(MessageType type, int priority, String text, VirtualFile file, int line, int column) {
        AntMessage message = new AntMessage(type, priority, text, file, line, column);
        this.addCommand(new AddMessageCommand(message));
    }

    public void outputJavacMessage(MessageType type, String[] text, VirtualFile file, String url, int line, int column) {
        int priority = type == MessageType.ERROR ? 0 : 3;
        this.updateErrorAndWarningCounters(priority);
        AntMessage message = new AntMessage(type, priority, text, file, line, column);
        this.addCommand(new AddJavacMessageCommand(message, url));
        if (type == MessageType.ERROR) {
            WolfTheProblemSolver wolf = WolfTheProblemSolver.getInstance((Project)this.myProject);
            wolf.queue(file);
        }
    }

    private JComponent getComponent() {
        return this;
    }

    public void emptyAll() {
        this.myLog.clear();
        this.myCommandsProcessedCount = 0;
        this.myErrorCount = 0;
        this.myWarningCount = 0;
        this.myPlainTextView.clearAllMessages();
        this.myTreeView.clearAllMessages();
    }

    private void collapseAll() {
        this.myTreeView.collapseAll();
    }

    private void expandAll() {
        this.myTreeView.expandAll();
    }

    public String[] getTargets() {
        return this.myTargets;
    }

    private int getErrorCount() {
        return this.myErrorCount;
    }

    private int getWarningCount() {
        return this.myWarningCount;
    }

    void startScrollerThread() {
        this.myScrollerTimer.start();
    }

    void stopScrollerThread() {
        this.myScrollerTimer.stop();
    }

    /*
     * WARNING - void declaration
     */
    void buildFinished(boolean isProgressAborted, long buildTimeInMilliseconds, @NotNull AntBuildListener antBuildListener) {
        void antBuildListener2;
        if (antBuildListener == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/lang/ant/config/execution/AntBuildMessageView.buildFinished must not be null");
        }
        boolean aborted = isProgressAborted || this.myIsAborted;
        String message = this.getFinishStatusText(aborted, buildTimeInMilliseconds);
        WindowManager.getInstance().getStatusBar(this.myProject).setInfo(message);
        this.addCommand(new FinishBuildCommand(message));
        if (!this.myIsOutputPaused) {
            new OutputFlusher().doFlush();
            this.myTreeView.scrollToLastMessage();
        }
        ApplicationManager.getApplication().invokeLater(new Runnable((AntBuildListener)antBuildListener2, aborted){
            final /* synthetic */ AntBuildListener val$antBuildListener;
            final /* synthetic */ boolean val$aborted;
            {
                this.val$antBuildListener = antBuildListener;
                this.val$aborted = bl;
            }

            @Override
            public void run() {
                AntBuildFileBase buildFile = AntBuildMessageView.this.myBuildFile;
                if (buildFile != null) {
                    if (AntBuildMessageView.this.getErrorCount() == 0 && buildFile.isViewClosedWhenNoErrors()) {
                        AntBuildMessageView.this.close();
                    } else if (AntBuildMessageView.this.getErrorCount() > 0) {
                        AntBuildMessageView.this.myTreeView.scrollToFirstError();
                    } else {
                        AntBuildMessageView.this.myTreeView.scrollToStatus();
                    }
                }
                VirtualFileManager.getInstance().refresh(true, new Runnable(){

                    @Override
                    public void run() {
                        val$antBuildListener.buildFinished(val$aborted ? 1 : 0, AntBuildMessageView.this.getErrorCount());
                    }
                });
            }
        });
    }

    private String getFinishStatusText(boolean isAborted, long buildTimeInMilliseconds) {
        int errors = this.getErrorCount();
        int warnings = this.getWarningCount();
        String theDateAsString = DateFormat.getTimeInstance().format(new Date());
        long buildTimeInSeconds = buildTimeInMilliseconds / 1000L;
        if (isAborted) {
            return AntBundle.message("build.finished.status.ant.build.aborted", buildTimeInSeconds, theDateAsString);
        }
        if (errors == 0 && warnings == 0) {
            return AntBundle.message("build.finished.status.ant.build.completed.successfully", buildTimeInSeconds, theDateAsString);
        }
        if (errors == 0) {
            return AntBundle.message("build.finished.status.ant.build.completed.with.warnings", warnings, buildTimeInSeconds, theDateAsString);
        }
        return AntBundle.message("build.finished.status.ant.build.completed.with.errors.warnings", errors, warnings, buildTimeInSeconds, theDateAsString);
    }

    public boolean isOutputPaused() {
        return this.myIsOutputPaused;
    }

    public synchronized void setOutputPaused(boolean outputPaused) {
        if (outputPaused == this.myIsOutputPaused) {
            return;
        }
        if (this.myIsOutputPaused) {
            new OutputFlusher().doFlush();
        }
        this.myIsOutputPaused = outputPaused;
    }

    public String getNextOccurenceActionName() {
        return this.myTreeView.getNextOccurenceActionName();
    }

    public String getPreviousOccurenceActionName() {
        return this.myTreeView.getPreviousOccurenceActionName();
    }

    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        return this.isTreeView() ? this.myTreeView.goNextOccurence() : null;
    }

    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        return this.isTreeView() ? this.myTreeView.goPreviousOccurence() : null;
    }

    public boolean hasNextOccurence() {
        return this.isTreeView() && this.myTreeView.hasNextOccurence();
    }

    public boolean hasPreviousOccurence() {
        return this.isTreeView() && this.myTreeView.hasPreviousOccurence();
    }

    public void setBuildCommandLine(String commandLine) {
        this.myPlainTextView.setBuildCommandLine(commandLine);
    }

    private class OutputFlusher {
        private final ArrayList<AntMessage> myDelayedMessages = new ArrayList();

        private OutputFlusher() {
        }

        public void doFlush() {
            while (AntBuildMessageView.this.myCommandsProcessedCount < AntBuildMessageView.this.myLog.size()) {
                LogCommand command = (LogCommand)AntBuildMessageView.this.myLog.get(AntBuildMessageView.this.myCommandsProcessedCount);
                this.proceedOneCommand(command);
                AntBuildMessageView.this.myCommandsProcessedCount++;
            }
            this.flushDelayedMessages();
        }

        protected final void proceedOneCommand(LogCommand command) {
            if (command.getPriority() > AntBuildMessageView.this.myPriorityThreshold) {
                return;
            }
            if (command instanceof AddMessageCommand) {
                AddMessageCommand addMessageCommand = (AddMessageCommand)command;
                this.myDelayedMessages.add(addMessageCommand.myAntMessage);
            } else {
                this.flushDelayedMessages();
                command.execute(AntBuildMessageView.this.myTreeView);
                command.execute(AntBuildMessageView.this.myPlainTextView);
            }
        }

        protected final void flushDelayedMessages() {
            if (!this.myDelayedMessages.isEmpty()) {
                AntMessage[] messages = this.myDelayedMessages.toArray(new AntMessage[this.myDelayedMessages.size()]);
                this.myDelayedMessages.clear();
                AntBuildMessageView.this.myTreeView.addMessages(messages);
                AntBuildMessageView.this.myPlainTextView.addMessages(messages);
            }
        }
    }

    private static final class AddJavacMessageCommand
    extends LogCommand {
        private final String myUrl;
        private final AntMessage myAntMessage;

        AddJavacMessageCommand(AntMessage antMessage, String url) {
            super(antMessage.getPriority());
            this.myAntMessage = antMessage;
            this.myUrl = url;
        }

        @Override
        void execute(AntOutputView outputView) {
            outputView.addJavacMessage(this.myAntMessage, this.myUrl);
        }
    }

    private final class AddExceptionCommand
    extends LogCommand {
        private final AntMessage myAntMessage;

        AddExceptionCommand(AntMessage antMessage) {
            super(antMessage.getPriority());
            this.myAntMessage = antMessage;
        }

        @Override
        void execute(AntOutputView outputView) {
            outputView.addException(this.myAntMessage, AntBuildMessageView.this.isVerboseMode());
        }
    }

    private static final class AddMessageCommand
    extends LogCommand {
        final AntMessage myAntMessage;

        AddMessageCommand(AntMessage antMessage) {
            super(antMessage.getPriority());
            this.myAntMessage = antMessage;
        }

        @Override
        void execute(AntOutputView outputView) {
            outputView.addMessage(this.myAntMessage);
        }
    }

    private static final class FinishTaskCommand
    extends LogCommand {
        FinishTaskCommand() {
            super(0);
        }

        @Override
        public void execute(AntOutputView outputView) {
            outputView.finishTask();
        }
    }

    private static final class StartTaskCommand
    extends LogCommand {
        private final AntMessage myMessage;

        StartTaskCommand(String taskName) {
            super(0);
            this.myMessage = new AntMessage(MessageType.TASK, 0, taskName, null, 0, 0);
        }

        @Override
        void execute(AntOutputView outputView) {
            outputView.startTask(this.myMessage);
        }
    }

    private static final class FinishTargetCommand
    extends LogCommand {
        FinishTargetCommand() {
            super(0);
        }

        @Override
        void execute(AntOutputView outputView) {
            outputView.finishTarget();
        }
    }

    private static final class StartTargetCommand
    extends LogCommand {
        private final AntMessage myMessage;

        StartTargetCommand(String targetName) {
            super(0);
            this.myMessage = new AntMessage(MessageType.TARGET, 0, targetName, null, 0, 0);
        }

        @Override
        void execute(AntOutputView outputView) {
            outputView.startTarget(this.myMessage);
        }
    }

    private static final class FinishBuildCommand
    extends LogCommand {
        private final String myFinishStatusText;

        FinishBuildCommand(String finishStatusText) {
            super(0);
            this.myFinishStatusText = finishStatusText;
        }

        @Override
        void execute(AntOutputView outputView) {
            outputView.finishBuild(this.myFinishStatusText);
        }
    }

    private static final class BuildFailedCommand
    extends LogCommand {
        private final AntMessage myMessage;

        BuildFailedCommand(String buildName) {
            super(0);
            this.myMessage = new AntMessage(MessageType.ERROR, 0, AntBundle.message("cannot.start.build.name.error.message", buildName), null, 0, 0);
        }

        @Override
        void execute(AntOutputView outputView) {
            outputView.buildFailed(this.myMessage);
        }
    }

    private static final class StartBuildCommand
    extends LogCommand {
        private final AntMessage myMessage;

        StartBuildCommand(String buildName) {
            super(0);
            this.myMessage = new AntMessage(MessageType.BUILD, 0, buildName, null, 0, 0);
        }

        @Override
        void execute(AntOutputView outputView) {
            outputView.startBuild(this.myMessage);
        }
    }

    private static abstract class LogCommand {
        private final int myPriority;

        LogCommand(int priority) {
            this.myPriority = priority;
        }

        final int getPriority() {
            return this.myPriority;
        }

        abstract void execute(AntOutputView var1);
    }

    private static final class CloseListener
    extends ContentManagerAdapter
    implements ProjectManagerListener {
        private Content myContent;
        private boolean myCloseAllowed = false;
        private final ContentManager myContentManager;
        private final Project myProject;

        private CloseListener(Content content, ContentManager contentManager, Project project) {
            this.myContent = content;
            this.myContentManager = contentManager;
            this.myProject = project;
            contentManager.addContentManagerListener((ContentManagerListener)this);
            ProjectManager.getInstance().addProjectManagerListener(this.myProject, (ProjectManagerListener)this);
        }

        public void contentRemoved(ContentManagerEvent event) {
            if (event.getContent() == this.myContent) {
                AntBuildMessageView buildMessageView = (AntBuildMessageView)this.myContent.getUserData(KEY);
                if (!this.myCloseAllowed) {
                    buildMessageView.stopProcess();
                }
                this.myContentManager.removeContentManagerListener((ContentManagerListener)this);
                ProjectManager.getInstance().removeProjectManagerListener(this.myProject, (ProjectManagerListener)this);
                this.myContent.release();
                this.myContent = null;
                buildMessageView.myBuildFile = null;
                buildMessageView.myPlainTextView.dispose();
            }
        }

        public void contentRemoveQuery(ContentManagerEvent event) {
            boolean canClose;
            if (event.getContent() == this.myContent && !(canClose = this.closeQuery())) {
                event.consume();
            }
        }

        public void projectOpened(Project project) {
        }

        public void projectClosed(Project project) {
            if (this.myContent != null) {
                this.myContentManager.removeContent(this.myContent, true);
            }
        }

        public void projectClosing(Project project) {
        }

        public boolean canCloseProject(Project project) {
            return this.closeQuery();
        }

        private boolean closeQuery() {
            if (this.myContent == null) {
                return true;
            }
            AntBuildMessageView messageView = (AntBuildMessageView)this.myContent.getUserData(KEY);
            if (messageView.isStoppedOrTerminateRequested()) {
                return true;
            }
            if (this.myCloseAllowed) {
                return true;
            }
            int result = Messages.showYesNoCancelDialog((String)AntBundle.message("ant.process.is.active.terminate.confirmation.text", new Object[0]), (String)AntBundle.message("close.ant.build.messages.dialog.title", new Object[0]), (Icon)Messages.getQuestionIcon());
            if (result == 0) {
                messageView.stopProcess();
                this.myCloseAllowed = true;
                return true;
            }
            if (result == 1) {
                this.myCloseAllowed = true;
                return true;
            }
            return false;
        }
    }

    public final class CloseAction
    extends CloseTabToolbarAction {
        public void actionPerformed(AnActionEvent e) {
            AntBuildMessageView.this.close();
        }
    }

    public static enum MessageType {
        BUILD,
        TARGET,
        TASK,
        MESSAGE,
        ERROR;

    }
}

