/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentListener;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.util.containers.HashMap;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.ui.ExecutionPointHighlighter;
import com.intellij.xdebugger.impl.ui.XDebugSessionData;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="XDebuggerManager", storages={@Storage(id="other", file="$WORKSPACE_FILE$")})
public class XDebuggerManagerImpl
extends XDebuggerManager
implements ProjectComponent,
PersistentStateComponent<XDebuggerState> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.xdebugger.impl.XDebuggerManagerImpl");
    @NonNls
    public static final String COMPONENT_NAME = "XDebuggerManager";
    private final Project myProject;
    private final XBreakpointManagerImpl myBreakpointManager;
    private final Map<ProcessHandler, XDebugSessionData> mySessionData;
    private final Map<ProcessHandler, XDebugSessionTab> mySessionTabs;
    private final List<XDebugSessionImpl> mySessions;
    private final ExecutionPointHighlighter myExecutionPointHighlighter;
    private XDebugSessionImpl myLastActiveSession;

    public XDebuggerManagerImpl(Project project, StartupManager startupManager, MessageBus messageBus) {
        this.myProject = project;
        this.myBreakpointManager = new XBreakpointManagerImpl(project, this, startupManager);
        this.mySessionData = new LinkedHashMap<ProcessHandler, XDebugSessionData>();
        this.mySessions = new ArrayList<XDebugSessionImpl>();
        this.myExecutionPointHighlighter = new ExecutionPointHighlighter(project);
        this.mySessionTabs = new HashMap();
        messageBus.connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerAdapter(){

            public void fileOpened(FileEditorManager source, VirtualFile file) {
                if (file instanceof HttpVirtualFile && file.equals(XDebuggerManagerImpl.this.myExecutionPointHighlighter.getCurrentFile())) {
                    XDebuggerManagerImpl.this.myExecutionPointHighlighter.update();
                }
            }
        });
    }

    @NotNull
    public XBreakpointManagerImpl getBreakpointManager() {
        XBreakpointManagerImpl xBreakpointManagerImpl = this.myBreakpointManager;
        if (xBreakpointManagerImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xdebugger/impl/XDebuggerManagerImpl.getBreakpointManager must not return null");
        }
        return xBreakpointManagerImpl;
    }

    public void projectOpened() {
        final RunContentManager contentManager = ExecutionManager.getInstance((Project)this.myProject).getContentManager();
        LOG.assertTrue(contentManager != null, (Object)"Content manager is null");
        final RunContentListener myContentListener = new RunContentListener(){

            public void contentSelected(RunContentDescriptor descriptor) {
            }

            public void contentRemoved(RunContentDescriptor descriptor) {
                XDebugSessionTab sessionTab = (XDebugSessionTab)XDebuggerManagerImpl.this.mySessionTabs.remove(descriptor.getProcessHandler());
                if (sessionTab != null) {
                    Disposer.dispose((Disposable)sessionTab);
                }
            }
        };
        contentManager.addRunContentListener(myContentListener, DefaultDebugExecutor.getDebugExecutorInstance());
        Disposer.register((Disposable)this.myProject, (Disposable)new Disposable(){

            public void dispose() {
                contentManager.removeRunContentListener(myContentListener);
            }
        });
    }

    public void projectClosed() {
    }

    public Project getProject() {
        return this.myProject;
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if (COMPONENT_NAME == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xdebugger/impl/XDebuggerManagerImpl.getComponentName must not return null");
        }
        return COMPONENT_NAME;
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    @NotNull
    public XDebugSession startSession(@NotNull ProgramRunner runner, @NotNull ExecutionEnvironment env, @Nullable RunContentDescriptor contentToReuse, @NotNull XDebugProcessStarter processStarter) {
        if (runner == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/XDebuggerManagerImpl.startSession must not be null");
        }
        if (env == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xdebugger/impl/XDebuggerManagerImpl.startSession must not be null");
        }
        if (processStarter == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/xdebugger/impl/XDebuggerManagerImpl.startSession must not be null");
        }
        XDebugSession xDebugSession = this.startSession(contentToReuse, processStarter, new XDebugSessionImpl(env, runner, this));
        if (xDebugSession == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xdebugger/impl/XDebuggerManagerImpl.startSession must not return null");
        }
        return xDebugSession;
    }

    @NotNull
    public XDebugSession startSessionAndShowTab(@NotNull String sessionName, @Nullable RunContentDescriptor contentToReuse, @NotNull XDebugProcessStarter starter) {
        if (sessionName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/XDebuggerManagerImpl.startSessionAndShowTab must not be null");
        }
        if (starter == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/xdebugger/impl/XDebuggerManagerImpl.startSessionAndShowTab must not be null");
        }
        XDebugSession session = this.startSession(contentToReuse, starter, new XDebugSessionImpl(null, null, this, sessionName));
        RunContentDescriptor descriptor = session.getRunContentDescriptor();
        ExecutionManager.getInstance((Project)this.myProject).getContentManager().showRunContent(DefaultDebugExecutor.getDebugExecutorInstance(), descriptor);
        ProcessHandler handler = descriptor.getProcessHandler();
        if (handler != null) {
            handler.startNotify();
        }
        XDebugSession xDebugSession = session;
        if (xDebugSession == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xdebugger/impl/XDebuggerManagerImpl.startSessionAndShowTab must not return null");
        }
        return xDebugSession;
    }

    private XDebugSession startSession(RunContentDescriptor contentToReuse, XDebugProcessStarter processStarter, XDebugSessionImpl session) {
        XDebugSessionData oldSessionData;
        XDebugProcess process = processStarter.start((XDebugSession)session);
        XDebugSessionData xDebugSessionData = oldSessionData = contentToReuse != null ? this.mySessionData.remove(contentToReuse.getProcessHandler()) : null;
        if (oldSessionData == null) {
            oldSessionData = new XDebugSessionData();
        }
        XDebugSessionTab sessionTab = session.init(process, oldSessionData);
        this.mySessions.add(session);
        this.mySessionTabs.put(session.getDebugProcess().getProcessHandler(), sessionTab);
        return session;
    }

    public void removeSession(@NotNull XDebugSessionImpl session) {
        if (session == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/XDebuggerManagerImpl.removeSession must not be null");
        }
        XDebugSessionTab sessionTab = session.getSessionTab();
        XDebugSessionData data = sessionTab.saveData();
        this.mySessions.remove(session);
        this.mySessionData.put(session.getDebugProcess().getProcessHandler(), data);
        if (this.myLastActiveSession == session) {
            this.myLastActiveSession = null;
            this.onActiveSessionChanged();
        }
    }

    public void updateExecutionPosition(@NotNull XDebugSessionImpl session, @Nullable XSourcePosition position, boolean useSelection) {
        if (session == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/XDebuggerManagerImpl.updateExecutionPosition must not be null");
        }
        boolean sessionChanged = this.myLastActiveSession != session;
        this.myLastActiveSession = session;
        if (position != null) {
            this.myExecutionPointHighlighter.show(position, useSelection);
        } else {
            this.myExecutionPointHighlighter.hide();
        }
        if (sessionChanged) {
            this.onActiveSessionChanged();
        }
    }

    private void onActiveSessionChanged() {
        this.myBreakpointManager.getLineBreakpointManager().queueAllBreakpointsUpdate();
    }

    @NotNull
    public XDebugSession[] getDebugSessions() {
        XDebugSession[] xDebugSessionArray = this.mySessions.toArray(new XDebugSession[this.mySessions.size()]);
        if (xDebugSessionArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xdebugger/impl/XDebuggerManagerImpl.getDebugSessions must not return null");
        }
        return xDebugSessionArray;
    }

    @NotNull
    public <T extends XDebugProcess> Collection<? extends T> getDebugProcesses(Class<T> processClass) {
        ArrayList<T> list = new ArrayList<T>();
        for (XDebugSessionImpl session : this.mySessions) {
            XDebugProcess process = session.getDebugProcess();
            if (!processClass.isInstance(process)) continue;
            list.add(processClass.cast(process));
        }
        ArrayList<T> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xdebugger/impl/XDebuggerManagerImpl.getDebugProcesses must not return null");
        }
        return arrayList;
    }

    @Nullable
    public XDebugSessionImpl getCurrentSession() {
        if (this.myLastActiveSession != null) {
            return this.myLastActiveSession;
        }
        return !this.mySessions.isEmpty() ? this.mySessions.get(0) : null;
    }

    public XDebuggerState getState() {
        return new XDebuggerState(this.myBreakpointManager.getState());
    }

    public void loadState(XDebuggerState state) {
        this.myBreakpointManager.loadState(state.myBreakpointManagerState);
    }

    public void showExecutionPosition() {
        this.myExecutionPointHighlighter.navigateTo();
    }

    public static class XDebuggerState {
        private XBreakpointManagerImpl.BreakpointManagerState myBreakpointManagerState;

        public XDebuggerState() {
        }

        public XDebuggerState(XBreakpointManagerImpl.BreakpointManagerState breakpointManagerState) {
            this.myBreakpointManagerState = breakpointManagerState;
        }

        @Property(surroundWithTag=false)
        public XBreakpointManagerImpl.BreakpointManagerState getBreakpointManagerState() {
            return this.myBreakpointManagerState;
        }

        public void setBreakpointManagerState(XBreakpointManagerImpl.BreakpointManagerState breakpointManagerState) {
            this.myBreakpointManagerState = breakpointManagerState;
        }
    }
}

