/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.codeInsight.completion.scope.JavaCompletionProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataCache;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceSet;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.CanonicalPsiTypeConverter;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CanonicalPsiTypeConverterImpl
extends CanonicalPsiTypeConverter
implements CustomReferenceConverter<PsiType> {
    private static final UserDataCache<JavaClassReferenceProvider, Project, Object> REFERENCE_PROVIDER = new UserDataCache<JavaClassReferenceProvider, Project, Object>("CanonicalPsiTypeConverterImpl"){

        protected JavaClassReferenceProvider compute(Project project, Object p) {
            return new JavaClassReferenceProvider(project);
        }
    };
    @NonNls
    private static final String[] PRIMITIVES = new String[]{"boolean", "byte", "char", "double", "float", "int", "long", "short"};
    @NonNls
    private static final String ARRAY_PREFIX = "[L";

    public PsiType fromString(String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        try {
            return JavaPsiFacade.getInstance((Project)context.getFile().getProject()).getElementFactory().createTypeFromText(s.replace('$', '.'), null);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    public String toString(PsiType t, ConvertContext context) {
        return t == null ? null : t.getCanonicalText();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiReference[] createReferences(final GenericDomValue<PsiType> genericDomValue, final PsiElement element, ConvertContext context) {
        PsiReference[] psiReferenceArray;
        String str = genericDomValue.getStringValue();
        if (str != null) {
            ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)element);
            assert (manipulator != null);
            String trimmed = str.trim();
            int offset = manipulator.getRangeInElement(element).getStartOffset() + str.indexOf(trimmed);
            if (trimmed.startsWith(ARRAY_PREFIX)) {
                offset += ARRAY_PREFIX.length();
                trimmed = trimmed.endsWith(";") ? trimmed.substring(ARRAY_PREFIX.length(), trimmed.length() - 1) : trimmed.substring(ARRAY_PREFIX.length());
            }
            if ((psiReferenceArray = new JavaClassReferenceSet(trimmed, element, offset, false, (JavaClassReferenceProvider)REFERENCE_PROVIDER.get((UserDataHolder)genericDomValue.getManager().getProject(), null)){

                @Override
                protected JavaClassReference createReference(int referenceIndex, String subreferenceText, TextRange textRange, boolean staticImport) {
                    return new JavaClassReference(this, textRange, referenceIndex, subreferenceText, staticImport){

                        @Override
                        public boolean isSoft() {
                            return true;
                        }

                        /*
                         * Enabled aggressive block sorting
                         */
                        @Override
                        @NotNull
                        public JavaResolveResult advancedResolve(boolean incompleteCode) {
                            JavaResolveResult javaResolveResult;
                            PsiType type = (PsiType)genericDomValue.getValue();
                            if (type != null) {
                                type = type.getDeepComponentType();
                            }
                            if (type instanceof PsiPrimitiveType) {
                                javaResolveResult = new CandidateInfo(element, PsiSubstitutor.EMPTY, false, false, element);
                                if (javaResolveResult == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/CanonicalPsiTypeConverterImpl$2$1.advancedResolve must not return null");
                                return javaResolveResult;
                            }
                            javaResolveResult = super.advancedResolve(incompleteCode);
                            if (javaResolveResult != null) return javaResolveResult;
                            throw new IllegalStateException("@NotNull method com/intellij/util/xml/CanonicalPsiTypeConverterImpl$2$1.advancedResolve must not return null");
                        }

                        @Override
                        public void processVariants(PsiScopeProcessor processor) {
                            if (processor instanceof JavaCompletionProcessor) {
                                ((JavaCompletionProcessor)processor).setCompletionElements(this.getVariants());
                            } else {
                                super.processVariants(processor);
                            }
                        }

                        /*
                         * Enabled aggressive block sorting
                         */
                        @Override
                        @NotNull
                        public Object[] getVariants() {
                            Object[] objectArray;
                            Object[] variants = super.getVariants();
                            if (this.myIndex == 0) {
                                objectArray = ArrayUtil.mergeArrays((Object[])variants, (Object[])PRIMITIVES, Object.class);
                                if (objectArray == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/CanonicalPsiTypeConverterImpl$2$1.getVariants must not return null");
                                return objectArray;
                            }
                            objectArray = variants;
                            if (variants != null) return objectArray;
                            throw new IllegalStateException("@NotNull method com/intellij/util/xml/CanonicalPsiTypeConverterImpl$2$1.getVariants must not return null");
                        }
                    };
                }
            }.getAllReferences()) == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/CanonicalPsiTypeConverterImpl.createReferences must not return null");
            return psiReferenceArray;
        }
        psiReferenceArray = PsiReference.EMPTY_ARRAY;
        if (PsiReference.EMPTY_ARRAY != null) return psiReferenceArray;
        throw new IllegalStateException("@NotNull method com/intellij/util/xml/CanonicalPsiTypeConverterImpl.createReferences must not return null");
    }
}

