/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.scopeChooser.EditScopesDialog;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.StripeTable;
import com.intellij.ui.tabs.FileColorConfiguration;
import com.intellij.ui.tabs.FileColorConfigurationEditDialog;
import com.intellij.ui.tabs.FileColorManagerImpl;
import com.intellij.ui.tabs.FileColorSettingsTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;

public class FileColorsConfigurablePanel
extends JPanel
implements Disposable {
    private FileColorManagerImpl myManager;
    private JCheckBox myEnabledCheckBox;
    private JCheckBox myTabsEnabledCheckBox;
    private FileColorSettingsTable myLocalTable;
    private FileColorSettingsTable mySharedTable;

    public FileColorsConfigurablePanel(final @NotNull FileColorManagerImpl manager) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/tabs/FileColorsConfigurablePanel.<init> must not be null");
        }
        this.setLayout(new BorderLayout());
        this.myManager = manager;
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 0));
        this.myEnabledCheckBox = new JCheckBox("Enable File Colors");
        this.myEnabledCheckBox.setMnemonic('F');
        topPanel.add(this.myEnabledCheckBox);
        this.myTabsEnabledCheckBox = new JCheckBox("Use colors in Editor Tabs");
        this.myTabsEnabledCheckBox.setMnemonic('T');
        topPanel.add(this.myTabsEnabledCheckBox);
        topPanel.add(Box.createHorizontalGlue());
        this.add((Component)topPanel, "North");
        JPanel mainPanel = new JPanel(new GridLayout(2, 1));
        mainPanel.setPreferredSize(new Dimension(300, 500));
        mainPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.myLocalTable = new FileColorSettingsTable(manager, manager.getLocalConfigurations()){

            @Override
            protected void apply(@NotNull List<FileColorConfiguration> configurations) {
                if (configurations == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/tabs/FileColorsConfigurablePanel$1.apply must not be null");
                }
                ArrayList<FileColorConfiguration> copied = new ArrayList<FileColorConfiguration>();
                for (FileColorConfiguration configuration : configurations) {
                    try {
                        copied.add(configuration.clone());
                    }
                    catch (CloneNotSupportedException e) {
                        assert (false) : "Should not happen!";
                    }
                }
                manager.getModel().setConfigurations(copied, false);
            }
        };
        JPanel localPanel = new JPanel(new BorderLayout());
        localPanel.setBorder(BorderFactory.createTitledBorder("Local colors:"));
        localPanel.add((Component)StripeTable.createScrollPane((JTable)((Object)this.myLocalTable)), "Center");
        localPanel.add(Box.createVerticalStrut(10), "South");
        localPanel.add(FileColorsConfigurablePanel.buildButtons(manager, this.myLocalTable, "Share", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileColorsConfigurablePanel.this.share();
            }
        }), "East");
        mainPanel.add(localPanel);
        this.mySharedTable = new FileColorSettingsTable(manager, manager.getSharedConfigurations()){

            @Override
            protected void apply(@NotNull List<FileColorConfiguration> configurations) {
                if (configurations == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/tabs/FileColorsConfigurablePanel$3.apply must not be null");
                }
                ArrayList<FileColorConfiguration> copied = new ArrayList<FileColorConfiguration>();
                for (FileColorConfiguration configuration : configurations) {
                    try {
                        copied.add(configuration.clone());
                    }
                    catch (CloneNotSupportedException e) {
                        assert (false) : "Should not happen!";
                    }
                }
                manager.getModel().setConfigurations(copied, true);
            }
        };
        JPanel sharedPanel = new JPanel(new BorderLayout());
        sharedPanel.setBorder(BorderFactory.createTitledBorder("Shared colors:"));
        sharedPanel.add((Component)StripeTable.createScrollPane((JTable)((Object)this.mySharedTable)), "Center");
        sharedPanel.add(FileColorsConfigurablePanel.buildButtons(manager, this.mySharedTable, "Unshare", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileColorsConfigurablePanel.this.unshare();
            }
        }), "East");
        mainPanel.add(sharedPanel);
        this.add((Component)mainPanel, "Center");
        JPanel warningPanel = new JPanel(new BorderLayout());
        warningPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        warningPanel.add(new JLabel("Scopes are processed from top to bottom with Local colors first.", MessageType.WARNING.getDefaultIcon(), 2));
        JButton editScopes = new JButton("Manage Scopes...");
        editScopes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditScopesDialog.editConfigurable(FileColorsConfigurablePanel.this.myManager.getProject(), null, true);
            }
        });
        warningPanel.add((Component)editScopes, "East");
        this.add((Component)warningPanel, "South");
    }

    private static JButton createAddButton(final FileColorSettingsTable table, final FileColorManagerImpl manager) {
        JButton addButton = new JButton("Add...");
        addButton.setMaximumSize(new Dimension(Integer.MAX_VALUE, addButton.getMaximumSize().height));
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileColorConfigurationEditDialog dialog = new FileColorConfigurationEditDialog(manager, null);
                dialog.show();
                if (dialog.getExitCode() == 0) {
                    table.addConfiguration(dialog.getConfiguration());
                }
            }
        });
        return addButton;
    }

    private void unshare() {
        int rowCount = this.mySharedTable.getSelectedRowCount();
        if (rowCount > 0) {
            int[] rows = this.mySharedTable.getSelectedRows();
            for (int i = rows.length - 1; i >= 0; --i) {
                FileColorConfiguration removed = this.mySharedTable.removeConfiguration(rows[i]);
                if (removed == null) continue;
                this.myLocalTable.addConfiguration(removed);
            }
        }
    }

    private void share() {
        int rowCount = this.myLocalTable.getSelectedRowCount();
        if (rowCount > 0) {
            int[] rows = this.myLocalTable.getSelectedRows();
            for (int i = rows.length - 1; i >= 0; --i) {
                FileColorConfiguration removed = this.myLocalTable.removeConfiguration(rows[i]);
                if (removed == null) continue;
                this.mySharedTable.addConfiguration(removed);
            }
        }
    }

    private static Component buildButtons(FileColorManagerImpl manager, final FileColorSettingsTable table, String shareButtonText, ActionListener shareButtonListener) {
        JPanel result = new JPanel();
        result.setLayout(new BoxLayout(result, 1));
        result.add(FileColorsConfigurablePanel.createAddButton(table, manager));
        JButton removeButton = new JButton("Remove");
        result.add(removeButton);
        removeButton.setMaximumSize(new Dimension(Integer.MAX_VALUE, removeButton.getMaximumSize().height));
        removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                table.performRemove();
            }
        });
        JButton shareButton = new JButton(shareButtonText);
        result.add(shareButton);
        shareButton.setMaximumSize(new Dimension(Integer.MAX_VALUE, shareButton.getMaximumSize().height));
        shareButton.addActionListener(shareButtonListener);
        JButton upButton = new JButton("Move up");
        result.add(upButton);
        upButton.setMaximumSize(new Dimension(Integer.MAX_VALUE, upButton.getMaximumSize().height));
        upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                table.moveUp();
            }
        });
        JButton downButton = new JButton("Move down");
        result.add(downButton);
        downButton.setMaximumSize(new Dimension(Integer.MAX_VALUE, downButton.getMaximumSize().height));
        downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                table.moveDown();
            }
        });
        return result;
    }

    public void dispose() {
        this.myManager = null;
    }

    public boolean isModified() {
        boolean modified = this.myEnabledCheckBox.isSelected() != this.myManager.isEnabled();
        modified |= this.myTabsEnabledCheckBox.isSelected() != this.myManager.isEnabledForTabs();
        return modified |= this.myLocalTable.isModified() || this.mySharedTable.isModified();
    }

    public void apply() {
        this.myManager.setEnabled(this.myEnabledCheckBox.isSelected());
        this.myManager.setEnabledForTabs(this.myTabsEnabledCheckBox.isSelected());
        this.myLocalTable.apply();
        this.mySharedTable.apply();
        UISettings.getInstance().fireUISettingsChanged();
    }

    public void reset() {
        this.myEnabledCheckBox.setSelected(this.myManager.isEnabled());
        this.myTabsEnabledCheckBox.setSelected(this.myManager.isEnabledForTabs());
        if (this.myLocalTable.isModified()) {
            this.myLocalTable.reset();
        }
        if (this.mySharedTable.isModified()) {
            this.mySharedTable.reset();
        }
    }
}

