/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.ui.EditorComboBoxRenderer;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ArrayUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class EditorComboBox
extends JComboBox
implements DocumentListener {
    public static TextComponentAccessor<EditorComboBox> COMPONENT_ACCESSOR = new TextComponentAccessor<EditorComboBox>(){

        public String getText(EditorComboBox component) {
            return component.getText();
        }

        public void setText(EditorComboBox component, String text) {
            component.setText(text);
        }
    };
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.EditorTextField");
    private Document myDocument;
    private Project myProject;
    private EditorTextField myEditorField = null;
    private final ArrayList<DocumentListener> myDocumentListeners = new ArrayList();
    private boolean myIsListenerInstalled = false;
    private boolean myInheritSwingFont = true;
    private final FileType myFileType;
    private final boolean myIsViewer;

    public EditorComboBox(String text) {
        this(EditorFactory.getInstance().createDocument((CharSequence)text), null, (FileType)FileTypes.PLAIN_TEXT);
    }

    public EditorComboBox(String text, Project project, FileType fileType) {
        this(EditorFactory.getInstance().createDocument((CharSequence)text), project, fileType, false);
    }

    public EditorComboBox(Document document, Project project, FileType fileType) {
        this(document, project, fileType, false);
    }

    public EditorComboBox(Document document, Project project, FileType fileType, boolean isViewer) {
        this.myFileType = fileType;
        this.myIsViewer = isViewer;
        this.setDocument(document);
        this.myProject = project;
        this.enableEvents(8L);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Editor editor = EditorComboBox.this.myEditorField.getEditor();
                if (editor != null) {
                    editor.getSelectionModel().removeSelection();
                }
            }
        });
        this.setHistory(new String[]{""});
        this.setEditable(true);
    }

    public void setFontInheritedFromLAF(boolean b) {
        this.myInheritSwingFont = b;
        this.setDocument(this.myDocument);
    }

    public String getText() {
        return this.myDocument.getText();
    }

    public void addDocumentListener(DocumentListener listener) {
        this.myDocumentListeners.add(listener);
        this.installDocumentListener();
    }

    public void removeDocumentListener(DocumentListener listener) {
        this.myDocumentListeners.remove(listener);
        this.uninstallDocumentListener(false);
    }

    public void beforeDocumentChange(DocumentEvent event) {
        for (DocumentListener documentListener : this.myDocumentListeners) {
            documentListener.beforeDocumentChange(event);
        }
    }

    public void documentChanged(DocumentEvent event) {
        for (DocumentListener documentListener : this.myDocumentListeners) {
            documentListener.documentChanged(event);
        }
    }

    public Project getProject() {
        return this.myProject;
    }

    public Document getDocument() {
        return this.myDocument;
    }

    public void setDocument(Document document) {
        if (this.myDocument != null) {
            this.uninstallDocumentListener(true);
        }
        this.myDocument = document;
        this.installDocumentListener();
        if (this.myEditorField == null) {
            return;
        }
        this.myEditorField.setDocument(document);
    }

    private void installDocumentListener() {
        if (this.myDocument != null && this.myDocumentListeners.size() > 0 && !this.myIsListenerInstalled) {
            this.myIsListenerInstalled = true;
            this.myDocument.addDocumentListener((DocumentListener)this);
        }
    }

    private void uninstallDocumentListener(boolean force) {
        if (this.myDocument != null && this.myIsListenerInstalled && (force || this.myDocumentListeners.size() == 0)) {
            this.myIsListenerInstalled = false;
            this.myDocument.removeDocumentListener((DocumentListener)this);
        }
    }

    public void setText(final String text) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                CommandProcessor.getInstance().executeCommand(EditorComboBox.this.getProject(), new Runnable(){

                    @Override
                    public void run() {
                        EditorComboBox.this.myDocument.replaceString(0, EditorComboBox.this.myDocument.getTextLength(), (CharSequence)text);
                        if (EditorComboBox.this.myEditorField != null && EditorComboBox.this.myEditorField.getEditor() != null) {
                            EditorComboBox.this.myEditorField.getCaretModel().moveToOffset(EditorComboBox.this.myDocument.getTextLength());
                        }
                    }
                }, null, (Object)EditorComboBox.this.myDocument);
            }
        });
    }

    public void removeSelection() {
        Editor editor;
        if (this.myEditorField != null && (editor = this.myEditorField.getEditor()) != null) {
            editor.getSelectionModel().removeSelection();
        }
    }

    public CaretModel getCaretModel() {
        return this.myEditorField.getCaretModel();
    }

    public void setHistory(String[] history) {
        this.setModel(new DefaultComboBoxModel<String>(history));
    }

    public void prependItem(String item) {
        ArrayList<String> objects = new ArrayList<String>();
        objects.add(item);
        int count = this.getItemCount();
        for (int i = 0; i < count; ++i) {
            Object itemAt = this.getItemAt(i);
            if (item.equals(itemAt)) continue;
            objects.add((String)itemAt);
        }
        this.setModel(new DefaultComboBoxModel<Object>(ArrayUtil.toObjectArray(objects)));
    }

    @Override
    public void addNotify() {
        this.releaseEditor();
        this.setEditor();
        super.addNotify();
    }

    private void setEditor() {
        this.myEditorField = new EditorTextField(this.myDocument, this.myProject, this.myFileType, this.myIsViewer){

            @Override
            protected boolean shouldHaveBorder() {
                return UIManager.getBorder("ComboBox.border") == null;
            }
        };
        MyEditor editor = new MyEditor();
        this.setEditor(editor);
        this.setRenderer(new EditorComboBoxRenderer((ComboBoxEditor)editor));
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.myEditorField != null) {
            this.releaseEditor();
            this.myEditorField = null;
        }
    }

    private void releaseEditor() {
        Editor editor;
        if (this.myEditorField != null && (editor = this.myEditorField.getEditor()) != null) {
            this.myEditorField.releaseEditor(editor);
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.myEditorField != null && this.myEditorField.getEditor() != null) {
            this.setupEditorFont((EditorEx)this.myEditorField.getEditor());
        }
    }

    private void setupEditorFont(EditorEx editor) {
        if (this.myInheritSwingFont) {
            editor.getColorsScheme().setEditorFontName(this.getFont().getFontName());
            editor.getColorsScheme().setEditorFontSize(this.getFont().getSize());
        }
    }

    protected boolean shouldHaveBorder() {
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.myEditorField == null) {
            return;
        }
        this.myEditorField.setEnabled(enabled);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.myEditorField != null) {
            Dimension preferredSize = new Dimension(this.myEditorField.getComponent().getPreferredSize());
            Insets insets = this.getInsets();
            if (insets != null) {
                preferredSize.width += insets.left;
                preferredSize.width += insets.right;
                preferredSize.height += insets.top;
                preferredSize.height += insets.bottom;
            }
            return preferredSize;
        }
        return new Dimension(100, 20);
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (!((EditorEx)this.myEditorField.getEditor()).processKeyTyped(e)) {
            return super.processKeyBinding(ks, e, condition, pressed);
        }
        return true;
    }

    public EditorEx getEditorEx() {
        return this.myEditorField != null ? (EditorEx)this.myEditorField.getEditor() : null;
    }

    private class MyEditor
    implements ComboBoxEditor {
        private MyEditor() {
        }

        @Override
        public void addActionListener(ActionListener l) {
        }

        @Override
        public Component getEditorComponent() {
            return EditorComboBox.this.myEditorField;
        }

        @Override
        public Object getItem() {
            return EditorComboBox.this.myDocument.getText();
        }

        @Override
        public void removeActionListener(ActionListener l) {
        }

        @Override
        public void selectAll() {
            Editor editor;
            if (EditorComboBox.this.myEditorField != null && (editor = EditorComboBox.this.myEditorField.getEditor()) != null) {
                editor.getSelectionModel().setSelection(0, EditorComboBox.this.myDocument.getTextLength());
            }
        }

        @Override
        public void setItem(Object anObject) {
            if (anObject != null) {
                EditorComboBox.this.setText((String)anObject);
            } else {
                EditorComboBox.this.setText("");
            }
        }
    }
}

