/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.wrapreturnvalue.usageInfo;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.refactoring.psi.MutationUtils;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.util.IncorrectOperationException;

public class WrapReturnValue
extends FixableUsageInfo {
    private final PsiReturnStatement statement;
    private final String type;

    public WrapReturnValue(PsiReturnStatement statement, String type) {
        super((PsiElement)statement);
        this.type = type;
        this.statement = statement;
    }

    @Override
    public void fixUsage() throws IncorrectOperationException {
        PsiExpression returnValue = this.statement.getReturnValue();
        assert (returnValue != null);
        String newExpression = "new " + this.type + '(' + returnValue.getText() + ')';
        MutationUtils.replaceExpression(newExpression, returnValue);
    }
}

