/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesImpl;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesToNewDirectoryDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.Arrays;

public abstract class MoveClassesOrPackagesHandlerBase
extends MoveHandlerDelegate {
    protected static boolean isPackageOrDirectory(PsiElement element) {
        if (element instanceof PsiPackage) {
            return true;
        }
        return element instanceof PsiDirectory && JavaDirectoryService.getInstance().getPackage((PsiDirectory)element) != null;
    }

    @Override
    public PsiElement[] adjustForMove(Project project, PsiElement[] sourceElements, PsiElement targetElement) {
        return MoveClassesOrPackagesImpl.adjustForMove(project, sourceElements, targetElement);
    }

    @Override
    public void doMove(Project project, PsiElement[] elements, PsiElement targetContainer, MoveCallback callback) {
        if (MoveClassesOrPackagesHandlerBase.tryDirectoryMove(project, elements, targetContainer, callback)) {
            return;
        }
        MoveClassesOrPackagesImpl.doMove(project, elements, targetContainer, callback);
    }

    private static boolean tryDirectoryMove(Project project, PsiElement[] sourceElements, PsiElement targetElement, MoveCallback callback) {
        if (targetElement instanceof PsiDirectory) {
            PsiElement[] adjustedElements = MoveClassesOrPackagesImpl.adjustForMove(project, sourceElements, targetElement);
            if (adjustedElements != null && CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)project, Arrays.asList(adjustedElements), (boolean)true)) {
                new MoveClassesOrPackagesToNewDirectoryDialog((PsiDirectory)targetElement, adjustedElements, callback).show();
            }
            return true;
        }
        return false;
    }
}

