/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class PsiForeachStatementImpl
extends CompositePsiElement
implements PsiForeachStatement,
Constants {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.java.PsiForeachStatementImpl");

    public PsiForeachStatementImpl() {
        super(FOREACH_STATEMENT);
    }

    @NotNull
    public PsiParameter getIterationParameter() {
        PsiParameter psiParameter = (PsiParameter)this.findChildByRoleAsPsiElement(125);
        if (psiParameter == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiForeachStatementImpl.getIterationParameter must not return null");
        }
        return psiParameter;
    }

    public PsiExpression getIteratedValue() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(124);
    }

    public PsiStatement getBody() {
        return (PsiStatement)this.findChildByRoleAsPsiElement(38);
    }

    @NotNull
    public PsiJavaToken getLParenth() {
        PsiJavaToken psiJavaToken = (PsiJavaToken)this.findChildByRoleAsPsiElement(24);
        if (psiJavaToken == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/tree/java/PsiForeachStatementImpl.getLParenth must not return null");
        }
        return psiJavaToken;
    }

    public PsiJavaToken getRParenth() {
        return (PsiJavaToken)this.findChildByRoleAsPsiElement(25);
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            case 38: {
                return this.findChildByType(STATEMENT_BIT_SET);
            }
            case 124: {
                return this.findChildByType(EXPRESSION_BIT_SET);
            }
            case 37: {
                return this.getFirstChildNode();
            }
            case 24: {
                return this.findChildByType(LPARENTH);
            }
            case 25: {
                return this.findChildByType(RPARENTH);
            }
            case 125: {
                return this.findChildByType(PARAMETER);
            }
            case 87: {
                return this.findChildByType(COLON);
            }
        }
        return null;
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == FOR_KEYWORD) {
            return 37;
        }
        if (i == LPARENTH) {
            return 24;
        }
        if (i == RPARENTH) {
            return 25;
        }
        if (i == PARAMETER) {
            return 125;
        }
        if (i == COLON) {
            return 87;
        }
        if (EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 124;
        }
        if (STATEMENT_BIT_SET.contains(child.getElementType())) {
            return 38;
        }
        return 0;
    }

    @Override
    public String toString() {
        return "PsiForeachStatement";
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiForeachStatementImpl.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiForeachStatementImpl.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiForeachStatementImpl.processDeclarations must not be null");
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        if (lastParent == null || lastParent.getParent() != this) {
            return true;
        }
        PsiParameter iterationParameter = this.getIterationParameter();
        if (iterationParameter != null) {
            return processor.execute((PsiElement)iterationParameter, state);
        }
        return PsiScopesUtil.walkChildrenScopes(this, processor, state, lastParent, place);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/tree/java/PsiForeachStatementImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitForeachStatement((PsiForeachStatement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }
}

