/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Queryable;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReceiver;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiMethodStub;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.jsp.jspJava.JspClass;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSharedImplUtil;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.presentation.java.JavaPresentationUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.RowIcon;
import com.intellij.util.Icons;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PatchedSoftReference;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PsiMethodImpl
extends JavaStubPsiElement<PsiMethodStub>
implements PsiMethod,
Queryable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.PsiMethodImpl");
    private PatchedSoftReference<PsiType> myCachedType = null;

    public PsiMethodImpl(PsiMethodStub stub) {
        this(stub, (IStubElementType)JavaStubElementTypes.METHOD);
    }

    protected PsiMethodImpl(PsiMethodStub stub, IStubElementType type) {
        super(stub, type);
    }

    public PsiMethodImpl(ASTNode node) {
        super(node);
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.dropCached();
    }

    protected void dropCached() {
        this.myCachedType = null;
    }

    @Override
    protected Object clone() {
        PsiMethodImpl clone = (PsiMethodImpl)((Object)super.clone());
        clone.dropCached();
        return clone;
    }

    public PsiClass getContainingClass() {
        PsiElement parent = this.getParent();
        return parent instanceof PsiClass ? (PsiClass)parent : (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)this, JspClass.class);
    }

    @Override
    public PsiElement getContext() {
        PsiClass cc = this.getContainingClass();
        return cc != null ? cc : super.getContext();
    }

    public PsiIdentifier getNameIdentifier() {
        return (PsiIdentifier)this.getNode().findChildByRoleAsPsiElement(9);
    }

    @NotNull
    public PsiMethod[] findSuperMethods() {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods(this);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiMethodImpl.findSuperMethods must not return null");
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiMethod[] findSuperMethods(boolean checkAccess) {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this, checkAccess);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiMethodImpl.findSuperMethods must not return null");
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiMethod[] findSuperMethods(PsiClass parentClass) {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this, parentClass);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiMethodImpl.findSuperMethods must not return null");
        }
        return psiMethodArray;
    }

    @NotNull
    public List<MethodSignatureBackedByPsiMethod> findSuperMethodSignaturesIncludingStatic(boolean checkAccess) {
        List<MethodSignatureBackedByPsiMethod> list = PsiSuperMethodImplUtil.findSuperMethodSignaturesIncludingStatic(this, checkAccess);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiMethodImpl.findSuperMethodSignaturesIncludingStatic must not return null");
        }
        return list;
    }

    public PsiMethod findDeepestSuperMethod() {
        return PsiSuperMethodImplUtil.findDeepestSuperMethod(this);
    }

    @NotNull
    public PsiMethod[] findDeepestSuperMethods() {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findDeepestSuperMethods(this);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiMethodImpl.findDeepestSuperMethods must not return null");
        }
        return psiMethodArray;
    }

    @Override
    @NotNull
    public String getName() {
        PsiIdentifier nameIdentifier;
        PsiMethodStub stub = (PsiMethodStub)this.getStub();
        String name = stub != null ? stub.getName() : ((nameIdentifier = this.getNameIdentifier()) == null ? null : nameIdentifier.getText());
        String string = name != null ? name : "<unnamed>";
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiMethodImpl.getName must not return null");
        }
        return string;
    }

    @NotNull
    public HierarchicalMethodSignature getHierarchicalMethodSignature() {
        HierarchicalMethodSignature hierarchicalMethodSignature = PsiSuperMethodImplUtil.getHierarchicalMethodSignature(this);
        if (hierarchicalMethodSignature == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiMethodImpl.getHierarchicalMethodSignature must not return null");
        }
        return hierarchicalMethodSignature;
    }

    public PsiMethodReceiver getMethodReceiver() {
        ASTNode node = this.getNode().findChildByType(JavaElementType.METHOD_RECEIVER);
        if (node == null) {
            return null;
        }
        return (PsiMethodReceiver)node.getPsi();
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiMethodImpl.setName must not be null");
        }
        PsiImplUtil.setName((PsiElement)this.getNameIdentifier(), name);
        return this;
    }

    public PsiTypeElement getReturnTypeElement() {
        if (this.isConstructor()) {
            return null;
        }
        return (PsiTypeElement)this.getNode().findChildByRoleAsPsiElement(10);
    }

    public PsiTypeParameterList getTypeParameterList() {
        return this.getRequiredStubOrPsiChild(JavaStubElementTypes.TYPE_PARAMETER_LIST);
    }

    public boolean hasTypeParameters() {
        return PsiImplUtil.hasTypeParameters((PsiTypeParameterListOwner)this);
    }

    @NotNull
    public PsiTypeParameter[] getTypeParameters() {
        PsiTypeParameter[] psiTypeParameterArray = PsiImplUtil.getTypeParameters((PsiTypeParameterListOwner)this);
        if (psiTypeParameterArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiMethodImpl.getTypeParameters must not return null");
        }
        return psiTypeParameterArray;
    }

    public PsiType getReturnTypeNoResolve() {
        if (this.isConstructor()) {
            return null;
        }
        PsiMethodStub stub = (PsiMethodStub)this.getStub();
        if (stub != null) {
            String typeText = TypeInfo.createTypeText(stub.getReturnTypeText(false));
            if (typeText == null) {
                return null;
            }
            try {
                return JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createTypeFromText(typeText, (PsiElement)this);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
                return null;
            }
        }
        PsiTypeElement typeElement = this.getReturnTypeElement();
        if (typeElement == null) {
            return null;
        }
        PsiParameterList parameterList = this.getParameterList();
        return JavaSharedImplUtil.getTypeNoResolve(typeElement, (PsiElement)parameterList, (PsiElement)this);
    }

    public PsiType getReturnType() {
        if (this.isConstructor()) {
            return null;
        }
        PsiMethodStub stub = (PsiMethodStub)this.getStub();
        if (stub != null) {
            PsiType type;
            String typeText = TypeInfo.createTypeText(stub.getReturnTypeText(true));
            if (typeText == null) {
                return null;
            }
            PatchedSoftReference<PsiType> cachedType = this.myCachedType;
            if (cachedType != null && (type = (PsiType)cachedType.get()) != null) {
                return type;
            }
            try {
                type = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createTypeFromText(typeText, (PsiElement)this);
                this.myCachedType = new PatchedSoftReference<PsiType>(type);
                return type;
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
                return null;
            }
        }
        this.myCachedType = null;
        PsiTypeElement typeElement = this.getReturnTypeElement();
        if (typeElement == null) {
            return null;
        }
        PsiParameterList parameterList = this.getParameterList();
        return JavaSharedImplUtil.getType(typeElement, (PsiElement)parameterList, (PsiElement)this);
    }

    @NotNull
    public PsiModifierList getModifierList() {
        PsiModifierList psiModifierList = this.getRequiredStubOrPsiChild(JavaStubElementTypes.MODIFIER_LIST);
        if (psiModifierList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiMethodImpl.getModifierList must not return null");
        }
        return psiModifierList;
    }

    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiMethodImpl.hasModifierProperty must not be null");
        }
        return this.getModifierList().hasModifierProperty(name);
    }

    @NotNull
    public PsiParameterList getParameterList() {
        PsiParameterList psiParameterList = this.getRequiredStubOrPsiChild(JavaStubElementTypes.PARAMETER_LIST);
        if (psiParameterList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiMethodImpl.getParameterList must not return null");
        }
        return psiParameterList;
    }

    @NotNull
    public PsiReferenceList getThrowsList() {
        PsiReferenceList psiReferenceList = this.getRequiredStubOrPsiChild(JavaStubElementTypes.THROWS_LIST);
        if (psiReferenceList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiMethodImpl.getThrowsList must not return null");
        }
        return psiReferenceList;
    }

    public PsiCodeBlock getBody() {
        return (PsiCodeBlock)this.getNode().findChildByRoleAsPsiElement(17);
    }

    @Override
    @NotNull
    public CompositeElement getNode() {
        CompositeElement compositeElement = (CompositeElement)super.getNode();
        if (compositeElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiMethodImpl.getNode must not return null");
        }
        return compositeElement;
    }

    public boolean isDeprecated() {
        PsiMethodStub stub = (PsiMethodStub)this.getStub();
        if (stub != null) {
            return stub.isDeprecated() || stub.hasDeprecatedAnnotation() && PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)this);
        }
        return PsiImplUtil.isDeprecatedByDocTag((PsiDocCommentOwner)this) || PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)this);
    }

    public PsiDocComment getDocComment() {
        return (PsiDocComment)this.getNode().findChildByRoleAsPsiElement(7);
    }

    public boolean isConstructor() {
        PsiMethodStub stub = (PsiMethodStub)this.getStub();
        if (stub != null) {
            return stub.isConstructor();
        }
        return this.getNode().findChildByRole(10) == null;
    }

    public boolean isVarArgs() {
        PsiMethodStub stub = (PsiMethodStub)this.getStub();
        if (stub != null) {
            return stub.isVarArgs();
        }
        PsiParameter[] parameters = this.getParameterList().getParameters();
        return parameters.length > 0 && parameters[parameters.length - 1].isVarArgs();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiMethodImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitMethod((PsiMethod)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiMethod:" + this.getName();
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiMethodImpl.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/PsiMethodImpl.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/source/PsiMethodImpl.processDeclarations must not be null");
        }
        return PsiImplUtil.processDeclarationsInMethod(this, processor, state, lastParent, place);
    }

    @NotNull
    public MethodSignature getSignature(@NotNull PsiSubstitutor substitutor) {
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/PsiMethodImpl.getSignature must not be null");
        }
        MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod = MethodSignatureBackedByPsiMethod.create((PsiMethod)this, (PsiSubstitutor)substitutor);
        if (methodSignatureBackedByPsiMethod == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiMethodImpl.getSignature must not return null");
        }
        return methodSignatureBackedByPsiMethod;
    }

    @Override
    public PsiElement getOriginalElement() {
        PsiClass originalClass = (PsiClass)this.getContainingClass().getOriginalElement();
        PsiMethod originalMethod = originalClass.findMethodBySignature((PsiMethod)this, false);
        return originalMethod != null ? originalMethod : this;
    }

    @Override
    public ItemPresentation getPresentation() {
        return JavaPresentationUtil.getMethodPresentation(this);
    }

    public Icon getElementIcon(int flags) {
        Icon methodIcon = this.hasModifierProperty("abstract") ? Icons.ABSTRACT_METHOD_ICON : Icons.METHOD_ICON;
        RowIcon baseIcon = PsiMethodImpl.createLayeredIcon((Icon)methodIcon, (int)ElementPresentationUtil.getFlags((PsiModifierListOwner)this, false));
        return ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)this, flags, baseIcon);
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isMethodEquivalentTo(this, another);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = PsiImplUtil.getMemberUseScope((PsiMember)this);
        if (searchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/PsiMethodImpl.getUseScope must not return null");
        }
        return searchScope;
    }

    public void putInfo(Map<String, String> info) {
        info.put("methodName", this.getName());
    }
}

