/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.openapi.editor.Document;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfoFactory;
import org.jetbrains.annotations.Nullable;

public class ImportListElementInfoFactory
implements SmartPointerElementInfoFactory {
    @Override
    @Nullable
    public SmartPointerElementInfo createElementInfo(PsiElement element) {
        if (element instanceof PsiImportList) {
            return new ImportListInfo((PsiJavaFile)element.getContainingFile());
        }
        return null;
    }

    private static class ImportListInfo
    implements SmartPointerElementInfo {
        private final PsiJavaFile myFile;

        public ImportListInfo(PsiJavaFile file) {
            this.myFile = file;
        }

        @Override
        public PsiElement restoreElement() {
            if (!this.myFile.isValid()) {
                return null;
            }
            return this.myFile.getImportList();
        }

        @Override
        public Document getDocumentToSynchronize() {
            return null;
        }

        @Override
        public void documentAndPsiInSync() {
        }
    }
}

