/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.search.ConstructorReferencesSearchHelper;
import com.intellij.psi.impl.search.CustomPropertyScopeProvider;
import com.intellij.psi.impl.search.MethodTextOccurenceProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import org.jetbrains.annotations.NotNull;

public class MethodUsagesSearcher
implements QueryExecutor<PsiReference, MethodReferencesSearch.SearchParameters> {
    public boolean execute(MethodReferencesSearch.SearchParameters p, final Processor<PsiReference> consumer) {
        PsiMethod[] psiMethodArray;
        ConstructorReferencesSearchHelper helper;
        final PsiMethod method = p.getMethod();
        final SearchScope searchScope = p.getScope();
        final PsiManager psiManager = PsiManager.getInstance((Project)method.getProject());
        final boolean isStrictSignatureSearch = p.isStrictSignatureSearch();
        final PsiClass aClass = (PsiClass)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass>(){

            public PsiClass compute() {
                return method.getContainingClass();
            }
        });
        if (aClass == null) {
            return true;
        }
        if (method.isConstructor() && !(helper = new ConstructorReferencesSearchHelper(psiManager)).processConstructorReferences(consumer, method, searchScope, !isStrictSignatureSearch, isStrictSignatureSearch)) {
            return false;
        }
        boolean needStrictSignatureSearch = (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return method.isValid() && isStrictSignatureSearch && (aClass instanceof PsiAnonymousClass || aClass.hasModifierProperty("final") || method.hasModifierProperty("static") || method.hasModifierProperty("final") || method.hasModifierProperty("private"));
            }
        });
        if (needStrictSignatureSearch) {
            return ReferencesSearch.search((PsiElement)method, (SearchScope)searchScope, (boolean)false).forEach((Processor)new ReadActionProcessor<PsiReference>(){

                public boolean processInReadAction(PsiReference psiReference) {
                    return consumer.process((Object)psiReference);
                }
            });
        }
        String textToSearch = method.getName();
        if (isStrictSignatureSearch) {
            PsiMethod[] psiMethodArray2 = new PsiMethod[1];
            psiMethodArray = psiMethodArray2;
            psiMethodArray2[0] = method;
        } else {
            psiMethodArray = MethodUsagesSearcher.getOverloads(method);
        }
        final PsiMethod[] methods = psiMethodArray;
        SearchScope accessScope = (SearchScope)ApplicationManager.getApplication().runReadAction((Computable)new Computable<SearchScope>(){

            public SearchScope compute() {
                if (!method.isValid()) {
                    return searchScope;
                }
                SearchScope accessScope = methods[0].getUseScope();
                for (int i = 1; i < methods.length; ++i) {
                    PsiMethod method1 = methods[i];
                    accessScope = accessScope.union(method1.getUseScope());
                }
                return accessScope;
            }
        });
        MethodTextOccurenceProcessor processor1 = new MethodTextOccurenceProcessor(consumer, aClass, isStrictSignatureSearch, methods);
        final SearchScope restrictedByAccess = searchScope.intersectWith(accessScope);
        short searchContext = 11;
        PsiSearchHelper helper2 = psiManager.getSearchHelper();
        if (!helper2.processElementsWithWord((TextOccurenceProcessor)processor1, restrictedByAccess, textToSearch, searchContext, true)) {
            return false;
        }
        String propertyName = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                if (!method.isValid()) {
                    return null;
                }
                return PropertyUtil.getPropertyName((PsiMethod)method);
            }
        });
        if (StringUtil.isEmpty((String)propertyName)) {
            return true;
        }
        SearchScope scope = (SearchScope)ApplicationManager.getApplication().runReadAction((Computable)new Computable<SearchScope>(){

            public SearchScope compute() {
                GlobalSearchScope additional = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)GlobalSearchScope.allScope((Project)psiManager.getProject()), (FileType[])new FileType[]{StdFileTypes.JSP, StdFileTypes.JSPX, StdFileTypes.XML, StdFileTypes.XHTML});
                for (CustomPropertyScopeProvider provider : (CustomPropertyScopeProvider[])Extensions.getExtensions(CustomPropertyScopeProvider.EP_NAME)) {
                    SearchScope s = provider.getScope(psiManager.getProject());
                    additional = additional.union(s);
                }
                return restrictedByAccess.intersectWith((SearchScope)additional);
            }
        });
        return helper2.processElementsWithWord((TextOccurenceProcessor)processor1, scope, propertyName, (short)8, true);
    }

    @NotNull
    private static PsiMethod[] getOverloads(final PsiMethod method) {
        PsiMethod[] psiMethodArray = (PsiMethod[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiMethod[]>(){

            public PsiMethod[] compute() {
                if (!method.isValid()) {
                    return PsiMethod.EMPTY_ARRAY;
                }
                PsiClass aClass = method.getContainingClass();
                if (aClass == null) {
                    return new PsiMethod[]{method};
                }
                return aClass.findMethodsByName(method.getName(), false);
            }
        });
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/search/MethodUsagesSearcher.getOverloads must not return null");
        }
        return psiMethodArray;
    }
}

