/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.Arrays;
import java.util.Comparator;

public class AllClassesSearchExecutor
implements QueryExecutor<PsiClass, AllClassesSearch.SearchParameters> {
    public boolean execute(AllClassesSearch.SearchParameters queryParameters, Processor<PsiClass> consumer) {
        PsiElement[] scopeRoots;
        SearchScope scope = queryParameters.getScope();
        if (scope instanceof GlobalSearchScope) {
            return AllClassesSearchExecutor.processAllClassesInGlobalScope((GlobalSearchScope)scope, consumer, queryParameters);
        }
        for (PsiElement scopeRoot : scopeRoots = ((LocalSearchScope)scope).getScope()) {
            if (AllClassesSearchExecutor.processScopeRootForAllClasses(scopeRoot, consumer)) continue;
            return false;
        }
        return true;
    }

    private static boolean processAllClassesInGlobalScope(final GlobalSearchScope scope, Processor<PsiClass> processor, AllClassesSearch.SearchParameters parameters) {
        PsiManager manager = PsiManager.getInstance((Project)parameters.getProject());
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
        final PsiShortNamesCache cache = facade.getShortNamesCache();
        String[] names = (String[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<String[]>(){

            public String[] compute() {
                return cache.getAllClassNames();
            }
        });
        Arrays.sort(names, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        });
        for (final String name : names) {
            PsiClass[] classes;
            if (!parameters.nameMatches(name)) continue;
            ProgressManager.checkCanceled();
            for (PsiClass psiClass : classes = (PsiClass[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass[]>(){

                public PsiClass[] compute() {
                    return cache.getClassesByName(name, scope);
                }
            })) {
                ProgressManager.checkCanceled();
                if (processor.process((Object)psiClass)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processScopeRootForAllClasses(PsiElement scopeRoot, final Processor<PsiClass> processor) {
        if (scopeRoot == null) {
            return true;
        }
        final boolean[] stopped = new boolean[]{false};
        scopeRoot.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                if (!stopped[0]) {
                    super.visitElement(element);
                }
            }

            public void visitClass(PsiClass aClass) {
                stopped[0] = !processor.process((Object)aClass);
                super.visitClass(aClass);
            }
        });
        return !stopped[0];
    }
}

