/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.peer.impl;

import com.intellij.ide.ui.SplitterProportionsDataImpl;
import com.intellij.ide.util.PackageChooserDialog;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diff.DiffRequestFactory;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileChooser.FileSystemTreeFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.module.ModuleConfigurationEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.roots.ui.configuration.JavaContentEntriesEditor;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.ui.DialogWrapperPeerFactory;
import com.intellij.openapi.ui.PackageChooser;
import com.intellij.openapi.ui.SplitterProportionsData;
import com.intellij.openapi.vcs.FileStatusFactory;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.peer.PeerFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.scope.packageSet.PackageSetFactory;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.HighlightableCellRenderer;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.SelectionSaver;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SmartExpander;
import com.intellij.ui.TableToolTipHandler;
import com.intellij.ui.TextComponent;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.TreeTableSpeedSearch;
import com.intellij.ui.TreeToolTipHandler;
import com.intellij.ui.UIHelper;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.errorView.ErrorViewFactory;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.Function;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.Table;
import com.intellij.util.ui.UIUtil;
import java.awt.Graphics;
import java.net.InetAddress;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.apache.xmlrpc.IdeaAwareWebServer;
import org.apache.xmlrpc.IdeaAwareXmlRpcServer;
import org.apache.xmlrpc.WebServer;
import org.apache.xmlrpc.XmlRpcServer;

public class PeerFactoryImpl
extends PeerFactory {
    private final UIHelper myUIHelper = new MyUIHelper();

    public FileStatusFactory getFileStatusFactory() {
        return (FileStatusFactory)ServiceManager.getService(FileStatusFactory.class);
    }

    public DialogWrapperPeerFactory getDialogWrapperPeerFactory() {
        return DialogWrapperPeerFactory.getInstance();
    }

    public PackageSetFactory getPackageSetFactory() {
        return PackageSetFactory.getInstance();
    }

    public UIHelper getUIHelper() {
        return this.myUIHelper;
    }

    public ErrorViewFactory getErrorViewFactory() {
        return ErrorViewFactory.SERVICE.getInstance();
    }

    public ContentFactory getContentFactory() {
        return (ContentFactory)ServiceManager.getService(ContentFactory.class);
    }

    public FileSystemTreeFactory getFileSystemTreeFactory() {
        return FileSystemTreeFactory.SERVICE.getInstance();
    }

    public DiffRequestFactory getDiffRequestFactory() {
        return DiffRequestFactory.getInstance();
    }

    public VcsContextFactory getVcsContextFactory() {
        return VcsContextFactory.SERVICE.getInstance();
    }

    public PsiBuilder createBuilder(ASTNode tree, Language lang, CharSequence seq, Project project) {
        return PsiBuilderFactory.getInstance().createBuilder(project, tree, lang, seq);
    }

    public PsiBuilder createBuilder(ASTNode tree, Lexer lexer, Language lang, CharSequence seq, Project project) {
        return PsiBuilderFactory.getInstance().createBuilder(project, tree, lexer, lang, seq);
    }

    public XmlRpcServer createRpcServer() {
        return new IdeaAwareXmlRpcServer();
    }

    public WebServer createWebServer(int port, InetAddress addr, XmlRpcServer xmlrpc) {
        return new IdeaAwareWebServer(port, addr, xmlrpc);
    }

    public EditorHighlighter createEditorHighlighter(SyntaxHighlighter syntaxHighlighter, EditorColorsScheme colors) {
        return EditorHighlighterFactory.getInstance().createEditorHighlighter(syntaxHighlighter, colors);
    }

    public Sdk createProjectJdk(String name, String version, String homePath, SdkType sdkType) {
        ProjectJdkImpl projectJdk = new ProjectJdkImpl(name, sdkType);
        projectJdk.setHomePath(homePath);
        projectJdk.setVersionString(version);
        return projectJdk;
    }

    public ModuleConfigurationEditor createModuleConfigurationEditor(String moduleName, ModuleConfigurationState state) {
        return new JavaContentEntriesEditor(moduleName, state);
    }

    private static class MyUIHelper
    implements UIHelper {
        private MyUIHelper() {
        }

        public void installToolTipHandler(JTree tree) {
            TreeToolTipHandler.install(tree);
        }

        public void installToolTipHandler(JTable table) {
            TableToolTipHandler.install(table);
        }

        public void installEditSourceOnDoubleClick(JTree tree) {
            EditSourceOnDoubleClickHandler.install((JTree)tree);
        }

        public void installEditSourceOnDoubleClick(TreeTable tree) {
            EditSourceOnDoubleClickHandler.install((TreeTable)tree);
        }

        public void installEditSourceOnDoubleClick(Table table) {
            EditSourceOnDoubleClickHandler.install((Table)table);
        }

        public void installTreeTableSpeedSearch(TreeTable treeTable) {
            new TreeTableSpeedSearch(treeTable);
        }

        public void installTreeTableSpeedSearch(TreeTable treeTable, Convertor<TreePath, String> convertor) {
            new TreeTableSpeedSearch(treeTable, convertor);
        }

        public void installTreeSpeedSearch(JTree tree) {
            new TreeSpeedSearch(tree);
        }

        public void installTreeSpeedSearch(JTree tree, Convertor<TreePath, String> convertor) {
            new TreeSpeedSearch(tree, convertor);
        }

        public void installListSpeedSearch(JList list) {
            new ListSpeedSearch(list);
        }

        public void installListSpeedSearch(JList list, Function<Object, String> elementTextDelegate) {
            new ListSpeedSearch(list, elementTextDelegate);
        }

        public void installEditSourceOnEnterKeyHandler(JTree tree) {
            EditSourceOnEnterKeyHandler.install((JTree)tree);
        }

        public SplitterProportionsData createSplitterProportionsData() {
            return new SplitterProportionsDataImpl();
        }

        public TableCellRenderer createPsiElementRenderer(final PsiElement psiElement, Project project) {
            return new ColoredTableCellRenderer(){

                protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                    this.append(MyUIHelper.getPsiElementText(psiElement), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    this.setIcon(psiElement.getIcon(0));
                }
            };
        }

        public TreeCellRenderer createHighlightableTreeCellRenderer() {
            return new HighlightableCellRenderer();
        }

        public void drawDottedRectangle(Graphics g, int x, int y, int i, int i1) {
            UIUtil.drawDottedRectangle((Graphics)g, (int)x, (int)y, (int)i, (int)i1);
        }

        public void installSmartExpander(JTree tree) {
            SmartExpander.installOn((JTree)tree);
        }

        public void installSelectionSaver(JTree tree) {
            SelectionSaver.installOn(tree);
        }

        public TextComponent createTypedTextField(String text, PsiType type, PsiElement context, Project project) {
            PsiExpressionCodeFragment fragment = JavaPsiFacade.getInstance((Project)project).getElementFactory().createExpressionCodeFragment(text, context, type, true);
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)fragment);
            return new EditorTextField(document, project, (FileType)StdFileTypes.JAVA);
        }

        public PackageChooser createPackageChooser(String title, Project project) {
            return new PackageChooserDialog(title, project);
        }

        private static String getPsiElementText(PsiElement psiElement) {
            if (psiElement instanceof PsiClass) {
                return PsiFormatUtil.formatClass((PsiClass)((PsiClass)psiElement), (int)2049);
            }
            if (psiElement instanceof PsiMethod) {
                return PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)psiElement), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)4353, (int)0);
            }
            if (psiElement instanceof PsiField) {
                return PsiFormatUtil.formatVariable((PsiVariable)((PsiField)psiElement), (int)4099, (PsiSubstitutor)PsiSubstitutor.EMPTY);
            }
            return psiElement.toString();
        }
    }
}

