/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.IconLoader;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.CompositePackagingElementType;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.elements.DirectoryPackagingElement;
import com.intellij.packaging.impl.elements.FilePathValidator;
import com.intellij.packaging.impl.elements.PackagingElementFactoryImpl;
import com.intellij.packaging.impl.ui.properties.DirectoryElementPropertiesPanel;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPropertiesPanel;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

class DirectoryElementType
extends CompositePackagingElementType<DirectoryPackagingElement> {
    private static final Icon ICON = IconLoader.getIcon((String)"/actions/newFolder.png");

    DirectoryElementType() {
        super("directory", CompilerBundle.message((String)"element.type.name.directory", (Object[])new Object[0]));
    }

    public Icon getCreateElementIcon() {
        return ICON;
    }

    @NotNull
    public DirectoryPackagingElement createEmpty(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/DirectoryElementType.createEmpty must not be null");
        }
        DirectoryPackagingElement directoryPackagingElement = new DirectoryPackagingElement();
        if (directoryPackagingElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/packaging/impl/elements/DirectoryElementType.createEmpty must not return null");
        }
        return directoryPackagingElement;
    }

    public PackagingElementPropertiesPanel createElementPropertiesPanel(@NotNull DirectoryPackagingElement element, @NotNull ArtifactEditorContext context) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/packaging/impl/elements/DirectoryElementType.createElementPropertiesPanel must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/packaging/impl/elements/DirectoryElementType.createElementPropertiesPanel must not be null");
        }
        if (ArtifactUtil.isArchiveName(element.getDirectoryName())) {
            return new DirectoryElementPropertiesPanel(element, context);
        }
        return null;
    }

    public CompositePackagingElement<?> createComposite(CompositePackagingElement<?> parent, String baseName, @NotNull ArtifactEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/packaging/impl/elements/DirectoryElementType.createComposite must not be null");
        }
        String initialValue = PackagingElementFactoryImpl.suggestFileName(parent, baseName != null ? baseName : "folder", "");
        String path = Messages.showInputDialog((Project)context.getProject(), (String)"Enter directory name: ", (String)"New Directory", null, (String)initialValue, (InputValidator)new FilePathValidator());
        if (path == null) {
            return null;
        }
        return PackagingElementFactoryImpl.createDirectoryOrArchiveWithParents(path, false);
    }
}

