/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.history.Label;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.PanelWithActionsAndCloseButton;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesBrowserUseCase;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesTreeBrowser;
import com.intellij.openapi.vcs.changes.committed.RefreshIncomingChangesAction;
import com.intellij.openapi.vcs.update.AbstractTreeNode;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vcs.update.FileTreeNode;
import com.intellij.openapi.vcs.update.ShowUpdatedDiffAction;
import com.intellij.openapi.vcs.update.UpdateRootNode;
import com.intellij.openapi.vcs.update.UpdateTreeCellRenderer;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SelectionSaver;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SmartExpander;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.Icons;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdateInfoTree
extends PanelWithActionsAndCloseButton
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.update.UpdateInfoTree");
    private VirtualFile mySelectedFile;
    private String mySelectedUrl;
    private final Tree myTree;
    @NotNull
    private final Project myProject;
    private final UpdatedFiles myUpdatedFiles;
    private UpdateRootNode myRoot;
    private DefaultTreeModel myTreeModel;
    private FileStatusListener myFileStatusListener;
    private final FileStatusManager myFileStatusManager;
    private final String myRootName;
    private final ActionInfo myActionInfo;
    private boolean myCanGroupByChangeList;
    private boolean myGroupByChangeList;
    private JLabel myLoadingChangeListsLabel;
    private List<CommittedChangeList> myCommittedChangeLists;
    private final JPanel myCenterPanel;
    @NonNls
    private static final String CARD_STATUS = "Status";
    @NonNls
    private static final String CARD_CHANGES = "Changes";
    private CommittedChangesTreeBrowser myTreeBrowser;
    private final TreeExpander myTreeExpander;
    private final MyTreeIterable myTreeIterable;
    private Label myBefore;
    private Label myAfter;

    public UpdateInfoTree(@NotNull ContentManager contentManager, @NotNull Project project, UpdatedFiles updatedFiles, String rootName, ActionInfo actionInfo) {
        if (contentManager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/update/UpdateInfoTree.<init> must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vcs/update/UpdateInfoTree.<init> must not be null");
        }
        super(contentManager, "reference.toolWindows.versionControl");
        this.myTree = new Tree();
        this.myCanGroupByChangeList = false;
        this.myGroupByChangeList = false;
        this.myCenterPanel = new JPanel(new CardLayout());
        this.myActionInfo = actionInfo;
        this.myFileStatusListener = new FileStatusListener(){

            public void fileStatusesChanged() {
                UpdateInfoTree.this.myTree.repaint();
            }

            public void fileStatusChanged(@NotNull VirtualFile virtualFile) {
                if (virtualFile == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/update/UpdateInfoTree$1.fileStatusChanged must not be null");
                }
                UpdateInfoTree.this.myTree.repaint();
            }
        };
        this.myProject = project;
        this.myUpdatedFiles = updatedFiles;
        this.myRootName = rootName;
        this.myFileStatusManager = FileStatusManager.getInstance((Project)this.myProject);
        this.myFileStatusManager.addFileStatusListener(this.myFileStatusListener);
        this.createTree();
        this.init();
        this.myTreeExpander = new DefaultTreeExpander((JTree)this.myTree);
        this.myTreeIterable = new MyTreeIterable();
    }

    public void dispose() {
        super.dispose();
        Disposer.dispose((Disposable)this.myRoot);
        if (this.myFileStatusListener != null) {
            this.myFileStatusManager.removeFileStatusListener(this.myFileStatusListener);
            this.myFileStatusListener = null;
        }
    }

    public void setCanGroupByChangeList(boolean canGroupByChangeList) {
        this.myCanGroupByChangeList = canGroupByChangeList;
        if (this.myCanGroupByChangeList) {
            this.myLoadingChangeListsLabel = new JLabel(VcsBundle.message((String)"update.info.loading.changelists", (Object[])new Object[0]));
            this.add(this.myLoadingChangeListsLabel, "South");
            this.myGroupByChangeList = VcsConfiguration.getInstance((Project)this.myProject).UPDATE_GROUP_BY_CHANGELIST;
            if (this.myGroupByChangeList) {
                CardLayout cardLayout = (CardLayout)this.myCenterPanel.getLayout();
                cardLayout.show(this.myCenterPanel, CARD_CHANGES);
            }
        }
    }

    protected void addActionsTo(DefaultActionGroup group) {
        group.add((AnAction)new MyGroupByPackagesAction());
        group.add((AnAction)new GroupByChangeListAction());
        group.add(ActionManager.getInstance().getAction("ExpandAll"));
        group.add(ActionManager.getInstance().getAction("CollapseAll"));
        ShowUpdatedDiffAction diffAction = new ShowUpdatedDiffAction();
        diffAction.registerCustomShortcutSet(CommonShortcuts.getDiff(), (JComponent)((Object)this));
        group.add((AnAction)diffAction);
    }

    protected JComponent createCenterPanel() {
        this.myCenterPanel.add(CARD_STATUS, ScrollPaneFactory.createScrollPane((JComponent)this.myTree));
        this.myTreeBrowser = new CommittedChangesTreeBrowser(this.myProject, Collections.<CommittedChangeList>emptyList());
        this.myTreeBrowser.setHelpId(this.getHelpId());
        this.myCenterPanel.add(CARD_CHANGES, this.myTreeBrowser);
        return this.myCenterPanel;
    }

    private void createTree() {
        SmartExpander.installOn((JTree)this.myTree);
        SelectionSaver.installOn((JTree)this.myTree);
        this.refreshTree();
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                AbstractTreeNode treeNode = (AbstractTreeNode)e.getPath().getLastPathComponent();
                if (treeNode instanceof FileTreeNode) {
                    VirtualFilePointer pointer = ((FileTreeNode)treeNode).getFilePointer();
                    UpdateInfoTree.this.mySelectedUrl = pointer.getUrl();
                    UpdateInfoTree.this.mySelectedFile = pointer.getFile();
                } else {
                    UpdateInfoTree.this.mySelectedUrl = null;
                    UpdateInfoTree.this.mySelectedFile = null;
                }
            }
        });
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)new UpdateTreeCellRenderer()));
        TreeUIHelper.getInstance().installToolTipHandler((JTree)this.myTree);
        TreeUtil.installActions((JTree)this.myTree);
        new TreeSpeedSearch(this.myTree, new Convertor<TreePath, String>(){

            public String convert(TreePath path) {
                Object last = path.getLastPathComponent();
                if (last instanceof AbstractTreeNode) {
                    return ((AbstractTreeNode)last).getName();
                }
                return (String)TreeSpeedSearch.NODE_DESCRIPTOR_TOSTRING.convert((Object)path);
            }
        });
        this.myTree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                DefaultActionGroup group = (DefaultActionGroup)ActionManager.getInstance().getAction("UpdateActionGroup");
                if (group != null) {
                    ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("UpdatePopup", (ActionGroup)group);
                    popupMenu.getComponent().show(comp, x, y);
                }
            }
        });
        EditSourceOnDoubleClickHandler.install((JTree)this.myTree);
        EditSourceOnEnterKeyHandler.install((JTree)this.myTree);
        this.myTree.setSelectionRow(0);
    }

    private void refreshTree() {
        this.myRoot = new UpdateRootNode(this.myUpdatedFiles, this.myProject, this.myRootName, this.myActionInfo);
        this.myRoot.rebuild(VcsConfiguration.getInstance((Project)this.myProject).UPDATE_GROUP_BY_PACKAGES);
        this.myTreeModel = new DefaultTreeModel(this.myRoot);
        this.myRoot.setTreeModel(this.myTreeModel);
        this.myTree.setModel((TreeModel)this.myTreeModel);
        this.myRoot.setTree((JTree)this.myTree);
    }

    public Object getData(String dataId) {
        if (this.myTreeBrowser.isVisible()) {
            return null;
        }
        if (PlatformDataKeys.NAVIGATABLE.is(dataId)) {
            if (this.mySelectedFile == null || !this.mySelectedFile.isValid()) {
                return null;
            }
            return new OpenFileDescriptor(this.myProject, this.mySelectedFile);
        }
        if (PlatformDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
            return this.getVirtualFileArray();
        }
        if (VcsDataKeys.IO_FILE_ARRAY.is(dataId)) {
            return this.getFileArray();
        }
        if (PlatformDataKeys.TREE_EXPANDER.is(dataId)) {
            if (this.myGroupByChangeList) {
                return this.myTreeBrowser.getTreeExpander();
            }
            return this.myTreeExpander;
        }
        if (VcsDataKeys.UPDATE_VIEW_SELECTED_PATH.is(dataId)) {
            return this.mySelectedUrl;
        }
        if (VcsDataKeys.UPDATE_VIEW_FILES_ITERABLE.is(dataId)) {
            return this.myTreeIterable;
        }
        if (VcsDataKeys.LABEL_BEFORE.is(dataId)) {
            return this.myBefore;
        }
        if (VcsDataKeys.LABEL_AFTER.is(dataId)) {
            return this.myAfter;
        }
        return super.getData(dataId);
    }

    private VirtualFile[] getVirtualFileArray() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        TreePath[] selectionPaths = this.myTree.getSelectionPaths();
        if (selectionPaths != null) {
            for (TreePath selectionPath : selectionPaths) {
                AbstractTreeNode treeNode = (AbstractTreeNode)selectionPath.getLastPathComponent();
                result.addAll(treeNode.getVirtualFiles());
            }
        }
        return VfsUtil.toVirtualFileArray(result);
    }

    @Nullable
    private File[] getFileArray() {
        ArrayList<File> result = new ArrayList<File>();
        TreePath[] selectionPaths = this.myTree.getSelectionPaths();
        if (selectionPaths != null) {
            for (TreePath selectionPath : selectionPaths) {
                AbstractTreeNode treeNode = (AbstractTreeNode)selectionPath.getLastPathComponent();
                result.addAll(treeNode.getFiles());
            }
        }
        if (result.isEmpty()) {
            return null;
        }
        return result.toArray(new File[result.size()]);
    }

    public void expandRootChildren() {
        TreeNode root = (TreeNode)this.myTreeModel.getRoot();
        if (root.getChildCount() == 1) {
            this.myTree.expandPath(new TreePath(new Object[]{root, root.getChildAt(0)}));
        }
    }

    public void setChangeLists(final List<CommittedChangeList> receivedChanges) {
        final boolean hasEmptyCaches = CommittedChangesCache.getInstance(this.myProject).hasEmptyCaches();
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (UpdateInfoTree.this.myLoadingChangeListsLabel != null) {
                    UpdateInfoTree.this.remove(UpdateInfoTree.this.myLoadingChangeListsLabel);
                    UpdateInfoTree.this.myLoadingChangeListsLabel = null;
                }
                UpdateInfoTree.this.myCommittedChangeLists = receivedChanges;
                UpdateInfoTree.this.myTreeBrowser.setItems(UpdateInfoTree.this.myCommittedChangeLists, false, CommittedChangesBrowserUseCase.UPDATE);
                UpdateInfoTree.this.myTreeBrowser.clearEmptyText();
                if (hasEmptyCaches) {
                    UpdateInfoTree.this.myTreeBrowser.appendEmptyText("Click ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    UpdateInfoTree.this.myTreeBrowser.appendEmptyText("Refresh", SimpleTextAttributes.LINK_ATTRIBUTES, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            RefreshIncomingChangesAction.doRefresh(UpdateInfoTree.this.myProject);
                        }
                    });
                    UpdateInfoTree.this.myTreeBrowser.appendEmptyText(" to initialize repository changes cache", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            }
        }, this.myProject.getDisposed());
    }

    public void setBefore(Label before) {
        this.myBefore = before;
    }

    public void setAfter(Label after) {
        this.myAfter = after;
    }

    private class GroupByChangeListAction
    extends ToggleAction
    implements DumbAware {
        public GroupByChangeListAction() {
            super(VcsBundle.message((String)"update.info.group.by.changelist", (Object[])new Object[0]), null, IconLoader.getIcon((String)"/objectBrowser/browser.png"));
        }

        public boolean isSelected(AnActionEvent e) {
            return UpdateInfoTree.this.myGroupByChangeList;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            UpdateInfoTree.this.myGroupByChangeList = state;
            VcsConfiguration.getInstance((Project)((UpdateInfoTree)UpdateInfoTree.this).myProject).UPDATE_GROUP_BY_CHANGELIST = UpdateInfoTree.this.myGroupByChangeList;
            CardLayout cardLayout = (CardLayout)UpdateInfoTree.this.myCenterPanel.getLayout();
            if (!UpdateInfoTree.this.myGroupByChangeList) {
                cardLayout.show(UpdateInfoTree.this.myCenterPanel, UpdateInfoTree.CARD_STATUS);
            } else {
                cardLayout.show(UpdateInfoTree.this.myCenterPanel, UpdateInfoTree.CARD_CHANGES);
            }
        }

        public void update(AnActionEvent e) {
            super.update(e);
            e.getPresentation().setVisible(UpdateInfoTree.this.myCanGroupByChangeList);
        }
    }

    private class MyGroupByPackagesAction
    extends ToggleAction
    implements DumbAware {
        public MyGroupByPackagesAction() {
            super(VcsBundle.message((String)"action.name.group.by.packages", (Object[])new Object[0]), null, Icons.GROUP_BY_PACKAGES);
        }

        public boolean isSelected(AnActionEvent e) {
            return VcsConfiguration.getInstance((Project)((UpdateInfoTree)UpdateInfoTree.this).myProject).UPDATE_GROUP_BY_PACKAGES;
        }

        public void setSelected(AnActionEvent e, boolean state) {
            VcsConfiguration.getInstance((Project)((UpdateInfoTree)UpdateInfoTree.this).myProject).UPDATE_GROUP_BY_PACKAGES = state;
            UpdateInfoTree.this.myRoot.rebuild(VcsConfiguration.getInstance((Project)((UpdateInfoTree)UpdateInfoTree.this).myProject).UPDATE_GROUP_BY_PACKAGES);
        }

        public void update(AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabled(!UpdateInfoTree.this.myGroupByChangeList);
        }
    }

    private class MyTreeIterable
    implements Iterable<VirtualFilePointer> {
        private MyTreeIterable() {
        }

        @Override
        public Iterator<VirtualFilePointer> iterator() {
            return new MyTreeIterator();
        }
    }

    private class MyTreeIterator
    implements Iterator<VirtualFilePointer> {
        private final Enumeration myEnum;
        private VirtualFilePointer myNext;

        private MyTreeIterator() {
            this.myEnum = UpdateInfoTree.this.myRoot.depthFirstEnumeration();
            this.step();
        }

        @Override
        public boolean hasNext() {
            return this.myNext != null;
        }

        @Override
        public VirtualFilePointer next() {
            VirtualFilePointer result = this.myNext;
            this.step();
            return result;
        }

        private void step() {
            this.myNext = null;
            while (this.myEnum.hasMoreElements()) {
                Object o = this.myEnum.nextElement();
                if (!(o instanceof FileTreeNode)) continue;
                this.myNext = ((FileTreeNode)o).getFilePointer();
                break;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

