/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesAdapter;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.messages.MessageBus;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IncomingChangesIndicator
implements ProjectComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.committed.IncomingChangesIndicator");
    private final Project myProject;
    private final CommittedChangesCache myCache;
    private StatusBar myStatusBar;
    private IndicatorComponent myIndicatorComponent;

    public IncomingChangesIndicator(Project project, CommittedChangesCache cache, MessageBus bus) {
        this.myProject = project;
        this.myCache = cache;
        bus.connect().subscribe(CommittedChangesCache.COMMITTED_TOPIC, (Object)new CommittedChangesAdapter(){

            @Override
            public void incomingChangesUpdated(@Nullable List<CommittedChangeList> receivedChanges) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        IncomingChangesIndicator.this.refreshIndicator();
                    }
                });
            }
        });
    }

    public void projectOpened() {
        this.myStatusBar = WindowManager.getInstance().getStatusBar(this.myProject);
        this.myIndicatorComponent = new IndicatorComponent();
        this.myStatusBar.addCustomIndicationComponent((JComponent)((Object)this.myIndicatorComponent));
        Disposer.register((Disposable)this.myProject, (Disposable)new Disposable(){

            public void dispose() {
                IncomingChangesIndicator.this.myStatusBar.removeCustomIndicationComponent((JComponent)((Object)IncomingChangesIndicator.this.myIndicatorComponent));
            }
        });
    }

    public void projectClosed() {
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("IncomingChangesIndicator" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/changes/committed/IncomingChangesIndicator.getComponentName must not return null");
        }
        return "IncomingChangesIndicator";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    private void refreshIndicator() {
        List<CommittedChangeList> list = this.myCache.getCachedIncomingChanges();
        if (list == null || list.isEmpty()) {
            IncomingChangesIndicator.debug("Refreshing indicator: no changes");
            this.myIndicatorComponent.clear();
            this.myIndicatorComponent.setToolTipText("");
        } else {
            IncomingChangesIndicator.debug("Refreshing indicator: " + list.size() + " changes");
            this.myIndicatorComponent.showIcon();
            this.myIndicatorComponent.setToolTipText(VcsBundle.message((String)"incoming.changes.indicator.tooltip", (Object[])new Object[]{list.size()}));
        }
        this.myIndicatorComponent.repaint();
    }

    private static void debug(@NonNls String message) {
        LOG.debug(message);
    }

    private static class IndicatorComponent
    extends SimpleColoredComponent {
        private IndicatorComponent() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    DataContext dataContext;
                    Project project;
                    if (!e.isPopupTrigger() && (project = (Project)PlatformDataKeys.PROJECT.getData(dataContext = DataManager.getInstance().getDataContext((Component)((Object)IndicatorComponent.this)))) != null) {
                        ToolWindow changesView = ToolWindowManager.getInstance((Project)project).getToolWindow(ChangesViewContentManager.TOOLWINDOW_ID);
                        changesView.show(new Runnable(){

                            @Override
                            public void run() {
                                ChangesViewContentManager.getInstance(project).selectContent("Incoming");
                            }
                        });
                    }
                }
            });
        }

        private void showIcon() {
            this.setIcon(IconLoader.getIcon((String)"/actions/get.png"));
        }

        public Dimension getPreferredSize() {
            return new Dimension(18, 18);
        }
    }
}

