/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.ChangeListsIndexes;
import com.intellij.openapi.vcs.changes.PlusMinus;
import com.intellij.openapi.vcs.impl.CollectionsDelta;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class ChangesDelta {
    private final PlusMinus<Pair<String, AbstractVcs>> myDeltaListener;
    private ProjectLevelVcsManager myVcsManager;
    private boolean myInitialized;

    public ChangesDelta(Project project, PlusMinus<Pair<String, AbstractVcs>> deltaListener) {
        this.myDeltaListener = deltaListener;
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
    }

    public boolean step(ChangeListsIndexes was, ChangeListsIndexes became) {
        List<Pair<String, VcsKey>> wasAffected = was.getAffectedFilesUnderVcs();
        if (!this.myInitialized) {
            this.sendPlus(wasAffected);
            this.myInitialized = true;
            return true;
        }
        List<Pair<String, VcsKey>> becameAffected = became.getAffectedFilesUnderVcs();
        Set<Pair<String, VcsKey>> toRemove = CollectionsDelta.notInSecond(wasAffected, becameAffected);
        Set<Pair<String, VcsKey>> toAdd = CollectionsDelta.notInSecond(becameAffected, wasAffected);
        if (toRemove != null) {
            for (Pair<String, VcsKey> pair : toRemove) {
                this.myDeltaListener.minus(this.convertPair(pair));
            }
        }
        this.sendPlus(toAdd);
        return toRemove != null || toAdd != null;
    }

    private void sendPlus(Collection<Pair<String, VcsKey>> toAdd) {
        if (toAdd != null) {
            for (Pair<String, VcsKey> pair : toAdd) {
                this.myDeltaListener.plus(this.convertPair(pair));
            }
        }
    }

    private Pair<String, AbstractVcs> convertPair(Pair<String, VcsKey> pair) {
        VcsKey vcsKey = (VcsKey)pair.getSecond();
        return new Pair(pair.getFirst(), vcsKey == null ? null : this.myVcsManager.findVcsByName(vcsKey.getName()));
    }
}

