/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.StandardVcsGroup;
import com.intellij.openapi.vcs.actions.VcsContextWrapper;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class VcsGroupsWrapper
extends DefaultActionGroup {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.actions.DefaultActionGroup");
    private final PresentationFactory myPresentationFactory = new PresentationFactory();
    private AnAction[] myChildren;

    /*
     * WARNING - void declaration
     */
    public void update(AnActionEvent e) {
        VcsContextWrapper dataContext = VcsContextWrapper.createInstanceOn(e);
        if (this.myChildren == null) {
            AnAction[] children;
            DefaultActionGroup vcsGroupsGroup = (DefaultActionGroup)ActionManager.getInstance().getAction("VcsGroup");
            ArrayList<AnAction> validChildren = new ArrayList<AnAction>();
            for (AnAction child : children = vcsGroupsGroup.getChildren(new AnActionEvent(null, e.getDataContext(), e.getPlace(), this.myPresentationFactory.getPresentation((AnAction)vcsGroupsGroup), ActionManager.getInstance(), 0))) {
                if (!(child instanceof StandardVcsGroup)) {
                    LOG.error("Any version control group should extends com.intellij.openapi.vcs.actions.StandardVcsGroup class. Groupd class: " + child.getClass().getName() + ", group ID: " + ActionManager.getInstance().getId(child));
                    continue;
                }
                validChildren.add(child);
            }
            this.myChildren = validChildren.toArray(new AnAction[validChildren.size()]);
        }
        Project project = dataContext.getProject();
        Presentation presentation = e.getPresentation();
        if (project == null) {
            presentation.setVisible(false);
            return;
        }
        HashSet<String> currentVcses = new HashSet<String>();
        VirtualFile[] selectedFiles = dataContext.getSelectedFiles();
        ProjectLevelVcsManager projectLevelVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        HashMap<String, StandardVcsGroup> vcsToActionMap = new HashMap<String, StandardVcsGroup>();
        for (AnAction anAction : this.myChildren) {
            StandardVcsGroup child = (StandardVcsGroup)anAction;
            String vcsName = child.getVcsName(project);
            vcsToActionMap.put(vcsName, child);
        }
        if (selectedFiles != null) {
            for (AnAction anAction : selectedFiles) {
                AbstractVcs vcs = projectLevelVcsManager.getVcsFor((VirtualFile)anAction);
                if (vcs == null) continue;
                currentVcses.add(vcs.getName());
            }
        }
        if (currentVcses.size() == 1 && vcsToActionMap.containsKey(currentVcses.iterator().next())) {
            this.updateFromAction((AnAction)vcsToActionMap.get(currentVcses.iterator().next()), presentation);
        } else {
            void var12_19;
            DefaultActionGroup composite = new DefaultActionGroup(VcsBundle.message((String)"group.name.version.control", (Object[])new Object[0]), true);
            AnAction[] arr$ = this.myChildren;
            int len$ = arr$.length;
            boolean bl = false;
            while (var12_19 < len$) {
                AnAction aMyChildren = arr$[var12_19];
                StandardVcsGroup child = (StandardVcsGroup)aMyChildren;
                String vcsName = child.getVcsName(project);
                if (currentVcses.contains(vcsName)) {
                    composite.add((AnAction)child);
                }
                ++var12_19;
            }
            this.updateFromAction((AnAction)composite, presentation);
            if (currentVcses.size() == 0) {
                e.getPresentation().setVisible(false);
            }
        }
        super.update(e);
    }

    private void updateFromAction(AnAction action, Presentation presentation) {
        Presentation wrappedActionPresentation = this.myPresentationFactory.getPresentation(action);
        presentation.setDescription(wrappedActionPresentation.getDescription());
        presentation.restoreTextWithMnemonic(wrappedActionPresentation);
        presentation.setVisible(wrappedActionPresentation.isVisible());
        presentation.setEnabled(wrappedActionPresentation.isEnabled());
        this.removeAll();
        DefaultActionGroup wrappedGroup = (DefaultActionGroup)action;
        for (AnAction aChildren : wrappedGroup.getChildren(null)) {
            this.add(aChildren);
        }
    }
}

