/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback.commands;

import com.intellij.openapi.ui.TypingTarget;
import com.intellij.openapi.ui.playback.PlaybackRunner;
import com.intellij.openapi.ui.playback.commands.AlphaNumericTypeCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Pair;
import java.awt.Robot;
import java.util.ArrayList;
import java.util.List;

public class KeyCodeTypeCommand
extends AlphaNumericTypeCommand {
    public static final String PREFIX = CMD_PREFIX + "type";
    public static final String CODE_DELIMITER = ";";
    public static final String MODIFIER_DELIMITER = ":";

    public KeyCodeTypeCommand(String text, int line) {
        super(text, line);
    }

    @Override
    public ActionCallback _execute(final PlaybackRunner.StatusCallback cb, final Robot robot, boolean directActionCall) {
        String text = this.getText().substring(PREFIX.length()).trim();
        int textDelim = text.indexOf(" ");
        final String codes = textDelim >= 0 ? text.substring(0, textDelim) : text;
        String unicode = codes.length() + 1 < text.length() ? text.substring(textDelim + 1) : "";
        final ActionCallback result = new ActionCallback();
        TypingTarget typingTarget = KeyCodeTypeCommand.findTarget();
        if (typingTarget != null) {
            typingTarget.type(unicode).doWhenDone(new Runnable(){

                @Override
                public void run() {
                    result.setDone();
                }
            }).doWhenRejected(new Runnable(){

                @Override
                public void run() {
                    KeyCodeTypeCommand.this.typeCodes(cb, robot, codes).notify(result);
                }
            });
        } else {
            this.typeCodes(cb, robot, codes).notify(result);
        }
        return result;
    }

    private ActionCallback typeCodes(PlaybackRunner.StatusCallback cb, Robot robot, String codes) {
        String[] pairs;
        for (String eachPair : pairs = codes.split(CODE_DELIMITER)) {
            try {
                String[] splits = eachPair.split(MODIFIER_DELIMITER);
                Integer code = Integer.valueOf(splits[0]);
                Integer modifier = Integer.valueOf(splits[1]);
                this.type(robot, code, modifier);
            }
            catch (NumberFormatException e) {
                this.dumpError(cb, "Invalid code: " + eachPair);
                return new ActionCallback.Rejected();
            }
        }
        return new ActionCallback.Done();
    }

    public static Pair<List<Integer>, List<Integer>> parseKeyCodes(String keyCodesText) {
        ArrayList<Integer> codes = new ArrayList<Integer>();
        ArrayList<Integer> modifiers = new ArrayList<Integer>();
        if (keyCodesText != null) {
            String[] pairs;
            for (String each : pairs = keyCodesText.split(CODE_DELIMITER)) {
                String[] strings = each.split(MODIFIER_DELIMITER);
                if (strings.length != 2) continue;
                codes.add(Integer.valueOf(strings[0]));
                modifiers.add(Integer.valueOf(strings[1]));
            }
        }
        return new Pair(codes, modifiers);
    }

    public static String unparseKeyCodes(Pair<List<Integer>, List<Integer>> pairs) {
        StringBuffer result = new StringBuffer();
        List codes = (List)pairs.getFirst();
        List modifiers = (List)pairs.getSecond();
        for (int i = 0; i < codes.size(); ++i) {
            Integer each = (Integer)codes.get(i);
            result.append(each.toString());
            result.append(MODIFIER_DELIMITER);
            result.append(modifiers.get(i));
            if (i >= codes.size() - 1) continue;
            result.append(CODE_DELIMITER);
        }
        return result.toString();
    }
}

