/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorListener;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseLibrariesConfigurable;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class LibrariesModifiableModel
implements LibraryTable.ModifiableModel {
    private final Map<Library, LibraryEditor> myLibrary2EditorMap = new HashMap<Library, LibraryEditor>();
    private final Set<Library> myRemovedLibraries = new HashSet<Library>();
    private LibraryTable.ModifiableModel myLibrariesModifiableModel;
    private final Project myProject;
    private LibraryTable myTable;
    private final LibraryEditorListener myLibraryEditorListener;

    public LibrariesModifiableModel(LibraryTable table, Project project, LibraryEditorListener libraryEditorListener) {
        this.myProject = project;
        this.myTable = table;
        this.myLibraryEditorListener = libraryEditorListener;
    }

    public Library createLibrary(String name) {
        Library library = this.getLibrariesModifiableModel().createLibrary(name);
        BaseLibrariesConfigurable configurable = ProjectStructureConfigurable.getInstance(this.myProject).getConfigurableFor(library);
        configurable.createLibraryNode(library);
        return library;
    }

    public void removeLibrary(@NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesModifiableModel.removeLibrary must not be null");
        }
        if (this.getLibrariesModifiableModel().getLibraryByName(library.getName()) == null) {
            return;
        }
        this.removeLibraryEditor(library);
        Library existingLibrary = this.myTable.getLibraryByName(library.getName());
        this.getLibrariesModifiableModel().removeLibrary(library);
        if (existingLibrary == library) {
            this.myRemovedLibraries.add(library);
        } else {
            Disposer.dispose((Disposable)library);
        }
    }

    public void commit() {
    }

    @NotNull
    public Iterator<Library> getLibraryIterator() {
        Iterator iterator = this.getLibrariesModifiableModel().getLibraryIterator();
        if (iterator == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesModifiableModel.getLibraryIterator must not return null");
        }
        return iterator;
    }

    public Library getLibraryByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesModifiableModel.getLibraryByName must not be null");
        }
        return this.getLibrariesModifiableModel().getLibraryByName(name);
    }

    @NotNull
    public Library[] getLibraries() {
        Library[] libraryArray = this.getLibrariesModifiableModel().getLibraries();
        if (libraryArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/projectRoot/LibrariesModifiableModel.getLibraries must not return null");
        }
        return libraryArray;
    }

    public boolean isChanged() {
        for (LibraryEditor libraryEditor : this.myLibrary2EditorMap.values()) {
            if (!libraryEditor.hasChanges()) continue;
            return true;
        }
        return this.getLibrariesModifiableModel().isChanged();
    }

    public void deferredCommit() {
        for (LibraryEditor libraryEditor : new ArrayList<LibraryEditor>(this.myLibrary2EditorMap.values())) {
            libraryEditor.commit();
            Disposer.dispose((Disposable)libraryEditor);
        }
        if (!this.myLibrary2EditorMap.isEmpty() || !this.myRemovedLibraries.isEmpty()) {
            this.getLibrariesModifiableModel().commit();
            this.myLibrariesModifiableModel = null;
        }
        this.myLibrary2EditorMap.clear();
        this.myRemovedLibraries.clear();
    }

    public boolean wasLibraryRemoved(Library library) {
        return this.myRemovedLibraries.contains(library);
    }

    public boolean hasLibraryEditor(Library library) {
        return this.myLibrary2EditorMap.containsKey(library);
    }

    public LibraryEditor getLibraryEditor(Library library) {
        Library source = ((LibraryImpl)library).getSource();
        if (source != null) {
            return this.getLibraryEditor(source);
        }
        LibraryEditor libraryEditor = this.myLibrary2EditorMap.get(library);
        if (libraryEditor == null) {
            libraryEditor = this.createLibraryEditor(library);
        }
        return libraryEditor;
    }

    private LibraryEditor createLibraryEditor(Library library) {
        LibraryEditor libraryEditor = new LibraryEditor(library, this.myLibraryEditorListener);
        this.myLibrary2EditorMap.put(library, libraryEditor);
        return libraryEditor;
    }

    private void removeLibraryEditor(Library library) {
        LibraryEditor libraryEditor = this.myLibrary2EditorMap.remove(library);
        if (libraryEditor != null) {
            Disposer.dispose((Disposable)libraryEditor);
        }
    }

    public Library.ModifiableModel getLibraryModifiableModel(Library library) {
        return this.getLibraryEditor(library).getModel();
    }

    private LibraryTable.ModifiableModel getLibrariesModifiableModel() {
        if (this.myLibrariesModifiableModel == null) {
            this.myLibrariesModifiableModel = this.myTable.getModifiableModel();
        }
        return this.myLibrariesModifiableModel;
    }

    public void disposeUncommittedLibraries() {
        for (Library library : new ArrayList<Library>(this.myLibrary2EditorMap.keySet())) {
            LibraryEditor libraryEditor;
            Library existingLibrary = this.myTable.getLibraryByName(library.getName());
            if (existingLibrary != library) {
                Disposer.dispose((Disposable)library);
            }
            if ((libraryEditor = this.myLibrary2EditorMap.get(library)) == null) continue;
            Disposer.dispose((Disposable)libraryEditor);
        }
        this.myLibrary2EditorMap.clear();
    }
}

