/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.JdkConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectJdksModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.SdkProjectStructureElement;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="JdkListConfigurable.UI", storages={@Storage(id="other", file="$WORKSPACE_FILE$")})
public class JdkListConfigurable
extends BaseStructureConfigurable {
    private final ProjectJdksModel myJdksTreeModel;
    SdkModel.Listener myListener = new SdkModel.Listener(){

        public void sdkAdded(Sdk sdk) {
        }

        public void beforeSdkRemove(Sdk sdk) {
        }

        public void sdkChanged(Sdk sdk, String previousName) {
            this.updateName();
        }

        public void sdkHomeSelected(Sdk sdk, String newSdkHome) {
            this.updateName();
        }

        private void updateName() {
            NamedConfigurable configurable;
            TreePath path = JdkListConfigurable.this.myTree.getSelectionPath();
            if (path != null && (configurable = ((MasterDetailsComponent.MyNode)path.getLastPathComponent()).getConfigurable()) != null && configurable instanceof JdkConfigurable) {
                configurable.updateName();
            }
        }
    };

    public JdkListConfigurable(Project project, ProjectStructureConfigurable root) {
        super(project);
        this.myJdksTreeModel = root.getProjectJdksModel();
        this.myJdksTreeModel.addListener(this.myListener);
    }

    protected void processRemovedItems() {
    }

    protected boolean wasObjectStored(Object editableObject) {
        return false;
    }

    @Nls
    public String getDisplayName() {
        return "SDKs";
    }

    @Nullable
    public Icon getIcon() {
        return null;
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "reference.settingsdialog.project.structure.jdk";
    }

    @NonNls
    public String getId() {
        return "jdk.list";
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    @Override
    protected void loadTree() {
        HashMap<Sdk, Sdk> sdks = this.myJdksTreeModel.getProjectJdks();
        for (Sdk sdk : sdks.keySet()) {
            JdkConfigurable configurable = new JdkConfigurable((ProjectJdkImpl)sdks.get(sdk), this.myJdksTreeModel, this.TREE_UPDATER, this.myHistory, this.myProject);
            this.addNode(new MasterDetailsComponent.MyNode((NamedConfigurable)configurable), this.myRoot);
        }
    }

    @Override
    @NotNull
    protected Collection<? extends ProjectStructureElement> getProjectStructureElements() {
        ArrayList<SdkProjectStructureElement> result = new ArrayList<SdkProjectStructureElement>();
        for (Sdk sdk : this.myJdksTreeModel.getProjectJdks().values()) {
            result.add(new SdkProjectStructureElement(this.myContext, sdk));
        }
        ArrayList<SdkProjectStructureElement> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/projectRoot/JdkListConfigurable.getProjectStructureElements must not return null");
        }
        return arrayList;
    }

    public boolean addJdkNode(Sdk jdk, boolean selectInTree) {
        if (!this.myUiDisposed) {
            this.myContext.getDaemonAnalyzer().queueUpdate(new SdkProjectStructureElement(this.myContext, jdk));
            this.addNode(new MasterDetailsComponent.MyNode((NamedConfigurable)new JdkConfigurable((ProjectJdkImpl)jdk, this.myJdksTreeModel, this.TREE_UPDATER, this.myHistory, this.myProject)), this.myRoot);
            if (selectInTree) {
                this.selectNodeInTree((DefaultMutableTreeNode)MasterDetailsComponent.findNodeByObject((TreeNode)this.myRoot, (Object)jdk));
            }
            return true;
        }
        return false;
    }

    public void dispose() {
        this.myJdksTreeModel.removeListener(this.myListener);
        this.myJdksTreeModel.disposeUIResources();
    }

    public ProjectJdksModel getJdksTreeModel() {
        return this.myJdksTreeModel;
    }

    @Override
    public void reset() {
        super.reset();
        this.myTree.setRootVisible(false);
    }

    public void apply() throws ConfigurationException {
        boolean modifiedJdks = false;
        for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
            NamedConfigurable configurable = ((MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i)).getConfigurable();
            if (!configurable.isModified()) continue;
            configurable.apply();
            modifiedJdks = true;
        }
        if (this.myJdksTreeModel.isModified() || modifiedJdks) {
            this.myJdksTreeModel.apply(this);
        }
        this.myJdksTreeModel.setProjectJdk(ProjectRootManager.getInstance((Project)this.myProject).getProjectJdk());
    }

    public boolean isModified() {
        return super.isModified() || this.myJdksTreeModel.isModified();
    }

    public static JdkListConfigurable getInstance(Project project) {
        return (JdkListConfigurable)ShowSettingsUtil.getInstance().findProjectConfigurable(project, JdkListConfigurable.class);
    }

    @Override
    public BaseStructureConfigurable.AbstractAddGroup createAddAction() {
        return new BaseStructureConfigurable.AbstractAddGroup(ProjectBundle.message((String)"add.new.jdk.text", (Object[])new Object[0])){

            public AnAction[] getChildren(@Nullable AnActionEvent e) {
                DefaultActionGroup group = new DefaultActionGroup(ProjectBundle.message((String)"add.new.jdk.text", (Object[])new Object[0]), true);
                JdkListConfigurable.this.myJdksTreeModel.createAddActions(group, (JComponent)JdkListConfigurable.this.myTree, new Consumer<Sdk>(){

                    public void consume(Sdk projectJdk) {
                        JdkListConfigurable.this.addJdkNode(projectJdk, true);
                    }
                });
                return group.getChildren(null);
            }
        };
    }

    @Override
    protected void removeJdk(Sdk jdk) {
        this.myJdksTreeModel.removeJdk(jdk);
        this.myContext.getDaemonAnalyzer().removeElement(new SdkProjectStructureElement(this.myContext, jdk));
    }

    @Nullable
    protected String getEmptySelectionString() {
        return "Select a JDK to view or edit its details here";
    }
}

