/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.impl.TypeSafeDataProviderAdapter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorContextImpl;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorEx;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorListener;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorSettings;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactPropertiesEditors;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactValidationManagerImpl;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.artifacts.ComplexElementSubstitutionParameters;
import com.intellij.openapi.roots.ui.configuration.artifacts.LayoutTree;
import com.intellij.openapi.roots.ui.configuration.artifacts.LayoutTreeComponent;
import com.intellij.openapi.roots.ui.configuration.artifacts.ToggleShowElementContentAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.AddCompositeElementAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.AddNewPackagingElementAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.ExtractArtifactAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.HideContentAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.InlineArtifactAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.LayoutTreeFindUsagesAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.LayoutTreeNavigateAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.MovePackagingElementAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.RemovePackagingElementAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.RenamePackagingElementAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.ShowAddPackagingElementPopupAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.SortElementsToggleAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.SurroundElementWithAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.LibrarySourceItem;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.ModuleOutputSourceItem;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.SourceItemsTree;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.elements.ComplexPackagingElementType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.elements.ArchivePackagingElement;
import com.intellij.packaging.impl.elements.ManifestFileUtil;
import com.intellij.packaging.ui.ManifestFileConfiguration;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.TreeToolTipHandler;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Icons;
import com.intellij.util.ui.ThreeStateCheckBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactEditorImpl
implements ArtifactEditorEx {
    private JPanel myMainPanel;
    private JCheckBox myBuildOnMakeCheckBox;
    private TextFieldWithBrowseButton myOutputDirectoryField;
    private JPanel myEditorPanel;
    private JPanel myErrorPanelPlace;
    private ThreeStateCheckBox myShowContentCheckBox;
    private FixedSizeButton myShowSpecificContentOptionsButton;
    private ActionGroup myShowSpecificContentOptionsGroup;
    private final Project myProject;
    private final ComplexElementSubstitutionParameters mySubstitutionParameters;
    private final EventDispatcher<ArtifactEditorListener> myDispatcher;
    private final ArtifactEditorContextImpl myContext;
    private SourceItemsTree mySourceItemsTree;
    private final Artifact myOriginalArtifact;
    private final LayoutTreeComponent myLayoutTreeComponent;
    private TabbedPaneWrapper myTabbedPane;
    private ArtifactPropertiesEditors myPropertiesEditors;
    private ArtifactValidationManagerImpl myValidationManager;
    private boolean myDisposed;

    public ArtifactEditorImpl(@NotNull ArtifactsStructureConfigurableContext context, @NotNull Artifact artifact, @NotNull ArtifactEditorSettings settings) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorImpl.<init> must not be null");
        }
        if (artifact == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorImpl.<init> must not be null");
        }
        if (settings == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorImpl.<init> must not be null");
        }
        this.$$$setupUI$$$();
        this.mySubstitutionParameters = new ComplexElementSubstitutionParameters();
        this.myDispatcher = EventDispatcher.create(ArtifactEditorListener.class);
        this.myContext = this.createArtifactEditorContext(context);
        this.myOriginalArtifact = artifact;
        this.myProject = context.getProject();
        this.mySubstitutionParameters.setTypesToShowContent(settings.getTypesToShowContent());
        this.mySourceItemsTree = new SourceItemsTree(this.myContext, this);
        this.myLayoutTreeComponent = new LayoutTreeComponent(this, this.mySubstitutionParameters, this.myContext, this.myOriginalArtifact, settings.isSortElements());
        this.myPropertiesEditors = new ArtifactPropertiesEditors(this.myContext, this.myOriginalArtifact, this.myOriginalArtifact);
        Disposer.register((Disposable)this, (Disposable)this.mySourceItemsTree);
        Disposer.register((Disposable)this, (Disposable)this.myLayoutTreeComponent);
        this.myBuildOnMakeCheckBox.setSelected(artifact.isBuildOnMake());
        String outputPath = artifact.getOutputPath();
        this.myOutputDirectoryField.addBrowseFolderListener(CompilerBundle.message((String)"dialog.title.output.directory.for.artifact", (Object[])new Object[0]), CompilerBundle.message((String)"chooser.description.select.output.directory.for.0.artifact", (Object[])new Object[]{this.getArtifact().getName()}), this.myProject, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myShowSpecificContentOptionsGroup = this.createShowSpecificContentOptionsGroup();
        this.myShowSpecificContentOptionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionManager.getInstance().createActionPopupMenu("unknown", ArtifactEditorImpl.this.myShowSpecificContentOptionsGroup).getComponent().show((Component)ArtifactEditorImpl.this.myShowSpecificContentOptionsButton, 0, 0);
            }
        });
        this.setOutputPath(outputPath);
        this.myValidationManager = new ArtifactValidationManagerImpl(this);
        this.updateShowContentCheckbox();
    }

    protected ArtifactEditorContextImpl createArtifactEditorContext(ArtifactsStructureConfigurableContext parentContext) {
        return new ArtifactEditorContextImpl(parentContext, this);
    }

    private ActionGroup createShowSpecificContentOptionsGroup() {
        DefaultActionGroup group = new DefaultActionGroup();
        for (ComplexPackagingElementType type : PackagingElementFactory.getInstance().getComplexElementTypes()) {
            group.add((AnAction)new ToggleShowElementContentAction(type, this));
        }
        return group;
    }

    private void setOutputPath(@Nullable String outputPath) {
        this.myOutputDirectoryField.setText(outputPath != null ? FileUtil.toSystemDependentName((String)outputPath) : null);
    }

    public void apply() {
        ModifiableArtifact modifiableArtifact = this.myContext.getOrCreateModifiableArtifactModel().getOrCreateModifiableArtifact(this.myOriginalArtifact);
        modifiableArtifact.setBuildOnMake(this.myBuildOnMakeCheckBox.isSelected());
        modifiableArtifact.setOutputPath(this.getConfiguredOutputPath());
        this.myPropertiesEditors.applyProperties();
        this.myLayoutTreeComponent.saveElementProperties();
    }

    @Nullable
    private String getConfiguredOutputPath() {
        String outputPath = FileUtil.toSystemIndependentName((String)this.myOutputDirectoryField.getText().trim());
        if (outputPath.length() == 0) {
            outputPath = null;
        }
        return outputPath;
    }

    public SourceItemsTree getSourceItemsTree() {
        return this.mySourceItemsTree;
    }

    public void addListener(@NotNull ArtifactEditorListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorImpl.addListener must not be null");
        }
        this.myDispatcher.addListener((EventListener)listener);
    }

    @Override
    public ArtifactEditorContextImpl getContext() {
        return this.myContext;
    }

    public void removeListener(@NotNull ArtifactEditorListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorImpl.removeListener must not be null");
        }
        this.myDispatcher.removeListener((EventListener)listener);
    }

    @Override
    public Artifact getArtifact() {
        return this.myContext.getArtifactModel().getArtifactByOriginal(this.myOriginalArtifact);
    }

    @Override
    public CompositePackagingElement<?> getRootElement() {
        return this.myLayoutTreeComponent.getRootElement();
    }

    @Override
    public void rebuildTries() {
        this.myLayoutTreeComponent.rebuildTree();
        this.mySourceItemsTree.rebuildTree();
    }

    @Override
    public void queueValidation() {
        this.myContext.queueValidation();
    }

    public JComponent createMainComponent() {
        this.mySourceItemsTree.initTree();
        this.myLayoutTreeComponent.initTree();
        this.myMainPanel.putClientProperty("DataProvider", new TypeSafeDataProviderAdapter(new MyDataProvider()));
        this.myErrorPanelPlace.add((Component)this.myValidationManager.getMainErrorPanel(), "Center");
        Splitter splitter = new Splitter(false);
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add((Component)this.myLayoutTreeComponent.getTreePanel(), "Center");
        Border border = BorderFactory.createEmptyBorder(3, 3, 3, 3);
        leftPanel.setBorder(border);
        splitter.setFirstComponent((JComponent)leftPanel);
        JPanel rightPanel = new JPanel(new BorderLayout());
        JPanel rightTopPanel = new JPanel(new BorderLayout());
        JPanel labelPanel = new JPanel(new FlowLayout(0, 0, 0));
        labelPanel.add(new JLabel("Available Elements"));
        final HyperlinkLabel link = new HyperlinkLabel("");
        link.setIcon(IconLoader.getIcon((String)"/general/help.png"));
        link.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    JLabel label = new JLabel(ProjectBundle.message((String)"artifact.source.items.tree.tooltip", (Object[])new Object[0]));
                    label.setBorder(HintUtil.createHintBorder());
                    label.setBackground(HintUtil.INFORMATION_COLOR);
                    label.setOpaque(true);
                    HintManager.getInstance().showHint((JComponent)label, RelativePoint.getSouthEastOf((JComponent)link), 10, -1);
                }
            }
        });
        labelPanel.add((Component)link);
        rightTopPanel.add((Component)labelPanel, "South");
        rightPanel.add((Component)rightTopPanel, "North");
        rightPanel.add((Component)ScrollPaneFactory.createScrollPane((JComponent)((Object)this.mySourceItemsTree)), "Center");
        rightPanel.setBorder(border);
        splitter.setSecondComponent((JComponent)rightPanel);
        this.myShowContentCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThreeStateCheckBox.State state = ArtifactEditorImpl.this.myShowContentCheckBox.getState();
                if (state == ThreeStateCheckBox.State.SELECTED) {
                    ArtifactEditorImpl.this.mySubstitutionParameters.setSubstituteAll();
                } else if (state == ThreeStateCheckBox.State.NOT_SELECTED) {
                    ArtifactEditorImpl.this.mySubstitutionParameters.setSubstituteNone();
                }
                ArtifactEditorImpl.this.myShowContentCheckBox.setThirdStateEnabled(false);
                ArtifactEditorImpl.this.myLayoutTreeComponent.rebuildTree();
                ArtifactEditorImpl.this.onShowContentSettingsChanged();
            }
        });
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)this.createToolbarActionGroup(), true);
        leftPanel.add((Component)toolbar.getComponent(), "North");
        rightTopPanel.setPreferredSize(new Dimension(-1, toolbar.getComponent().getPreferredSize().height));
        this.myTabbedPane = new TabbedPaneWrapper(this);
        this.myTabbedPane.addTab("Output Layout", (JComponent)splitter);
        this.myPropertiesEditors.addTabs(this.myTabbedPane);
        this.myEditorPanel.add((Component)this.myTabbedPane.getComponent(), "Center");
        LayoutTree tree = this.myLayoutTreeComponent.getLayoutTree();
        new ShowAddPackagingElementPopupAction(this).registerCustomShortcutSet(CommonShortcuts.getNew(), (JComponent)((Object)tree));
        PopupHandler.installPopupHandler((JComponent)((Object)tree), (ActionGroup)this.createPopupActionGroup(), (String)"unknown", (ActionManager)ActionManager.getInstance());
        TreeToolTipHandler.install((JTree)((Object)tree));
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)tree));
        this.rebuildTries();
        return this.getMainComponent();
    }

    private void onShowContentSettingsChanged() {
        this.myContext.getParent().getDefaultSettings().setTypesToShowContent(this.mySubstitutionParameters.getTypesToSubstitute());
    }

    public void updateShowContentCheckbox() {
        ThreeStateCheckBox.State state = this.mySubstitutionParameters.isAllSubstituted() ? ThreeStateCheckBox.State.SELECTED : (this.mySubstitutionParameters.isNoneSubstituted() ? ThreeStateCheckBox.State.NOT_SELECTED : ThreeStateCheckBox.State.DONT_CARE);
        this.myShowContentCheckBox.setThirdStateEnabled(state == ThreeStateCheckBox.State.DONT_CARE);
        this.myShowContentCheckBox.setState(state);
        this.onShowContentSettingsChanged();
    }

    public ArtifactEditorSettings createSettings() {
        return new ArtifactEditorSettings(this.myLayoutTreeComponent.isSortElements(), this.mySubstitutionParameters.getTypesToSubstitute());
    }

    private DefaultActionGroup createToolbarActionGroup() {
        DefaultActionGroup toolbarActionGroup = new DefaultActionGroup();
        ArrayList<AnAction> createActions = new ArrayList<AnAction>(this.createNewElementActions());
        for (AnAction createAction : createActions) {
            toolbarActionGroup.add(createAction);
        }
        toolbarActionGroup.add((AnAction)new RemovePackagingElementAction(this));
        toolbarActionGroup.add((AnAction)Separator.getInstance());
        toolbarActionGroup.add((AnAction)new SortElementsToggleAction(this.getLayoutTreeComponent()));
        toolbarActionGroup.add((AnAction)new MovePackagingElementAction(this.myLayoutTreeComponent, "Move Up", "", IconLoader.getIcon((String)"/actions/moveUp.png"), -1));
        toolbarActionGroup.add((AnAction)new MovePackagingElementAction(this.myLayoutTreeComponent, "Move Down", "", IconLoader.getIcon((String)"/actions/moveDown.png"), 1));
        return toolbarActionGroup;
    }

    public List<AnAction> createNewElementActions() {
        ArrayList<AnAction> createActions = new ArrayList<AnAction>();
        AddCompositeElementAction.addCompositeCreateActions(createActions, this);
        createActions.add((AnAction)this.createAddNonCompositeElementGroup());
        return createActions;
    }

    private DefaultActionGroup createPopupActionGroup() {
        LayoutTree tree = this.myLayoutTreeComponent.getLayoutTree();
        DefaultActionGroup popupActionGroup = new DefaultActionGroup();
        ArrayList<AnAction> createActions = new ArrayList<AnAction>();
        AddCompositeElementAction.addCompositeCreateActions(createActions, this);
        for (AnAction createAction : createActions) {
            popupActionGroup.add(createAction);
        }
        popupActionGroup.add((AnAction)this.createAddNonCompositeElementGroup());
        RemovePackagingElementAction removeAction = new RemovePackagingElementAction(this);
        removeAction.registerCustomShortcutSet(CommonShortcuts.DELETE, (JComponent)((Object)tree));
        popupActionGroup.add((AnAction)removeAction);
        popupActionGroup.add((AnAction)new ExtractArtifactAction(this));
        popupActionGroup.add((AnAction)new InlineArtifactAction(this));
        popupActionGroup.add((AnAction)new RenamePackagingElementAction(this));
        popupActionGroup.add((AnAction)new SurroundElementWithAction(this));
        popupActionGroup.add((AnAction)Separator.getInstance());
        popupActionGroup.add((AnAction)new HideContentAction(this));
        popupActionGroup.add((AnAction)new LayoutTreeNavigateAction(this.myLayoutTreeComponent));
        popupActionGroup.add((AnAction)new LayoutTreeFindUsagesAction(this.myLayoutTreeComponent, this.myProject, this.myContext.getParent()));
        popupActionGroup.add((AnAction)Separator.getInstance());
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        DefaultTreeExpander treeExpander = new DefaultTreeExpander((JTree)((Object)tree));
        popupActionGroup.add(actionsManager.createExpandAllAction((TreeExpander)treeExpander, (JComponent)((Object)tree)));
        popupActionGroup.add(actionsManager.createCollapseAllAction((TreeExpander)treeExpander, (JComponent)((Object)tree)));
        return popupActionGroup;
    }

    @Override
    public ComplexElementSubstitutionParameters getSubstitutionParameters() {
        return this.mySubstitutionParameters;
    }

    private ActionGroup createAddNonCompositeElementGroup() {
        DefaultActionGroup group = new DefaultActionGroup(ProjectBundle.message((String)"artifacts.add.copy.action", (Object[])new Object[0]), true);
        group.getTemplatePresentation().setIcon(Icons.ADD_ICON);
        for (PackagingElementType type : PackagingElementFactory.getInstance().getNonCompositeElementTypes()) {
            group.add((AnAction)new AddNewPackagingElementAction(type, this));
        }
        return group;
    }

    @Override
    public JComponent getMainComponent() {
        return this.myMainPanel;
    }

    @Override
    public void addNewPackagingElement(@NotNull PackagingElementType<?> type) {
        if (type == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorImpl.addNewPackagingElement must not be null");
        }
        this.myLayoutTreeComponent.addNewPackagingElement(type);
        this.mySourceItemsTree.rebuildTree();
    }

    @Override
    public void removeSelectedElements() {
        this.myLayoutTreeComponent.removeSelectedElements();
    }

    public boolean isModified() {
        return this.myBuildOnMakeCheckBox.isSelected() != this.myOriginalArtifact.isBuildOnMake() || !Comparing.equal((String)this.getConfiguredOutputPath(), (String)this.myOriginalArtifact.getOutputPath()) || this.myPropertiesEditors.isModified() || this.myLayoutTreeComponent.isPropertiesModified();
    }

    public void dispose() {
        this.myDisposed = true;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    @Override
    public LayoutTreeComponent getLayoutTreeComponent() {
        return this.myLayoutTreeComponent;
    }

    public void updateOutputPath(@NotNull String oldArtifactName, final @NotNull String newArtifactName) {
        if (oldArtifactName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorImpl.updateOutputPath must not be null");
        }
        if (newArtifactName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorImpl.updateOutputPath must not be null");
        }
        String oldDefaultPath = ArtifactUtil.getDefaultArtifactOutputPath(oldArtifactName, this.myProject);
        if (Comparing.equal((String)oldDefaultPath, (String)this.getConfiguredOutputPath())) {
            this.setOutputPath(ArtifactUtil.getDefaultArtifactOutputPath(newArtifactName, this.myProject));
            CompositePackagingElement<?> root = this.getRootElement();
            if (root instanceof ArchivePackagingElement) {
                String oldFileName = FileUtil.sanitizeFileName((String)oldArtifactName);
                String name = ((ArchivePackagingElement)root).getArchiveFileName();
                String fileName = FileUtil.getNameWithoutExtension((String)name);
                final String extension = FileUtil.getExtension((String)name);
                if (fileName.equals(oldFileName) && extension.length() > 0) {
                    this.myLayoutTreeComponent.editLayout(new Runnable(){

                        @Override
                        public void run() {
                            ((ArchivePackagingElement)ArtifactEditorImpl.this.getRootElement()).setArchiveFileName(FileUtil.sanitizeFileName((String)newArtifactName) + "." + extension);
                        }
                    });
                    this.myLayoutTreeComponent.updateRootNode();
                }
            }
        }
    }

    public void updateLayoutTree() {
        this.myLayoutTreeComponent.rebuildTree();
    }

    public void putLibraryIntoDefaultLocation(@NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorImpl.putLibraryIntoDefaultLocation must not be null");
        }
        this.myLayoutTreeComponent.putIntoDefaultLocations(Collections.singletonList(new LibrarySourceItem(library)));
    }

    public void putModuleIntoDefaultLocation(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorImpl.putModuleIntoDefaultLocation must not be null");
        }
        this.myLayoutTreeComponent.putIntoDefaultLocations(Collections.singletonList(new ModuleOutputSourceItem(module)));
    }

    public void addToClasspath(CompositePackagingElement<?> element, List<String> classpath) {
        this.myLayoutTreeComponent.saveElementProperties();
        ManifestFileConfiguration manifest = this.myContext.getManifestFile(element, this.getArtifact().getArtifactType());
        if (manifest == null) {
            VirtualFile file = ManifestFileUtil.showDialogAndCreateManifest(this.myContext, element);
            if (file == null) {
                return;
            }
            ManifestFileUtil.addManifestFileToLayout(file.getPath(), this.myContext, element);
            manifest = this.myContext.getManifestFile(element, this.getArtifact().getArtifactType());
        }
        if (manifest != null) {
            manifest.addToClasspath(classpath);
        }
        this.myLayoutTreeComponent.resetElementProperties();
    }

    public void setArtifactType(ArtifactType artifactType) {
        ModifiableArtifact modifiableArtifact = this.myContext.getOrCreateModifiableArtifactModel().getOrCreateModifiableArtifact(this.myOriginalArtifact);
        modifiableArtifact.setArtifactType(artifactType);
        this.myPropertiesEditors.removeTabs(this.myTabbedPane);
        this.myPropertiesEditors = new ArtifactPropertiesEditors(this.myContext, this.myOriginalArtifact, this.getArtifact());
        this.myPropertiesEditors.addTabs(this.myTabbedPane);
        CompositePackagingElement<?> oldRootElement = this.getRootElement();
        CompositePackagingElement newRootElement = artifactType.createRootElement(this.getArtifact().getName());
        ArtifactUtil.copyChildren(oldRootElement, newRootElement, this.myProject);
        this.myLayoutTreeComponent.setRootElement(newRootElement);
    }

    public ArtifactValidationManagerImpl getValidationManager() {
        return this.myValidationManager;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        FixedSizeButton fixedSizeButton;
        ThreeStateCheckBox threeStateCheckBox;
        JPanel jPanel;
        JPanel jPanel2;
        JCheckBox jCheckBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel3;
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ProjectBundle").getString("label.text.output.directory"));
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOutputDirectoryField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel4.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myBuildOnMakeCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/ProjectBundle").getString("checkbox.text.build.on.make"));
        jPanel5.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myEditorPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        ((Component)jPanel2).setEnabled(true);
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myErrorPanelPlace = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel6, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        this.myShowContentCheckBox = threeStateCheckBox = new ThreeStateCheckBox();
        threeStateCheckBox.setText("Show content of elements");
        jPanel6.add((Component)threeStateCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myShowSpecificContentOptionsButton = fixedSizeButton = new FixedSizeButton();
        jPanel6.add((Component)fixedSizeButton, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel6.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class MyDataProvider
    implements TypeSafeDataProvider {
        private MyDataProvider() {
        }

        public void calcData(DataKey key, DataSink sink) {
            if (ArtifactEditorEx.ARTIFACTS_EDITOR_KEY.equals((Object)key)) {
                sink.put(ArtifactEditorEx.ARTIFACTS_EDITOR_KEY, (Object)ArtifactEditorImpl.this);
            }
        }
    }
}

