/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointer;
import org.jetbrains.annotations.NotNull;

public class ModulePointerImpl
implements ModulePointer {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.module.impl.ModulePointerImpl");
    private Module myModule;
    private String myModuleName;

    ModulePointerImpl(Module module) {
        this.myModule = module;
        this.myModuleName = null;
    }

    ModulePointerImpl(String name) {
        this.myModule = null;
        this.myModuleName = name;
    }

    public Module getModule() {
        return this.myModule;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getModuleName() {
        String string;
        if (this.myModule != null) {
            string = this.myModule.getName();
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/module/impl/ModulePointerImpl.getModuleName must not return null");
            return string;
        }
        string = this.myModuleName;
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/module/impl/ModulePointerImpl.getModuleName must not return null");
    }

    void moduleAdded(Module module) {
        LOG.assertTrue(this.myModule == null);
        LOG.assertTrue(this.myModuleName.equals(module.getName()));
        this.myModuleName = null;
        this.myModule = module;
    }

    void moduleRemoved(Module module) {
        LOG.assertTrue(this.myModule == module);
        this.myModuleName = this.myModule.getName();
        this.myModule = null;
    }
}

